/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.MathUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.impl.ImageFrame;
import fabric.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.awt.Color;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final String DEFAULT_BUTTON_BACKGROUND = "minecraft:" + (ModUtils.IS_LEGACY_HARD ? "/gui/gui.png" : "textures/gui/widgets.png");
    public static final String DEFAULT_GUI_BACKGROUND = "minecraft:" + (ModUtils.IS_LEGACY_HARD ? (ModUtils.IS_LEGACY_ALPHA ? "/dirt.png" : "/gui/background.png") : "textures/gui/options_background.png");
    private static final List<class_1799> BLOCKED_RENDER_ITEMS = StringUtils.newArrayList();

    public static class_2960 getScreenTextures() {
        return RenderUtils.getTextureData(DEFAULT_GUI_BACKGROUND).getThird();
    }

    public static class_2960 getButtonTextures() {
        return RenderUtils.getTextureData(DEFAULT_BUTTON_BACKGROUND).getThird();
    }

    public static boolean isMouseWithin(double mouseX, double mouseY, double topIn, double bottomIn, double leftIn, double rightIn) {
        return MathUtils.isWithinValue(mouseY, topIn, bottomIn, true, true) && MathUtils.isWithinValue(mouseX, leftIn, rightIn, true, true);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, double elementX, double elementY, double elementWidth, double elementHeight) {
        return MathUtils.isWithinValue(mouseX, elementX, elementX + elementWidth, true, false) && MathUtils.isWithinValue(mouseY, elementY, elementY + elementHeight, true, false);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedButtonControl button) {
        return button.isControlVisible() && RenderUtils.isMouseOver(mouseX, mouseY, button.getControlPosX(), button.getControlPosY(), button.getControlWidth() - 1, button.getControlHeight() - 1);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedTextControl textControl) {
        return RenderUtils.isMouseOver(mouseX, mouseY, textControl.getControlPosX(), textControl.getControlPosY(), textControl.getControlWidth() - 1, textControl.getControlHeight() - 1);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedScreen screen) {
        return screen.isLoaded() && RenderUtils.isMouseOver(mouseX, mouseY, screen.getScreenX(), screen.getScreenY(), screen.getScreenWidth(), screen.getScreenHeight());
    }

    public static boolean isMouseOver(ExtendedScreen screen) {
        return RenderUtils.isMouseOver((double)screen.getMouseX(), (double)screen.getMouseY(), screen);
    }

    public static void openScreen(@Nonnull class_310 client, class_437 targetScreen) {
        client.execute(() -> client.method_1507(targetScreen));
    }

    public static void drawItemStack(@Nonnull class_332 client, class_327 fontRenderer, int x, int y, class_1799 stack, float scale) {
        block3: {
            if (BLOCKED_RENDER_ITEMS.contains(stack)) {
                return;
            }
            try {
                class_4587 lv = client.method_51448();
                lv.method_22903();
                lv.method_22905(scale, scale, 1.0f);
                RenderSystem.enableDepthTest();
                int xPos = Math.round((float)x / scale);
                int yPos = Math.round((float)y / scale);
                client.method_51427(stack, xPos, yPos);
                client.method_51431(fontRenderer, stack, xPos, yPos);
                RenderSystem.disableDepthTest();
                lv.method_22909();
            }
            catch (Exception ex) {
                Constants.LOG.debugError(ex);
                if (BLOCKED_RENDER_ITEMS.contains(stack)) break block3;
                BLOCKED_RENDER_ITEMS.add(stack);
            }
        }
    }

    public static void drawGradientBox(double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, int borderOffset, Object contentColor, Object contentColorEnd) {
        double canvasWidth = width - (double)(border * 2);
        double canvasHeight = height - (double)(border * 2);
        double canvasRight = posX + (double)border + canvasWidth;
        double canvasBottom = posY + (double)border + canvasHeight;
        if (borderColor != null) {
            RenderUtils.drawGradient(posX, posX + (double)border, posY + (double)border, canvasBottom, zLevel, borderColor, borderColorEnd);
            RenderUtils.drawGradient(canvasRight, canvasRight + (double)border, posY + (double)border, canvasBottom, zLevel, borderColor, borderColorEnd);
            RenderUtils.drawGradient(posX - (double)borderOffset, canvasRight + (double)border + (double)borderOffset, canvasBottom, canvasBottom + (double)border, zLevel, borderColorEnd, borderColorEnd);
            RenderUtils.drawGradient(posX - (double)borderOffset, canvasRight + (double)border + (double)borderOffset, posY, posY + (double)border, zLevel, borderColor, borderColor);
        }
        if (contentColor != null) {
            RenderUtils.drawGradient(posX + (double)border, canvasRight, posY + (double)border, canvasBottom, zLevel, contentColor, contentColorEnd);
        }
    }

    public static void drawGradientBox(double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, Object contentColor, Object contentColorEnd) {
        RenderUtils.drawGradientBox(posX, posY, width, height, zLevel, borderColor, borderColorEnd, border, 0, contentColor, contentColorEnd);
    }

    public static void renderButton(@Nonnull class_310 mc, double x, double y, double startU, double startV, double endU, double endV, double width, double height, double zLevel, class_2960 texLocation) {
        try {
            if (texLocation != null) {
                Pair<Boolean, Integer> data = StringUtils.getValidInteger(texLocation);
                if (data.getFirst().booleanValue()) {
                    RenderSystem.bindTexture((int)data.getSecond());
                } else {
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderTexture((int)0, (class_2960)texLocation);
                }
            }
        }
        catch (Exception ignored) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.enableDepthTest();
        RenderUtils.blit(x, y, zLevel, startU, startV, width, height);
        RenderUtils.blit(x + width, y, zLevel, endU, endV, width, height);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void drawTexture(@Nonnull class_310 mc, double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV, Object startColorObj, Object endColorObj, class_2960 texLocation) {
        try {
            if (texLocation != null) {
                Pair<Boolean, Integer> data = StringUtils.getValidInteger(texLocation);
                if (data.getFirst().booleanValue()) {
                    RenderSystem.bindTexture((int)data.getSecond());
                } else {
                    RenderSystem.setShader(class_757::method_34543);
                    RenderSystem.setShaderTexture((int)0, (class_2960)texLocation);
                }
            }
        }
        catch (Exception ignored) {
            return;
        }
        Pair<Color, Color> colorData = StringUtils.findColor(startColorObj, endColorObj);
        Color startColor = colorData.getFirst();
        Color endColor = colorData.getSecond();
        if (startColor == null || endColor == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        buffer.method_22912(left, bottom, zLevel).method_22913((float)minU, (float)maxV).method_1336(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).method_1344();
        buffer.method_22912(right, bottom, zLevel).method_22913((float)maxU, (float)maxV).method_1336(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).method_1344();
        buffer.method_22912(right, top, zLevel).method_22913((float)maxU, (float)minV).method_1336(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).method_1344();
        buffer.method_22912(left, top, zLevel).method_22913((float)minU, (float)minV).method_1336(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void drawGradient(double left, double right, double top, double bottom, double zLevel, Object startColorObj, Object endColorObj) {
        Pair<Color, Color> colorData = StringUtils.findColor(startColorObj, endColorObj);
        Color startColor = colorData.getFirst();
        Color endColor = colorData.getSecond();
        if (startColor == null || endColor == null) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.blendFunc((int)770, (int)771);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22912(left, bottom, zLevel).method_1336(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).method_1344();
        buffer.method_22912(right, bottom, zLevel).method_1336(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).method_1344();
        buffer.method_22912(right, top, zLevel).method_1336(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).method_1344();
        buffer.method_22912(left, top, zLevel).method_1336(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    public static void blit(double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight) {
        RenderUtils.blit(xPos, yPos, zLevel, u, v, regionWidth, regionHeight, 256.0, 256.0);
    }

    public static void blit(double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight, double textureWidth, double textureHeight) {
        RenderUtils.innerBlit(xPos, xPos + regionWidth, yPos, yPos + regionHeight, zLevel, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void innerBlit(double left, double right, double top, double bottom, double zLevel, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight) {
        RenderUtils.innerBlit(left, right, top, bottom, zLevel, (u + 0.0) / textureWidth, (u + regionWidth) / textureWidth, (v + 0.0) / textureHeight, (v + regionHeight) / textureHeight);
    }

    public static void innerBlit(double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22912(left, bottom, zLevel).method_22913((float)minU, (float)maxV).method_1344();
        buffer.method_22912(right, bottom, zLevel).method_22913((float)maxU, (float)maxV).method_1344();
        buffer.method_22912(right, top, zLevel).method_22913((float)maxU, (float)minV).method_1344();
        buffer.method_22912(left, top, zLevel).method_22913((float)minU, (float)minV).method_1344();
        tessellator.method_1350();
    }

    public static void drawWithin(int xPos, int yPos, int width, int height) {
        RenderSystem.enableScissor((int)xPos, (int)yPos, (int)width, (int)height);
    }

    public static void drawAnywhere() {
        RenderSystem.disableScissor();
    }

    public static int computeGuiScale(@Nonnull class_310 mc) {
        int scaleFactor = 1;
        int k = (Integer)mc.field_1690.method_42474().method_41753();
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.method_22683().method_4489() / (scaleFactor + 1) >= 320 && mc.method_22683().method_4506() / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }

    public static Tuple<Boolean, String, class_2960> getTextureData(String texture) {
        class_2960 texLocation = new class_2960("");
        Tuple<Boolean, String, class_2960> result = new Tuple<Boolean, String, class_2960>(false, "", texLocation);
        if (StringUtils.isNullOrEmpty(texture)) {
            return result;
        }
        texture = texture.trim();
        boolean usingExternalTexture = false;
        if (!StringUtils.isValidColorCode(texture)) {
            usingExternalTexture = ImageFrame.isExternalImage(texture);
            if (!usingExternalTexture) {
                if (texture.startsWith(":")) {
                    texture = texture.substring(1);
                }
                if (texture.contains(":")) {
                    String[] splitInput = texture.split(":", 2);
                    texLocation = new class_2960(splitInput[0], splitInput[1]);
                } else {
                    texLocation = new class_2960(texture);
                }
            } else {
                String formattedConvertedName = texture.replaceFirst("file://", "");
                String[] urlBits = formattedConvertedName.trim().split("/");
                String textureName = urlBits[urlBits.length - 1].trim();
                texLocation = ImageUtils.getTextureFromUrl(textureName, texture.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
            }
        }
        return result.put(usingExternalTexture, texture, texLocation);
    }

    public static void drawMultiLineString(@Nonnull class_310 mc, @Nonnull class_332 matrixStack, List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, class_327 fontRenderer, int fontHeight, boolean isCentered, boolean isTooltip, Tuple<Boolean, ColorData, ColorData> colorInfo) {
        if (colorInfo.getFirst().booleanValue() && !textToInput.isEmpty() && fontRenderer != null) {
            boolean usingExternalTexture;
            Tuple<Boolean, String, class_2960> textureData;
            List<String> textLines = textToInput;
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = fontRenderer.method_1727(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean allowXAdjustments = maxWidth > 0;
            boolean allowYAdjustments = maxHeight > 0;
            boolean allowCenterAdjustments = isCentered && allowXAdjustments;
            int titleLinesCount = 1;
            int tooltipX = posX;
            if (!isTooltip && allowCenterAdjustments) {
                tooltipX = posX + 4;
                tooltipTextWidth = maxWidth - tooltipX - 4;
            } else if (isTooltip) {
                tooltipX = posX + (allowXAdjustments ? 12 : 0);
                if (allowXAdjustments && tooltipX + tooltipTextWidth + 4 > maxWidth && (tooltipX = posX - 16 - tooltipTextWidth) < 4) {
                    tooltipTextWidth = posX > maxWidth / 2 ? posX - 12 - 8 : maxWidth - 16 - posX;
                    needsWrap = true;
                }
                if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                    tooltipTextWidth = maxTextWidth;
                    needsWrap = true;
                }
            }
            if (needsWrap) {
                List wrappedTextLines = StringUtils.newArrayList();
                int wrappedTooltipWidth = 0;
                for (int i = 0; i < textLines.size(); ++i) {
                    List<String> wrappedLine = StringUtils.splitTextByNewLine(RenderUtils.wrapFormattedStringToWidth(fontRenderer, textLines.get(i), tooltipTextWidth), true);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = fontRenderer.method_1727(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                if (allowXAdjustments) {
                    tooltipX = posX > maxWidth / 2 ? posX - 16 - tooltipTextWidth : posX + 12;
                }
            }
            int tooltipY = posY - (isTooltip && allowYAdjustments ? 12 : 0);
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * (fontHeight + 1);
                if (isTooltip && textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (allowYAdjustments) {
                if (tooltipY < 4) {
                    tooltipY = 4;
                } else if (tooltipY + tooltipHeight + 4 > maxHeight) {
                    tooltipY = maxHeight - tooltipHeight - 4;
                }
            }
            ColorData backgroundColorInfo = colorInfo.getSecond();
            ColorData borderColorInfo = colorInfo.getThird();
            int zLevel = 400;
            if (backgroundColorInfo != null) {
                Color backgroundStart = backgroundColorInfo.getStartColor();
                Color backgroundEnd = backgroundColorInfo.getEndColor();
                if (StringUtils.isNullOrEmpty(backgroundColorInfo.getTexLocation())) {
                    RenderUtils.drawGradientBox(tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8, 400.0, backgroundStart, backgroundEnd, 1, -1, backgroundStart, backgroundEnd);
                } else {
                    textureData = RenderUtils.getTextureData(backgroundColorInfo.getTexLocation());
                    usingExternalTexture = textureData.getFirst();
                    class_2960 backGroundTexture = textureData.getThird();
                    double width = tooltipTextWidth + 4;
                    double height = tooltipHeight + 4;
                    double left = tooltipX - 4;
                    double right = (double)tooltipX + width;
                    double top = tooltipY - 4;
                    double bottom = (double)tooltipY + height;
                    RenderUtils.drawTexture(mc, left, right, top, bottom, 0.0, RenderUtils.getUVCoord(left, 0.0, usingExternalTexture), RenderUtils.getUVCoord(right, 1.0, usingExternalTexture), RenderUtils.getUVCoord(top, 0.0, usingExternalTexture), RenderUtils.getUVCoord(bottom, 1.0, usingExternalTexture), backgroundStart, backgroundEnd, backGroundTexture);
                }
            }
            if (borderColorInfo != null) {
                Color borderStart = borderColorInfo.getStartColor();
                Color borderEnd = borderColorInfo.getEndColor();
                if (StringUtils.isNullOrEmpty(borderColorInfo.getTexLocation())) {
                    RenderUtils.drawGradientBox(tooltipX - 3, tooltipY - 3, tooltipTextWidth + 6, tooltipHeight + 6, 400.0, borderStart, borderEnd, 1, null, null);
                } else {
                    textureData = RenderUtils.getTextureData(borderColorInfo.getTexLocation());
                    usingExternalTexture = textureData.getFirst();
                    class_2960 borderTexture = textureData.getThird();
                    double border = 1.0;
                    double renderX = tooltipX - 3;
                    double renderY = tooltipY - 3;
                    double canvasRight = tooltipX + tooltipTextWidth + 2;
                    double canvasBottom = tooltipY + tooltipHeight + 2;
                    RenderUtils.drawTexture(mc, renderX, renderX + 1.0, renderY, canvasBottom + 1.0, 400.0, RenderUtils.getUVCoord(renderX, 0.0, usingExternalTexture), RenderUtils.getUVCoord(renderX + 1.0, 1.0, usingExternalTexture), RenderUtils.getUVCoord(renderY, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasBottom + 1.0, 1.0, usingExternalTexture), borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, canvasRight, canvasRight + 1.0, renderY, canvasBottom + 1.0, 400.0, RenderUtils.getUVCoord(canvasRight, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasRight + 1.0, 1.0, usingExternalTexture), RenderUtils.getUVCoord(renderY, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasBottom + 1.0, 1.0, usingExternalTexture), borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, renderX, canvasRight + 1.0, canvasBottom, canvasBottom + 1.0, 400.0, RenderUtils.getUVCoord(renderX, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasRight + 1.0, 1.0, usingExternalTexture), RenderUtils.getUVCoord(canvasBottom, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasBottom + 1.0, 1.0, usingExternalTexture), borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, renderX, canvasRight + 1.0, renderY, renderY + 1.0, 400.0, RenderUtils.getUVCoord(renderX, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasRight + 1.0, 1.0, usingExternalTexture), RenderUtils.getUVCoord(renderY, 0.0, usingExternalTexture), RenderUtils.getUVCoord(renderY + 1.0, 1.0, usingExternalTexture), borderStart, borderEnd, borderTexture);
                }
            }
            class_4587 lv = matrixStack.method_51448();
            lv.method_22903();
            class_4597.class_4598 lv2 = matrixStack.method_51450();
            lv.method_22904(0.0, 0.0, 400.0);
            Matrix4f lv3 = lv.method_23760().method_23761();
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                int lineWidth = fontRenderer.method_1727(line);
                int renderX = isCentered ? tooltipX + (tooltipTextWidth - lineWidth) / 2 : tooltipX;
                fontRenderer.method_27521(line, (float)renderX, (float)tooltipY, -1, true, lv3, (class_4597)lv2, class_327.class_6415.field_33993, 0, 0xF000F0);
                if (isTooltip && lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += fontHeight + 1;
            }
            lv2.method_22993();
            lv.method_22909();
        }
    }

    public static double getUVCoord(double primary, double secondary, boolean usingExternalTexture) {
        return usingExternalTexture ? secondary : primary / 32.0;
    }

    public static void drawBackground(@Nonnull class_310 mc, double left, double right, double top, double bottom, double offset, float tintFactor, ColorData data) {
        tintFactor = MathUtils.clamp(tintFactor, 0.0f, 1.0f);
        Color startColor = StringUtils.offsetColor(data.getStartColor(), tintFactor);
        Color endColor = StringUtils.offsetColor(data.getEndColor(), tintFactor);
        if (StringUtils.isNullOrEmpty(data.getTexLocation())) {
            RenderUtils.drawGradient(left, right, top, bottom, 300.0, startColor, endColor);
        } else {
            Tuple<Boolean, String, class_2960> textureData = RenderUtils.getTextureData(data.getTexLocation());
            boolean usingExternalTexture = textureData.getFirst();
            class_2960 texLocation = textureData.getThird();
            RenderUtils.drawTexture(mc, left, right, top, bottom, 0.0, RenderUtils.getUVCoord(left, 0.0, usingExternalTexture), RenderUtils.getUVCoord(right, 1.0, usingExternalTexture), RenderUtils.getUVCoord(top + offset, 0.0, usingExternalTexture), RenderUtils.getUVCoord(bottom + offset, 1.0, usingExternalTexture), startColor, endColor, texLocation);
        }
    }

    public static List<String> listFormattedStringToWidth(class_327 fontRenderer, String stringInput, int wrapWidth) {
        return StringUtils.splitTextByNewLine(RenderUtils.wrapFormattedStringToWidth(fontRenderer, stringInput, wrapWidth), true);
    }

    public static String wrapFormattedStringToWidth(class_327 fontRenderer, String stringInput, int wrapWidth) {
        int stringSizeToWidth = RenderUtils.sizeStringToWidth(fontRenderer, stringInput, wrapWidth);
        if (stringInput.length() <= stringSizeToWidth) {
            return stringInput;
        }
        String subString = stringInput.substring(0, stringSizeToWidth);
        char currentCharacter = stringInput.charAt(stringSizeToWidth);
        boolean flag = Character.isSpaceChar(currentCharacter) || currentCharacter == '\n';
        String s1 = StringUtils.getFormatFromString(subString) + stringInput.substring(stringSizeToWidth + (flag ? 1 : 0));
        return subString + "\n" + RenderUtils.wrapFormattedStringToWidth(fontRenderer, s1, wrapWidth);
    }

    public static int sizeStringToWidth(class_327 fontRenderer, String stringEntry, int wrapWidth) {
        int currentLine;
        int stringLength = stringEntry.length();
        int charWidth = 0;
        int currentIndex = -1;
        boolean flag = false;
        for (currentLine = 0; currentLine < stringLength; ++currentLine) {
            char currentCharacter = stringEntry.charAt(currentLine);
            String stringOfCharacter = String.valueOf(currentCharacter);
            switch (currentCharacter) {
                case '\n': {
                    --currentLine;
                    break;
                }
                case ' ': {
                    currentIndex = currentLine;
                }
                default: {
                    charWidth += fontRenderer.method_1727(stringOfCharacter);
                    if (!flag) break;
                    ++charWidth;
                    break;
                }
                case '\u00a7': {
                    char code;
                    if (currentLine >= stringLength - 1) break;
                    if ((code = stringEntry.charAt(++currentLine)) == 'l' || code == 'L') {
                        flag = true;
                        break;
                    }
                    if (code != 'r' && code != 'R' && !StringUtils.isFormatColor(code)) break;
                    flag = false;
                }
            }
            if (currentCharacter == '\n') {
                currentIndex = ++currentLine;
                break;
            }
            if (charWidth > wrapWidth) break;
        }
        return currentLine != stringLength && currentIndex != -1 && currentIndex < currentLine ? currentIndex : currentLine;
    }
}

