/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.discord;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.PartyPrivacy;
import com.google.gson.JsonObject;
import external.com.jagrosh.discordipc.IPCClient;
import external.com.jagrosh.discordipc.IPCListener;
import external.com.jagrosh.discordipc.entities.Packet;
import external.com.jagrosh.discordipc.entities.User;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.CommandsGui;

public class ModIPCListener
implements IPCListener {
    @Override
    public void onActivityJoin(IPCClient client, String secret) {
        if (CraftPresence.CLIENT.STATUS != DiscordStatus.JoinGame) {
            CraftPresence.CLIENT.STATUS = DiscordStatus.JoinGame;
            CraftPresence.SERVER.verifyAndJoin(secret);
        }
    }

    @Override
    public void onActivitySpectate(IPCClient client, String secret) {
        if (CraftPresence.CLIENT.STATUS != DiscordStatus.SpectateGame) {
            CraftPresence.CLIENT.STATUS = DiscordStatus.SpectateGame;
        }
    }

    @Override
    public void onActivityJoinRequest(IPCClient client, String secret, User user) {
        if (!(CraftPresence.CLIENT.PARTY_PRIVACY == PartyPrivacy.Public || CraftPresence.CLIENT.STATUS == DiscordStatus.JoinRequest && CraftPresence.CLIENT.REQUESTER_USER.equals(user))) {
            CraftPresence.SCHEDULER.TIMER = 30;
            CraftPresence.CLIENT.STATUS = DiscordStatus.JoinRequest;
            CraftPresence.CLIENT.REQUESTER_USER = user;
            if (!(CraftPresence.instance.f_91080_ instanceof CommandsGui)) {
                RenderUtils.openScreen(CraftPresence.instance, new CommandsGui(CraftPresence.instance.f_91080_, "request"));
            } else {
                ((CommandsGui)CraftPresence.instance.f_91080_).executeCommand("request");
            }
        }
    }

    @Override
    public void onClose(IPCClient client, JsonObject json) {
        if (CraftPresence.CLIENT.isAvailable()) {
            CraftPresence.CLIENT.STATUS = DiscordStatus.Closed;
        }
    }

    @Override
    public void onDisconnect(IPCClient client, Throwable t) {
        if (CraftPresence.CLIENT.STATUS != DiscordStatus.Disconnected) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.rpc", t.getMessage()), new Object[0]);
            CraftPresence.CLIENT.shutDown(true);
        }
    }

    @Override
    public void onPacketReceived(IPCClient client, Packet packet) {
    }

    @Override
    public void onPacketSent(IPCClient client, Packet packet) {
    }

    @Override
    public void onReady(IPCClient client) {
        if (CraftPresence.CLIENT.STATUS != DiscordStatus.Ready) {
            CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
            CraftPresence.CLIENT.CURRENT_USER = client.getCurrentUser();
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.load", CraftPresence.CLIENT.CLIENT_ID, CraftPresence.CLIENT.CURRENT_USER != null ? CraftPresence.CLIENT.CURRENT_USER.getEffectiveName() : "null"), new Object[0]);
        }
    }
}

