/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.storage.energy.idsu;

import java.util.HashMap;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import reborncore.common.util.NBTSerializable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;
import techreborn.config.TechRebornConfig;

public class IDSUManager
extends class_18 {
    private static final String KEY = "techreborn_idsu";
    private final HashMap<String, IDSUPlayer> playerHashMap = new HashMap();

    private IDSUManager() {
    }

    @NotNull
    public static IDSUPlayer getPlayer(MinecraftServer server, String uuid) {
        return IDSUManager.get(server).getPlayer(uuid);
    }

    private static IDSUManager get(MinecraftServer server) {
        class_3218 serverWorld = server.method_3847(class_1937.field_25179);
        return (IDSUManager)serverWorld.method_17983().method_17924(IDSUManager::createFromTag, IDSUManager::new, KEY);
    }

    @NotNull
    public IDSUPlayer getPlayer(String uuid) {
        return this.playerHashMap.computeIfAbsent(uuid, s -> new IDSUPlayer());
    }

    public static IDSUManager createFromTag(class_2487 tag) {
        IDSUManager idsuManager = new IDSUManager();
        idsuManager.fromTag(tag);
        return idsuManager;
    }

    public void fromTag(class_2487 tag) {
        for (String uuid : tag.method_10541()) {
            this.playerHashMap.put(uuid, new IDSUPlayer(tag.method_10562(uuid)));
        }
    }

    public class_2487 method_75(class_2487 tag) {
        this.playerHashMap.forEach((uuid, player) -> tag.method_10566(uuid, (class_2520)player.write()));
        return tag;
    }

    public class IDSUPlayer
    implements NBTSerializable {
        private final SimpleEnergyStorage storage = new SimpleEnergyStorage(TechRebornConfig.idsuMaxEnergy, Long.MAX_VALUE, Long.MAX_VALUE){

            protected void onFinalCommit() {
                IDSUManager.this.method_80();
            }
        };

        private IDSUPlayer() {
        }

        private IDSUPlayer(class_2487 compoundTag) {
            this.read(compoundTag);
        }

        @NotNull
        public class_2487 write() {
            class_2487 tag = new class_2487();
            tag.method_10544("energy", this.storage.amount);
            return tag;
        }

        public void read(@NotNull class_2487 tag) {
            this.storage.amount = tag.method_10537("energy");
        }

        public EnergyStorage getStorage() {
            return this.storage;
        }

        public long getEnergy() {
            return this.storage.amount;
        }

        public void setEnergy(long energy) {
            this.storage.amount = energy;
            IDSUManager.this.method_80();
        }
    }
}

