/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.compat.rei.fluidreplicator;

import com.google.common.collect.Lists;
import dev.architectury.fluid.FluidStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import reborncore.client.gui.GuiBuilder;
import reborncore.common.crafting.RebornRecipeType;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;
import techreborn.client.compat.rei.ReiPlugin;
import techreborn.client.compat.rei.fluidreplicator.FluidReplicatorRecipeDisplay;

@Environment(value=EnvType.CLIENT)
public class FluidReplicatorRecipeCategory
implements DisplayCategory<FluidReplicatorRecipeDisplay> {
    private final RebornRecipeType<FluidReplicatorRecipe> rebornRecipeType;

    public FluidReplicatorRecipeCategory(RebornRecipeType<FluidReplicatorRecipe> recipeType) {
        this.rebornRecipeType = recipeType;
    }

    public CategoryIdentifier<? extends FluidReplicatorRecipeDisplay> getCategoryIdentifier() {
        return CategoryIdentifier.of((class_2960)this.rebornRecipeType.name());
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)this.rebornRecipeType.name().toString());
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1935)ReiPlugin.iconMap.getOrDefault(this.rebornRecipeType, () -> class_1802.field_8250));
    }

    public List<Widget> setupDisplay(FluidReplicatorRecipeDisplay recipeDisplay, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 13);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(ReiPlugin.createEnergyDisplay(new Rectangle(bounds.x + 8, bounds.y + 8, 14, 50), recipeDisplay.getEnergy(), ReiPlugin.EntryAnimation.downwards(5000L), tooltipContext -> {
            ArrayList list = Lists.newArrayList();
            list.add(class_2561.method_30163((String)"Energy"));
            list.add(class_2561.method_43469((String)"techreborn.jei.recipe.running.cost", (Object[])new Object[]{"E", recipeDisplay.getEnergy()}).method_27692(class_124.field_1080));
            list.add(class_2561.method_30163((String)""));
            list.add(ClientHelper.getInstance().getFormattedModFromIdentifier(new class_2960("techreborn", "")));
            return Tooltip.create((Point)tooltipContext.getPoint(), (Collection)list);
        }));
        widgets.add(Widgets.createSlot((Point)new Point(bounds.x + 46, bounds.y + 26)).entries((Collection)recipeDisplay.getInputEntries().get(0)).markInput());
        widgets.add(ReiPlugin.createProgressBar(bounds.x + 46 + 21, bounds.y + 30, recipeDisplay.getTime() * 50, GuiBuilder.ProgressDirection.RIGHT));
        widgets.add(ReiPlugin.createFluidDisplay(new Rectangle(bounds.x + 46 + 46, bounds.y + 8, 16, 50), (EntryStack<FluidStack>)((EntryStack)recipeDisplay.getOutputEntries().get(0).get(0)).cast(), ReiPlugin.EntryAnimation.upwards(5000L)));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + 24, bounds.y + 5), (class_2561)class_2561.method_43469((String)"techreborn.jei.recipe.processing.time.3", (Object[])new Object[]{new DecimalFormat("###.##").format((double)recipeDisplay.getTime() / 20.0)})).shadow(false).leftAligned().color(-12566464, -4473925));
        return widgets;
    }
}

