/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.renderer;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.client.renderer.fabric.ScannerRendererImpl;
import li.cil.scannable.client.shader.Shaders;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@Environment(value=EnvType.CLIENT)
public enum ScannerRenderer {
    INSTANCE;

    private DepthOnlyRenderTarget mainCameraDepth = new DepthOnlyRenderTarget(854, 480);
    private long currentStart;
    private class_243 currentCenter;

    public void ping(class_243 pos) {
        this.currentStart = System.currentTimeMillis();
        this.currentCenter = pos;
    }

    public static void render(class_4587 poseStack) {
        INSTANCE.doRender(poseStack);
    }

    public void doRender(class_4587 poseStack) {
        if (this.shouldRender()) {
            this.grabDepthBuffer();
            this.render(poseStack.method_23760().method_23761());
        }
    }

    private boolean shouldRender() {
        int adjustedDuration = ScanManager.computeScanGrowthDuration();
        return this.currentStart > 0L && adjustedDuration > (int)(System.currentTimeMillis() - this.currentStart);
    }

    private void grabDepthBuffer() {
        class_276 mainRenderTarget = class_310.method_1551().method_1522();
        if (mainRenderTarget.field_1482 != this.mainCameraDepth.field_1482 || mainRenderTarget.field_1481 != this.mainCameraDepth.field_1481) {
            this.mainCameraDepth.method_1234(mainRenderTarget.field_1482, mainRenderTarget.field_1481, class_310.field_1703);
        }
        this.mainCameraDepth = ScannerRenderer.copyBufferSettings(mainRenderTarget, this.mainCameraDepth);
        this.mainCameraDepth.method_29329(mainRenderTarget);
        mainRenderTarget.method_1235(false);
    }

    private void render(Matrix4f viewMatrix) {
        class_5944 shader = Shaders.getScanEffectShader();
        if (shader == null) {
            return;
        }
        class_276 target = class_310.method_1551().method_1522();
        this.updateShaderUniforms(shader, viewMatrix);
        this.blit(target);
    }

    private void updateShaderUniforms(class_5944 shader, Matrix4f viewMatrix) {
        Matrix4f invertedViewMatrix = new Matrix4f((Matrix4fc)viewMatrix);
        invertedViewMatrix.invert();
        Matrix4f invertedProjectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        invertedProjectionMatrix.invert();
        class_243 cameraPosition = class_310.method_1551().field_1773.method_19418().method_19326();
        int adjustedDuration = ScanManager.computeScanGrowthDuration();
        float radius = ScanManager.computeRadius(this.currentStart, adjustedDuration);
        shader.method_34583("depthTex", (Object)this.mainCameraDepth.method_30278());
        shader.method_35785("center").method_34413(this.currentCenter.method_46409());
        shader.method_35785("invViewMat").method_1250(invertedViewMatrix);
        shader.method_35785("invProjMat").method_1250(invertedProjectionMatrix);
        shader.method_35785("pos").method_34413(cameraPosition.method_46409());
        shader.method_35785("radius").method_1251(radius);
    }

    private void blit(class_276 target) {
        int width = target.field_1482;
        int height = target.field_1481;
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        class_5944 oldShader = RenderSystem.getShader();
        RenderSystem.setShader(Shaders::getScanEffectShader);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)width, 0.0f, (float)height, 1.0f, 100.0f), (class_8251)class_8251.field_43361);
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22912(0.0, 0.0, -50.0).method_22913(0.0f, 0.0f).method_1344();
        buffer.method_22912((double)width, 0.0, -50.0).method_22913(1.0f, 0.0f).method_1344();
        buffer.method_22912((double)width, (double)height, -50.0).method_22913(1.0f, 1.0f).method_1344();
        buffer.method_22912(0.0, (double)height, -50.0).method_22913(0.0f, 1.0f).method_1344();
        tesselator.method_1350();
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.setShader(() -> oldShader);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static DepthOnlyRenderTarget copyBufferSettings(class_276 mainRenderTarget, DepthOnlyRenderTarget depthRenderTarget) {
        void var1_1;
        return ScannerRendererImpl.copyBufferSettings(mainRenderTarget, (DepthOnlyRenderTarget)var1_1);
    }

    public static final class DepthOnlyRenderTarget
    extends class_6367 {
        public DepthOnlyRenderTarget(int width, int height) {
            super(width, height, true, class_310.field_1703);
        }

        public void method_1231(int width, int height, boolean isOnOSX) {
            super.method_1231(width, height, isOnOSX);
            if (this.field_1475 > -1) {
                if (this.field_1476 > -1) {
                    GL30.glBindFramebuffer((int)36160, (int)this.field_1476);
                    GL11.glDrawBuffer((int)0);
                    GL30.glBindFramebuffer((int)36160, (int)0);
                }
                TextureUtil.releaseTextureId((int)this.field_1475);
                this.field_1475 = -1;
            }
        }
    }
}

