/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import li.cil.scannable.api.API;
import li.cil.scannable.api.prefab.AbstractScanResultProvider;
import li.cil.scannable.api.scanning.EntityScannerModule;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScanResultRenderContext;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.common.item.ScannerModuleItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

@Environment(value=EnvType.CLIENT)
public final class ScanResultProviderEntity
extends AbstractScanResultProvider {
    private final List<Predicate<class_1297>> filters = new ArrayList<Predicate<class_1297>>();
    private final Map<Predicate<class_1297>, EntityScannerModule> filterToModule = new HashMap<Predicate<class_1297>, EntityScannerModule>();
    private final ArrayList<class_1297> entities = new ArrayList();
    private int currentEntityIndex;
    private int entitiesStep;
    private final List<ScanResultEntity> results = new ArrayList<ScanResultEntity>();

    @Override
    public void initialize(class_1657 player, Collection<class_1799> modules, class_243 center, float radius, int scanTicks) {
        super.initialize(player, modules, center, radius, scanTicks);
        this.filters.clear();
        this.filterToModule.clear();
        for (class_1799 stack : modules) {
            Optional<ScannerModule> capability = ScannerModuleItem.getModule(stack);
            capability.ifPresent(module -> {
                if (module instanceof EntityScannerModule) {
                    EntityScannerModule entityModule = (EntityScannerModule)module;
                    Predicate<class_1297> filter = entityModule.getFilter(stack);
                    this.filters.add(filter);
                    this.filterToModule.put(filter, entityModule);
                }
            });
        }
        this.entities.clear();
        for (class_1297 entity : player.method_37908().method_31592().method_31803()) {
            this.entities.add(entity);
        }
        this.currentEntityIndex = 0;
        this.entitiesStep = class_3532.method_15386((float)((float)this.entities.size() / (float)scanTicks));
    }

    @Override
    public void computeScanResults() {
        int end = Math.min(this.currentEntityIndex + this.entitiesStep, this.entities.size());
        while (this.currentEntityIndex < end) {
            class_243 position;
            class_1297 entity = this.entities.get(this.currentEntityIndex);
            if (entity.method_5805() && this.center.method_1025(position = entity.method_19538()) < (double)(this.radius * this.radius)) {
                class_2960 icon = API.ICON_INFO;
                boolean hasMatch = false;
                for (Predicate<class_1297> filter : this.filters) {
                    if (!filter.test(entity)) continue;
                    hasMatch = true;
                    Optional<class_2960> filterIcon = this.filterToModule.get(filter).getIcon(entity);
                    if (!filterIcon.isPresent()) continue;
                    icon = filterIcon.get();
                    break;
                }
                if (hasMatch) {
                    this.results.add(new ScanResultEntity(entity, icon));
                }
            }
            ++this.currentEntityIndex;
        }
    }

    @Override
    public void collectScanResults(class_1922 level, Consumer<ScanResult> callback) {
        this.results.forEach(callback);
    }

    @Override
    public void render(ScanResultRenderContext context, class_4597 bufferSource, class_4587 poseStack, class_4184 renderInfo, float partialTicks, List<ScanResult> results) {
        if (context != ScanResultRenderContext.GUI) {
            return;
        }
        float yaw = renderInfo.method_19330();
        float pitch = renderInfo.method_19329();
        class_243 lookVec = new class_243(renderInfo.method_19335());
        class_243 viewerEyes = renderInfo.method_19326();
        boolean showDistance = renderInfo.method_19331().method_5715();
        results.sort(Comparator.comparing(result -> {
            ScanResultEntity resultEntity = (ScanResultEntity)result;
            class_243 entityEyes = resultEntity.entity.method_5836(partialTicks);
            class_243 toResult = entityEyes.method_1020(viewerEyes);
            return lookVec.method_1026(toResult.method_1029());
        }));
        for (ScanResult result2 : results) {
            ScanResultEntity resultEntity = (ScanResultEntity)result2;
            class_2561 name = resultEntity.entity.method_5477();
            class_2960 icon = resultEntity.getIcon();
            class_243 resultPos = resultEntity.entity.method_5836(partialTicks);
            float distance = showDistance ? (float)resultPos.method_1020(viewerEyes).method_1033() : 0.0f;
            ScanResultProviderEntity.renderIconLabel(bufferSource, poseStack, yaw, pitch, lookVec, viewerEyes, distance, resultPos, icon, name);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.filters.clear();
        this.filterToModule.clear();
        this.currentEntityIndex = 0;
        this.entitiesStep = 0;
        this.entities.clear();
        this.results.clear();
    }

    private record ScanResultEntity(class_1297 entity, class_2960 icon) implements ScanResult
    {
        public class_2960 getIcon() {
            return this.icon;
        }

        @Override
        public class_243 getPosition() {
            return this.entity.method_19538();
        }

        @Override
        public class_238 getRenderBounds() {
            return this.entity.method_5830();
        }
    }
}

