/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.shader;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_4013;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class Shaders
implements class_4013 {
    private static final Shaders INSTANCE = new Shaders();
    private static final List<ShaderReference> SHADERS = new ArrayList<ShaderReference>();
    public static class_5944 scanEffectShader;
    public static class_5944 scanResultShader;

    public static void initialize() {
        Shaders.addShader("scan_effect", class_290.field_1585, shader -> {
            scanEffectShader = shader;
        });
        Shaders.addShader("scan_result", class_290.field_1575, shader -> {
            scanResultShader = shader;
        });
        Shaders.loadAndListenToReload();
    }

    @Nullable
    public static class_5944 getScanEffectShader() {
        return scanEffectShader;
    }

    @Nullable
    public static class_5944 getScanResultShader() {
        return scanResultShader;
    }

    public void method_14491(class_3300 manager) {
        Shaders.reloadShaders((class_5912)manager);
    }

    private static void loadAndListenToReload() {
        class_310.method_1551().method_5382(() -> {
            class_3300 manager = class_310.method_1551().method_1478();
            INSTANCE.method_14491(manager);
            if (manager instanceof class_3304) {
                class_3304 reloadableManager = (class_3304)manager;
                reloadableManager.method_14477((class_3302)INSTANCE);
            }
        });
    }

    private static void reloadShaders(class_5912 provider) {
        RenderSystem.assertOnRenderThread();
        SHADERS.forEach(reference -> reference.reload(provider));
    }

    private static void addShader(String name, class_293 format, Consumer<class_5944> reloadAction) {
        SHADERS.add(new ShaderReference(name, format, reloadAction));
    }

    private Shaders() {
    }

    private static final class ShaderReference {
        private static final Logger LOGGER = LogManager.getLogger();
        private final String name;
        private final class_293 format;
        private final Consumer<class_5944> reloadAction;
        private class_5944 shader;

        public ShaderReference(String name, class_293 format, Consumer<class_5944> reloadAction) {
            this.name = name;
            this.format = format;
            this.reloadAction = reloadAction;
        }

        public void reload(class_5912 provider) {
            if (this.shader != null) {
                this.shader.close();
                this.shader = null;
            }
            try {
                this.shader = new class_5944(location -> provider.method_14486(new class_2960("scannable", location.method_12832())).or(() -> provider.method_14486(location)), this.name, this.format);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            this.reloadAction.accept(this.shader);
        }
    }
}

