/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.util;

import com.google.common.base.Strings;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import li.cil.scannable.util.config.Comment;
import li.cil.scannable.util.config.CustomSerializer;
import li.cil.scannable.util.config.ItemType;
import li.cil.scannable.util.config.KeyValueTypes;
import li.cil.scannable.util.config.Max;
import li.cil.scannable.util.config.Min;
import li.cil.scannable.util.config.Path;
import li.cil.scannable.util.config.Translation;
import li.cil.scannable.util.config.WorldRestart;
import li.cil.scannable.util.fabric.ConfigManagerImpl;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ConfigManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Class<?>, ConfigFieldParser> PARSERS = new HashMap();
    private static final Map<Class<?>, Pair<Function<Object, String>, Function<String, Object>>> STRING_CONVERTERS = new HashMap();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void add(Supplier<T> factory) {
        ConfigManagerImpl.add(factory);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void initialize() {
        ConfigManagerImpl.initialize();
    }

    protected static <T> void fillSpec(T instance, Builder builder, ArrayList<ConfigFieldPair<?>> values) {
        for (Field field : instance.getClass().getFields()) {
            ConfigManager.parseField(instance, builder, values, field);
        }
    }

    protected static ConfigDefinition createDefinition(Object instance, ArrayList<ConfigFieldPair<?>> values) {
        return new ConfigDefinition(instance, values);
    }

    private static <T> void parseField(T instance, Builder builder, ArrayList<ConfigFieldPair<?>> values, Field field) {
        try {
            if (Collection.class.isAssignableFrom(field.getType())) {
                ItemType annotation = field.getAnnotation(ItemType.class);
                if (annotation == null) {
                    LOGGER.error("Config field with collection type does not have an ItemType annotation.");
                    return;
                }
                ConfigManager.parseCollectionField(instance, builder, values, field, annotation);
            } else if (Map.class.isAssignableFrom(field.getType())) {
                KeyValueTypes annotation = field.getAnnotation(KeyValueTypes.class);
                if (annotation == null) {
                    LOGGER.error("Config field with collection type does not have an ItemType annotation.");
                    return;
                }
                ConfigManager.parseMapField(instance, builder, values, field, annotation);
            } else {
                ConfigManager.parseRegularField(instance, builder, values, field);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Failed accessing field [{}.{}], ignoring.", (Object)field.getDeclaringClass().getName(), (Object)field.getName());
        }
    }

    private static <T> void parseCollectionField(T instance, Builder builder, ArrayList<ConfigFieldPair<?>> values, Field field, ItemType annotation) throws IllegalAccessException {
        Pair<Function<Object, String>, Function<String, Object>> serializers = ConfigManager.getSerializerPair(instance, annotation.valueSerializer(), STRING_CONVERTERS.get(annotation.value()));
        if (serializers.getLeft() == null || serializers.getRight() == null) {
            LOGGER.error("Collection item type [{}] is not supported (in field [{}]).", annotation.value(), (Object)field);
            return;
        }
        Collection collection = (Collection)field.get(instance);
        ArrayList<String> serializedValues = new ArrayList<String>();
        for (Object value : collection) {
            String serializedValue = (String)((Function)serializers.getLeft()).apply(value);
            if (value == null) continue;
            serializedValues.add(serializedValue);
        }
        ConfigValue configValue = ConfigManager.withCommonAttributes(field, builder).define(ConfigManager.getPath(field), serializedValues);
        values.add(new ApplyFieldConfigItem<List>(field, configValue, list -> {
            collection.clear();
            for (String value : list) {
                Object deserializedValue = ((Function)serializers.getRight()).apply(value);
                if (deserializedValue == null) continue;
                collection.add(deserializedValue);
            }
        }));
    }

    private static <T> void parseMapField(T instance, Builder builder, ArrayList<ConfigFieldPair<?>> values, Field field, KeyValueTypes annotation) throws IllegalAccessException {
        Pair<Function<Object, String>, Function<String, Object>> keySerializers = ConfigManager.getSerializerPair(instance, annotation.keySerializer(), STRING_CONVERTERS.get(annotation.keyType()));
        if (keySerializers.getLeft() == null || keySerializers.getRight() == null) {
            LOGGER.error("Map key type [{}] is not supported (in field [{}]).", annotation.keyType(), (Object)field);
            return;
        }
        Pair<Function<Object, String>, Function<String, Object>> valueSerializers = ConfigManager.getSerializerPair(instance, annotation.valueSerializer(), STRING_CONVERTERS.get(annotation.valueType()));
        if (valueSerializers.getLeft() == null || valueSerializers.getRight() == null) {
            LOGGER.error("Map value type [{}] is not supported (in field [{}]).", annotation.valueType(), (Object)field);
            return;
        }
        Map map = (Map)field.get(instance);
        ArrayList<CallSite> serializedValues = new ArrayList<CallSite>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry rawEntry;
            Map.Entry entry = rawEntry = iterator.next();
            String serializedKey = (String)((Function)keySerializers.getLeft()).apply(entry.getKey());
            String serializedValue = (String)((Function)valueSerializers.getLeft()).apply(entry.getValue());
            if (serializedKey == null || serializedValue == null) continue;
            serializedValues.add((CallSite)((Object)(serializedKey + "=" + serializedValue)));
        }
        ConfigValue configValue = ConfigManager.withCommonAttributes(field, builder).define(ConfigManager.getPath(field), serializedValues);
        values.add(new ApplyFieldConfigItem<List>(field, configValue, list -> {
            map.clear();
            for (String value : list) {
                String[] parts = value.split("=", 2);
                if (parts.length != 2) {
                    LOGGER.error("Failed parsing setting value [{}].", (Object)value);
                    continue;
                }
                Object deserializedKey = ((Function)keySerializers.getRight()).apply(parts[0]);
                Object deserializedValue = ((Function)valueSerializers.getRight()).apply(parts[1]);
                if (deserializedKey == null || deserializedValue == null) continue;
                map.put(deserializedKey, deserializedValue);
            }
        }));
    }

    private static <T> void parseRegularField(T instance, Builder builder, ArrayList<ConfigFieldPair<?>> values, Field field) throws IllegalAccessException {
        ConfigFieldParser parser = PARSERS.get(field.getType());
        if (parser != null) {
            values.add(parser.apply(instance, field, builder));
            return;
        }
        Pair<Function<Object, String>, Function<String, Object>> serializers = STRING_CONVERTERS.get(field.getType());
        if (serializers != null) {
            values.add(ConfigManager.parseStringLikeField(instance, field, builder, serializers));
            return;
        }
        throw new IllegalStateException("Field of type [" + field.getType() + "] is not supported.");
    }

    private static ConfigFieldPair<?> parseBooleanField(Object instance, Field field, Builder builder) throws IllegalAccessException {
        boolean defaultValue = field.getBoolean(instance);
        ConfigValue<Boolean> configValue = ConfigManager.withCommonAttributes(field, builder).define(ConfigManager.getPath(field), defaultValue);
        return new SetFieldConfigItem<Boolean>(field, configValue);
    }

    private static ConfigFieldPair<?> parseIntField(Object instance, Field field, Builder builder) throws IllegalAccessException {
        int defaultValue = field.getInt(instance);
        int minValue = (int)Math.max(ConfigManager.getMin(field), -2.147483648E9);
        int maxValue = (int)Math.min(ConfigManager.getMax(field), 2.147483647E9);
        ConfigValue<Integer> configValue = ConfigManager.withCommonAttributes(field, builder).defineInRange(ConfigManager.getPath(field), defaultValue, minValue, maxValue, Integer.class);
        return new SetFieldConfigItem<Integer>(field, configValue);
    }

    private static ConfigFieldPair<?> parseLongField(Object instance, Field field, Builder builder) throws IllegalAccessException {
        long defaultValue = field.getLong(instance);
        long minValue = (long)Math.max(ConfigManager.getMin(field), -9.223372036854776E18);
        long maxValue = (long)Math.min(ConfigManager.getMax(field), 9.223372036854776E18);
        ConfigValue<Long> configValue = ConfigManager.withCommonAttributes(field, builder).defineInRange(ConfigManager.getPath(field), defaultValue, minValue, maxValue, Long.class);
        return new SetFieldConfigItem<Long>(field, configValue);
    }

    private static ConfigFieldPair<?> parseFloatField(Object instance, Field field, Builder builder) throws IllegalAccessException {
        double defaultValue = field.getFloat(instance);
        double minValue = ConfigManager.getMin(field);
        double maxValue = ConfigManager.getMax(field);
        ConfigValue<Double> configValue = ConfigManager.withCommonAttributes(field, builder).defineInRange(ConfigManager.getPath(field), defaultValue, minValue, maxValue, Double.class);
        return new SetFieldConfigItem<Double>(field, configValue, value -> Float.valueOf((float)value.doubleValue()));
    }

    private static ConfigFieldPair<?> parseDoubleField(Object instance, Field field, Builder builder) throws IllegalAccessException {
        double defaultValue = field.getDouble(instance);
        double minValue = ConfigManager.getMin(field);
        double maxValue = ConfigManager.getMax(field);
        ConfigValue<Double> configValue = ConfigManager.withCommonAttributes(field, builder).defineInRange(ConfigManager.getPath(field), defaultValue, minValue, maxValue, Double.class);
        return new SetFieldConfigItem<Double>(field, configValue);
    }

    private static ConfigFieldPair<?> parseStringLikeField(Object instance, Field field, Builder builder, Pair<Function<Object, String>, Function<String, Object>> defaultSerializers) throws IllegalAccessException {
        Pair<Function<Object, String>, Function<String, Object>> serializers = ConfigManager.getSerializerPair(instance, field, defaultSerializers);
        String defaultValue = (String)((Function)serializers.getLeft()).apply(field.get(instance));
        ConfigValue<String> configValue = ConfigManager.withCommonAttributes(field, builder).define(ConfigManager.getPath(field), defaultValue);
        return new SetFieldConfigItem<String>(field, configValue, (Function)serializers.getRight());
    }

    private static Builder withCommonAttributes(Field field, Builder builder) {
        if (ConfigManager.getWorldRestart(field)) {
            builder.worldRestart();
        }
        return builder.comment(ConfigManager.getComment(field)).translation(ConfigManager.getTranslation(field));
    }

    private static String getPath(Field field) {
        Path pathAnnotation = field.getAnnotation(Path.class);
        return (String)(pathAnnotation != null ? pathAnnotation.value() + "." : "") + field.getName();
    }

    private static double getMin(Field field) {
        Min annotation = field.getAnnotation(Min.class);
        return annotation != null ? annotation.value() : 0.0;
    }

    private static double getMax(Field field) {
        Max annotation = field.getAnnotation(Max.class);
        return annotation != null ? annotation.value() : Double.POSITIVE_INFINITY;
    }

    private static String[] getComment(Field field) {
        Comment annotation = field.getAnnotation(Comment.class);
        return annotation != null ? annotation.value() : new String[]{};
    }

    @Nullable
    private static String getTranslation(Field field) {
        Translation annotation = field.getAnnotation(Translation.class);
        return annotation != null ? annotation.value() : null;
    }

    private static boolean getWorldRestart(Field field) {
        WorldRestart annotation = field.getAnnotation(WorldRestart.class);
        return annotation != null;
    }

    private static Pair<Function<Object, String>, Function<String, Object>> getSerializerPair(Object instance, Field field, Pair<Function<Object, String>, Function<String, Object>> defaultSerializers) {
        return ConfigManager.getSerializerPair(instance, field.getAnnotation(CustomSerializer.class), defaultSerializers);
    }

    private static Pair<Function<Object, String>, Function<String, Object>> getSerializerPair(Object instance, @Nullable CustomSerializer annotation, Pair<Function<Object, String>, Function<String, Object>> defaultSerializers) {
        Function<String, Object> deserializer;
        Function<Object, String> serializer;
        if (annotation == null) {
            serializer = (Function<Object, String>)defaultSerializers.getLeft();
            deserializer = (Function<String, Object>)defaultSerializers.getRight();
        } else {
            serializer = ConfigManager.getSerializerMethod(instance, annotation.serializer(), (Function)defaultSerializers.getLeft());
            deserializer = ConfigManager.getDeserializerMethod(instance, annotation.deserializer(), (Function)defaultSerializers.getRight());
        }
        return Pair.of(serializer, (Object)deserializer);
    }

    @Nullable
    private static Function<Object, String> getSerializerMethod(Object instance, String methodName, @Nullable Function<Object, String> defaultSerializer) {
        if (Strings.isNullOrEmpty((String)methodName)) {
            return defaultSerializer;
        }
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType methodType = MethodType.methodType(String.class, Object.class);
            MethodHandle methodHandle = lookup.findStatic(instance.getClass(), methodName, methodType);
            return LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), methodType.generic(), methodHandle, methodType).getTarget().invokeExact();
        }
        catch (Throwable e) {
            LOGGER.error("Serializer [{}] not found on config [{}] or could not be accessed. Error was: {}", (Object)methodName, (Object)instance.getClass().getName(), (Object)e);
            for (Method method : instance.getClass().getDeclaredMethods()) {
                if (!Objects.equals(method.getName(), methodName)) continue;
                LOGGER.error("A method with this name exists but has an incompatible signature. Signature should be [static String {}(Object) {...}].", (Object)methodName);
                break;
            }
            return defaultSerializer;
        }
    }

    @Nullable
    private static Function<String, Object> getDeserializerMethod(Object instance, String methodName, @Nullable Function<String, Object> defaultDeserializer) {
        if (Strings.isNullOrEmpty((String)methodName)) {
            return defaultDeserializer;
        }
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType methodType = MethodType.methodType(Object.class, String.class);
            MethodHandle methodHandle = lookup.findStatic(instance.getClass(), methodName, methodType);
            return LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), methodType.generic(), methodHandle, methodType).getTarget().invokeExact();
        }
        catch (Throwable e) {
            LOGGER.error("Deserializer [{}] not found on config [{}] or could not be accessed. Error was: {}", (Object)methodName, (Object)instance.getClass().getName(), (Object)e);
            for (Method method : instance.getClass().getDeclaredMethods()) {
                if (!Objects.equals(method.getName(), methodName)) continue;
                LOGGER.error("A method with this name exists but has an incompatible signature. Signature should be [static Object {}(String) {...}].", (Object)methodName);
                break;
            }
            return defaultDeserializer;
        }
    }

    static {
        PARSERS.put(Boolean.TYPE, ConfigManager::parseBooleanField);
        PARSERS.put(Integer.TYPE, ConfigManager::parseIntField);
        PARSERS.put(Long.TYPE, ConfigManager::parseLongField);
        PARSERS.put(Float.TYPE, ConfigManager::parseFloatField);
        PARSERS.put(Double.TYPE, ConfigManager::parseDoubleField);
        STRING_CONVERTERS.put(Boolean.TYPE, (Pair<Function<Object, String>, Function<String, Object>>)Pair.of(o -> String.valueOf((Boolean)o), Boolean::parseBoolean));
        STRING_CONVERTERS.put(Integer.TYPE, (Pair<Function<Object, String>, Function<String, Object>>)Pair.of(o -> String.valueOf((Integer)o), Integer::decode));
        STRING_CONVERTERS.put(Long.TYPE, (Pair<Function<Object, String>, Function<String, Object>>)Pair.of(o -> String.valueOf((Long)o), Long::decode));
        STRING_CONVERTERS.put(Float.TYPE, (Pair<Function<Object, String>, Function<String, Object>>)Pair.of(o -> String.valueOf(((Float)o).floatValue()), Float::parseFloat));
        STRING_CONVERTERS.put(Double.TYPE, (Pair<Function<Object, String>, Function<String, Object>>)Pair.of(o -> String.valueOf((Double)o), Double::parseDouble));
        STRING_CONVERTERS.put(String.class, (Pair<Function<Object, String>, Function<String, Object>>)Pair.of(s -> (String)s, s -> s));
        STRING_CONVERTERS.put(UUID.class, (Pair<Function<Object, String>, Function<String, Object>>)Pair.of(Object::toString, UUID::fromString));
        STRING_CONVERTERS.put(class_2960.class, (Pair<Function<Object, String>, Function<String, Object>>)Pair.of(Object::toString, class_2960::new));
    }

    protected static interface Builder {
        public <T> ConfigValue<T> define(String var1, T var2);

        public <T extends Comparable<? super T>> ConfigValue<T> defineInRange(String var1, T var2, T var3, T var4, Class<T> var5);

        public Builder comment(String ... var1);

        public Builder translation(@Nullable String var1);

        public Builder worldRestart();
    }

    protected record ConfigDefinition(Object instance, ArrayList<ConfigFieldPair<?>> values) {
        public void apply() {
            for (ConfigFieldPair<?> pair : this.values) {
                pair.apply(this.instance);
            }
        }
    }

    protected static interface ConfigValue<T> {
        public T get();
    }

    private static final class ApplyFieldConfigItem<T>
    extends ConfigFieldPair<T> {
        private final Consumer<T> applier;

        public ApplyFieldConfigItem(Field field, ConfigValue<T> value, Consumer<T> applier) {
            super(field, value);
            this.applier = applier;
        }

        @Override
        public void apply(Object instance) {
            this.applier.accept(this.value.get());
        }
    }

    @FunctionalInterface
    private static interface ConfigFieldParser {
        public ConfigFieldPair<?> apply(Object var1, Field var2, Builder var3) throws IllegalAccessException;
    }

    protected static abstract class ConfigFieldPair<T> {
        public final Field field;
        public final ConfigValue<T> value;

        public ConfigFieldPair(Field field, ConfigValue<T> value) {
            this.field = field;
            this.value = value;
        }

        public abstract void apply(Object var1);
    }

    private static final class SetFieldConfigItem<T>
    extends ConfigFieldPair<T> {
        private final Function<T, Object> converter;

        public SetFieldConfigItem(Field field, ConfigValue<T> value, Function<T, Object> converter) {
            super(field, value);
            this.converter = converter;
        }

        public SetFieldConfigItem(Field field, ConfigValue<T> value) {
            this(field, value, x -> x);
        }

        @Override
        public void apply(Object instance) {
            try {
                this.field.set(instance, this.converter.apply(this.value.get()));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

