/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.util.text.ITextCollection;

public class TextListBuilder
implements ITextCollection {
    private List<List<class_2561>> list = new ArrayList<List<class_2561>>();

    private void addNewLine(String line) {
        this.addNewLine((class_2561)class_2561.method_43470((String)line));
    }

    private void addNewLine(class_2561 line) {
        ArrayList<class_2561> newLine = new ArrayList<class_2561>();
        newLine.add(line);
        this.list.add(newLine);
    }

    private void addNewLine(List<class_2561> line) {
        this.list.add(line);
    }

    public TextListBuilder add(String ... array) {
        for (int i = 0; i < array.length; ++i) {
            this.addNewLine(array[i]);
        }
        return this;
    }

    public TextListBuilder add(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addNewLine(list.get(i));
        }
        return this;
    }

    public <T> TextListBuilder add(T[] array, Function<T, String> toString) {
        for (int i = 0; i < array.length; ++i) {
            this.addNewLine(toString.apply(array[i]));
        }
        return this;
    }

    public <T> TextListBuilder add(Collection<T> collection, Function<T, String> toString) {
        for (T t : collection) {
            this.addNewLine(toString.apply(t));
        }
        return this;
    }

    public <T> TextListBuilder addComponent(T[] array, Function<T, class_2561> toComponent) {
        for (int i = 0; i < array.length; ++i) {
            this.addNewLine(toComponent.apply(array[i]));
        }
        return this;
    }

    public <T> TextListBuilder addComponent(Collection<T> collection, Function<T, class_2561> toComponent) {
        for (T t : collection) {
            this.addNewLine(toComponent.apply(t));
        }
        return this;
    }

    public <T> TextListBuilder addComponents(Collection<T> collection, Function<T, List<class_2561>> toComponent) {
        for (T t : collection) {
            this.addNewLine(toComponent.apply(t));
        }
        return this;
    }

    public TextListBuilder addTranslated(String prefix, String ... array) {
        for (int i = 0; i < array.length; ++i) {
            this.addNewLine(GuiControl.translateOrDefault(prefix + array[i], array[i]));
        }
        return this;
    }

    public TextListBuilder addTranslated(String prefix, List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addNewLine(GuiControl.translateOrDefault(prefix + list.get(i), list.get(i)));
        }
        return this;
    }

    public TextListBuilder addTranslated(String prefix, Collection<String> collection) {
        for (String entry : collection) {
            this.addNewLine(GuiControl.translateOrDefault(prefix + entry, entry));
        }
        return this;
    }

    public <T> TextListBuilder addTranslated(String prefix, T[] array, Function<T, String> toString) {
        for (int i = 0; i < array.length; ++i) {
            String text = toString.apply(array[i]);
            this.addNewLine(GuiControl.translateOrDefault(prefix + text, text));
        }
        return this;
    }

    public <T> TextListBuilder addTranslated(String prefix, Collection<T> collection, Function<T, String> toString) {
        for (T t : collection) {
            String text = toString.apply(t);
            this.addNewLine(GuiControl.translateOrDefault(prefix + text, text));
        }
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public List<class_2561> get(int index) {
        return this.list.get(index);
    }

    @Override
    public CompiledText[] build() {
        CompiledText[] lines = new CompiledText[this.size()];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = CompiledText.createAnySize();
            lines[i].setText(this.get(i));
        }
        return lines;
    }
}

