/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.RunicAltarRecipe;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class RunicAltarRecipeCategory
implements IRecipeCategory<RunicAltarRecipe> {
    public static final RecipeType<RunicAltarRecipe> TYPE = RecipeType.create((String)"botania", (String)"runic_altar", RunicAltarRecipe.class);
    private final IDrawable background;
    private final class_2561 localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;

    public RunicAltarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(114, 104);
        this.localizedName = class_2561.method_43471((String)"botania.nei.runicAltar");
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/petal_overlay.png"), 17, 11, 114, 82);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)BotaniaBlocks.runeAltar));
    }

    @NotNull
    public RecipeType<RunicAltarRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(RunicAltarRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull class_332 gui, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(gui, 0, 4);
        HUDHandler.renderManaBar(gui, 6, 98, 255, 0.75f, recipe.getManaUsage(), 100000);
        RenderSystem.disableBlend();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull RunicAltarRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 48, 45).addItemStack(new class_1799((class_1935)BotaniaBlocks.runeAltar));
        double angleBetweenEach = 360.0 / (double)recipe.method_8117().size();
        class_241 point = new class_241(48.0f, 13.0f);
        class_241 center = new class_241(48.0f, 45.0f);
        for (class_1856 ingr : recipe.method_8117()) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)point.field_1343, (int)point.field_1342).addIngredients(ingr);
            point = PetalApothecaryRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 10).addItemStack(recipe.method_8110((class_5455)class_5455.field_40585));
    }
}

