/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.ArrayList;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.CellularBlockEntity;

public class DandelifeonBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final int RANGE = 12;
    public static final int SPEED = 10;
    public static final int MAX_MANA_GENERATIONS = 100;
    public static final int MANA_PER_GEN = 60;
    private static final String TAG_RADIUS = "radius";
    private int radius = 12;
    private static final int[][] ADJACENT_BLOCKS = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}};

    public DandelifeonBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaFlowerBlocks.DANDELIFEON, pos, state);
    }

    public int getRange() {
        return this.radius;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.method_10997().field_9236 && this.method_10997().method_8510() % 10L == 0L && this.method_10997().method_49803(this.method_11016())) {
            this.runSimulation();
        }
    }

    private void runSimulation() {
        CellTable table = new CellTable(this.radius, this);
        ArrayList<LifeUpdate> changes = new ArrayList<LifeUpdate>();
        boolean wipe = false;
        for (int i = 0; i < table.diameter; ++i) {
            for (int j = 0; j < table.diameter; ++j) {
                int oldLife = table.at(i, j);
                int adj = table.getAdjCells(i, j);
                int newLife = adj == 3 && oldLife == -1 ? table.getSpawnCellGeneration(i, j) : ((adj == 2 || adj == 3) && Cell.isLive(oldLife) ? oldLife + 1 : -1);
                int xdist = Math.abs(i - this.radius);
                int zdist = Math.abs(j - this.radius);
                int allowDist = 1;
                if (xdist <= allowDist && zdist <= allowDist && Cell.isLive(newLife)) {
                    if (oldLife == 1) {
                        newLife = -1;
                    } else {
                        oldLife = newLife;
                        newLife = -2;
                        wipe = true;
                    }
                }
                if (newLife == oldLife) continue;
                changes.add(new LifeUpdate(i, j, newLife, oldLife));
            }
        }
        for (LifeUpdate change : changes) {
            class_2338 pos_ = table.center.method_10069(-this.radius + change.x(), 0, -this.radius + change.z());
            int newLife = change.newLife();
            if (newLife != -2 && wipe) {
                newLife = -1;
            }
            this.setBlockForGeneration(pos_, Math.min(newLife, 100), change.oldLife());
        }
    }

    void setBlockForGeneration(class_2338 pos, int cell, int prevCell) {
        class_1937 world = this.method_10997();
        class_2680 stateAt = world.method_8320(pos);
        class_2586 tile = world.method_8321(pos);
        if (cell == -2) {
            int val = prevCell * 60;
            world.method_8650(pos, true);
            this.addMana(val);
            this.sync();
        } else if (tile instanceof CellularBlockEntity) {
            CellularBlockEntity cellBlock = (CellularBlockEntity)tile;
            cellBlock.setNextGeneration(this, cell);
        } else if (Cell.isLive(cell) && stateAt.method_26215()) {
            world.method_8501(pos, BotaniaBlocks.cellBlock.method_9564());
            tile = world.method_8321(pos);
            ((CellularBlockEntity)tile).setNextGeneration(this, cell);
            ((CellularBlockEntity)tile).setGeneration(-1);
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.radius);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 50000;
    }

    @Override
    public int getColor() {
        return 10226302;
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        if (this.radius != 12) {
            cmp.method_10569(TAG_RADIUS, this.radius);
        }
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.radius = cmp.method_10545(TAG_RADIUS) ? cmp.method_10550(TAG_RADIUS) : 12;
    }

    private static class CellTable {
        public final class_2338 center;
        public final int diameter;
        private int[][] cells;

        public CellTable(int range, DandelifeonBlockEntity dandie) {
            this.center = dandie.getEffectivePos();
            this.diameter = range * 2 + 1;
            this.cells = new int[this.diameter + 2][this.diameter + 2];
            for (int i = -1; i <= this.diameter; ++i) {
                for (int j = -1; j <= this.diameter; ++j) {
                    class_2338 pos = this.center.method_10069(-range + i, 0, -range + j);
                    this.cells[i + 1][j + 1] = CellTable.getCellGeneration(pos, dandie);
                }
            }
        }

        private static int getCellGeneration(class_2338 pos, DandelifeonBlockEntity dandie) {
            class_2586 tile = dandie.method_10997().method_8321(pos);
            if (tile instanceof CellularBlockEntity) {
                CellularBlockEntity cell = (CellularBlockEntity)tile;
                return cell.isSameFlower(dandie) ? cell.getGeneration() : Cell.boundaryPunish(cell.getGeneration());
            }
            return -1;
        }

        public boolean inBounds(int x, int z) {
            return x >= 0 && z >= 0 && x < this.diameter && z < this.diameter;
        }

        public int getAdjCells(int x, int z) {
            int count = 0;
            for (int[] shift : ADJACENT_BLOCKS) {
                if (!Cell.isLive(this.at(x + shift[0], z + shift[1]))) continue;
                ++count;
            }
            return count;
        }

        public int getSpawnCellGeneration(int x, int z) {
            int max = -1;
            for (int[] shift : ADJACENT_BLOCKS) {
                max = Math.max(max, this.at(x + shift[0], z + shift[1]));
            }
            return max == -1 ? -1 : max + 1;
        }

        public int at(int x, int z) {
            return this.cells[x + 1][z + 1];
        }
    }

    public static final class Cell {
        public static final int CONSUME = -2;
        public static final int DEAD = -1;

        private Cell() {
        }

        public static boolean isLive(int i) {
            return i >= 0;
        }

        public static int boundaryPunish(int life) {
            return Cell.isLive(life) ? life / 4 : life;
        }
    }

    private record LifeUpdate(int x, int z, int newLife, int oldLife) {
    }
}

