/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.FloatingFlowerVariant;

public class GrassSeedsItem
extends class_1792
implements FloatingFlowerVariant {
    private static final Map<class_5321<class_1937>, Set<BlockSwapper>> blockSwappers = new HashMap<class_5321<class_1937>, Set<BlockSwapper>>();
    private static final Map<FloatingFlower.IslandType, Integer> COLORS = ImmutableMap.builder().put((Object)FloatingFlower.IslandType.GRASS, (Object)26112).put((Object)FloatingFlower.IslandType.PODZOL, (Object)8412672).put((Object)FloatingFlower.IslandType.MYCEL, (Object)6160468).put((Object)FloatingFlower.IslandType.DRY, (Object)6717453).put((Object)FloatingFlower.IslandType.GOLDEN, (Object)12563200).put((Object)FloatingFlower.IslandType.VIVID, (Object)32794).put((Object)FloatingFlower.IslandType.SCORCHED, (Object)0xBF0000).put((Object)FloatingFlower.IslandType.INFUSED, (Object)35980).put((Object)FloatingFlower.IslandType.MUTATED, (Object)0x661A66).build();
    private final FloatingFlower.IslandType type;

    public GrassSeedsItem(FloatingFlower.IslandType type, class_1792.class_1793 props) {
        super(props);
        this.type = type;
    }

    @NotNull
    public class_1269 method_7884(class_1838 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_1799 stack = ctx.method_8041();
        return this.applySeeds(world, pos, stack);
    }

    public class_1269 applySeeds(class_1937 world, class_2338 pos, class_1799 stack) {
        class_2680 state = world.method_8320(pos);
        if (state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10219) && this.type != FloatingFlower.IslandType.GRASS) {
            if (!world.field_9236) {
                BlockSwapper swapper = GrassSeedsItem.addBlockSwapper(world, pos, this.type);
                world.method_8501(pos, swapper.stateToSet);
                stack.method_7934(1);
            } else {
                int color = GrassSeedsItem.getColor(this.type);
                GrassSeedsItem.spawnParticles(world, pos, GrassSeedsItem.extractR(color), GrassSeedsItem.extractG(color), GrassSeedsItem.extractB(color));
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        return class_1269.field_5811;
    }

    public static void spawnParticles(class_1937 world, class_2338 pos, float r, float g, float b) {
        for (int i = 0; i < 50; ++i) {
            double x = (Math.random() - 0.5) * 3.0;
            double y = Math.random() - 0.5 + 1.0;
            double z = (Math.random() - 0.5) * 3.0;
            float velMul = 0.025f;
            float motionx = (float)(-x) * velMul;
            float motiony = (float)(-y) * velMul;
            float motionz = (float)(-z) * velMul;
            WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, r, g, b);
            world.method_8406((class_2394)data, (double)pos.method_10263() + 0.5 + x, (double)pos.method_10264() + 0.5 + y, (double)pos.method_10260() + 0.5 + z, (double)motionx, (double)motiony, (double)motionz);
        }
    }

    public static void onTickEnd(class_3218 world) {
        class_5321 dim = world.method_27983();
        if (blockSwappers.containsKey(dim)) {
            blockSwappers.get(dim).removeIf(next -> next == null || !next.tick());
        }
    }

    private static BlockSwapper addBlockSwapper(class_1937 world, class_2338 pos, FloatingFlower.IslandType type) {
        BlockSwapper swapper = new BlockSwapper(world, pos, GrassSeedsItem.stateForType(type));
        class_5321 dim = world.method_27983();
        blockSwappers.computeIfAbsent((class_5321<class_1937>)dim, d -> new HashSet()).add(swapper);
        return swapper;
    }

    private static class_2680 stateForType(FloatingFlower.IslandType type) {
        if (type == FloatingFlower.IslandType.PODZOL) {
            return class_2246.field_10520.method_9564();
        }
        if (type == FloatingFlower.IslandType.MYCEL) {
            return class_2246.field_10402.method_9564();
        }
        if (type == FloatingFlower.IslandType.DRY) {
            return BotaniaBlocks.dryGrass.method_9564();
        }
        if (type == FloatingFlower.IslandType.GOLDEN) {
            return BotaniaBlocks.goldenGrass.method_9564();
        }
        if (type == FloatingFlower.IslandType.VIVID) {
            return BotaniaBlocks.vividGrass.method_9564();
        }
        if (type == FloatingFlower.IslandType.SCORCHED) {
            return BotaniaBlocks.scorchedGrass.method_9564();
        }
        if (type == FloatingFlower.IslandType.INFUSED) {
            return BotaniaBlocks.infusedGrass.method_9564();
        }
        if (type == FloatingFlower.IslandType.MUTATED) {
            return BotaniaBlocks.mutatedGrass.method_9564();
        }
        return class_2246.field_10219.method_9564();
    }

    public static float extractR(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float extractG(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float extractB(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static int getColor(FloatingFlower.IslandType type) {
        return COLORS.get(type);
    }

    @Override
    public FloatingFlower.IslandType getIslandType(class_1799 stack) {
        return this.type;
    }

    private static class BlockSwapper {
        public static final int RANGE = 3;
        public static final int TICK_RANGE = 1;
        private final class_1937 world;
        private final Random rand;
        private final class_2680 stateToSet;
        private final class_2338 startCoords;
        private int ticksExisted = 0;

        public BlockSwapper(class_1937 world, class_2338 coords, class_2680 state) {
            this.world = world;
            this.stateToSet = state;
            this.rand = new Random(coords.hashCode());
            this.startCoords = coords;
        }

        public boolean tick() {
            if (++this.ticksExisted % 20 == 0) {
                for (class_2338 pos : class_2338.method_10097((class_2338)this.startCoords.method_10069(-3, 0, -3), (class_2338)this.startCoords.method_10069(3, 0, 3))) {
                    if (this.world.method_8320(pos) != this.stateToSet) continue;
                    this.tickBlock(pos);
                }
            }
            return this.ticksExisted < 80;
        }

        public void tickBlock(class_2338 pos) {
            ArrayList<class_2338> validCoords = new ArrayList<class_2338>();
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    if (xOffset == 0 && zOffset == 0 || !this.isValidSwapPosition(pos.method_10069(xOffset, 0, zOffset))) continue;
                    validCoords.add(pos.method_10069(xOffset, 0, zOffset));
                }
            }
            if (!validCoords.isEmpty()) {
                class_2338 toSwap = (class_2338)validCoords.get(this.rand.nextInt(validCoords.size()));
                this.world.method_8501(toSwap, this.stateToSet);
            }
        }

        public boolean isValidSwapPosition(class_2338 pos) {
            class_2680 state = this.world.method_8320(pos);
            return (state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10219)) && this.world.method_8320(pos.method_10084()).method_26193((class_1922)this.world, pos.method_10084()) <= 1;
        }
    }
}

