/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_572;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;

public class SpectatorItem
extends BaubleItem {
    private static final String TAG_ENTITY_POSITIONS = "highlightPositionsEnt";
    private static final String TAG_BLOCK_POSITIONS = "highlightPositionsBlock";

    public SpectatorItem(class_1792.class_1793 props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void onWornTick(class_1799 stack, class_1309 living) {
        if (!(living instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)living;
        if (living.method_37908().field_9236) {
            this.tickClient(stack, player);
        } else {
            this.tickServer(stack, player);
        }
    }

    protected void tickClient(class_1799 stack, class_1657 player) {
        int[] entities;
        if (player != Proxy.INSTANCE.getClientPlayer()) {
            return;
        }
        class_2499 blocks = ItemNBTHelper.getList(stack, TAG_BLOCK_POSITIONS, 4, false);
        for (class_2520 block : blocks) {
            class_2338 pos = class_2338.method_10092((long)((class_2503)block).method_10699());
            float m = 0.02f;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), false);
            player.method_37908().method_8406((class_2394)data, (double)((float)pos.method_10263() + (float)Math.random()), (double)((float)pos.method_10264() + (float)Math.random()), (double)((float)pos.method_10260() + (float)Math.random()), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)));
        }
        for (int i : entities = ItemNBTHelper.getIntArray(stack, TAG_ENTITY_POSITIONS)) {
            class_1297 e = player.method_37908().method_8469(i);
            if (e == null || !(Math.random() < 0.6)) continue;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), Math.random() < 0.6);
            player.method_37908().method_8406((class_2394)data, e.method_23317() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), e.method_23318() + (double)e.method_17682(), e.method_23321() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), 0.0, (double)(0.05f + 0.03f * (float)Math.random()), 0.0);
        }
    }

    protected void tickServer(class_1799 stack, class_1657 player) {
        IntArrayList entPosBuilder = new IntArrayList();
        class_2499 blockPosBuilder = new class_2499();
        this.scanForStack(player.method_6047(), player, entPosBuilder, blockPosBuilder);
        this.scanForStack(player.method_6079(), player, entPosBuilder, blockPosBuilder);
        int[] currentEnts = entPosBuilder.elements();
        ItemNBTHelper.setIntArray(stack, TAG_ENTITY_POSITIONS, currentEnts);
        ItemNBTHelper.setList(stack, TAG_BLOCK_POSITIONS, blockPosBuilder);
    }

    private void scanForStack(class_1799 pstack, class_1657 player, IntArrayList entIdBuilder, class_2499 blockPosBuilder) {
        if (!pstack.method_7960() || player.method_5715()) {
            int range = 24;
            List entities = player.method_37908().method_18467(class_1297.class, new class_238(player.method_23317() - (double)range, player.method_23318() - (double)range, player.method_23321() - (double)range, player.method_23317() + (double)range, player.method_23318() + (double)range, player.method_23321() + (double)range));
            for (class_1297 e : entities) {
                class_1263 inv;
                if (e == player) continue;
                if (e instanceof class_1542) {
                    class_1542 item = (class_1542)e;
                    class_1799 istack = item.method_6983();
                    if (!player.method_5715() && !class_1799.method_31577((class_1799)istack, (class_1799)pstack)) continue;
                    entIdBuilder.add(item.method_5628());
                    continue;
                }
                if (e instanceof class_1657) {
                    class_1657 targetPlayer = (class_1657)e;
                    class_1263 binv = BotaniaAPI.instance().getAccessoriesInventory(targetPlayer);
                    if (!this.scanInventory((class_1263)targetPlayer.method_31548(), pstack) && !this.scanInventory(binv, pstack)) continue;
                    entIdBuilder.add(targetPlayer.method_5628());
                    continue;
                }
                if (e instanceof class_1915) {
                    class_1915 villager = (class_1915)e;
                    for (class_1914 offer : villager.method_8264()) {
                        if (!this.equalStacks(pstack, offer.method_8246()) && !this.equalStacks(pstack, offer.method_8247()) && !this.equalStacks(pstack, offer.method_8250())) continue;
                        entIdBuilder.add(e.method_5628());
                    }
                    continue;
                }
                if (!(e instanceof class_1263) || !this.scanInventory(inv = (class_1263)e, pstack)) continue;
                entIdBuilder.add(e.method_5628());
            }
            if (!pstack.method_7960()) {
                range = 12;
                class_2338 pos = player.method_24515();
                for (class_2338 pos_ : class_2338.method_10097((class_2338)pos.method_10069(-range, -range, -range), (class_2338)pos.method_10069(range + 1, range + 1, range + 1))) {
                    class_1263 inv;
                    class_2586 tile = player.method_37908().method_8321(pos_);
                    if (tile == null || !(tile instanceof class_1263) || !this.scanInventory(inv = (class_1263)tile, pstack)) continue;
                    blockPosBuilder.add((Object)class_2503.method_23251((long)pos_.method_10063()));
                }
            }
        }
    }

    private boolean equalStacks(class_1799 stack1, class_1799 stack2) {
        return class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    private boolean scanInventory(class_1263 inv, class_1799 pstack) {
        if (pstack.method_7960()) {
            return false;
        }
        for (int l = 0; l < inv.method_5439(); ++l) {
            class_1799 istack = inv.method_5438(l);
            if (istack == null || istack.method_7960() || !this.equalStacks(istack, pstack)) continue;
            return true;
        }
        return false;
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean armor = !living.method_6118(class_1304.field_6169).method_7960();
            bipedModel.field_3398.method_22703(ms);
            ms.method_22904(-0.35, -0.2, armor ? 0.05 : 0.1);
            ms.method_22905(0.75f, -0.75f, -0.75f);
            class_1087 model = MiscellaneousModels.INSTANCE.itemFinderGem;
            class_4588 buffer = buffers.getBuffer(class_4722.method_24074());
            class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
        }
    }
}

