/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.entity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1299;
import net.minecraft.class_5617;
import net.minecraft.class_5619;
import net.minecraft.class_7923;
import net.minecraft.class_897;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.entity.ErroredEntityRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityRendererMap
implements Map<class_1299<?>, class_897<?>> {
    private final Map<class_1299<?>, class_5617<?>> rendererProviders;
    private final LoadingCache<class_1299<?>, class_897<?>> rendererMap;
    private final class_5617.class_5618 context;

    public EntityRendererMap(Map<class_1299<?>, class_5617<?>> rendererProviders, class_5617.class_5618 context) {
        this.rendererProviders = rendererProviders;
        this.context = context;
        this.rendererMap = CacheBuilder.newBuilder().build((CacheLoader)new RenderConstructor());
    }

    @Override
    public int size() {
        return this.rendererProviders.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rendererProviders.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.rendererProviders.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return false;
    }

    @Override
    public class_897<?> get(Object o) {
        try {
            class_897 renderer = (class_897)this.rendererMap.get((Object)((class_1299)o));
            if (renderer == null) {
                throw new AssertionError((Object)"Returned entity renderer should never be null");
            }
            return renderer;
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public class_897<?> put(class_1299<?> entityType, class_897<?> entityRenderer) {
        class_897 old = (class_897)this.rendererMap.getIfPresent(entityType);
        this.rendererMap.put(entityType, entityRenderer);
        return old;
    }

    @Override
    public class_897<?> remove(Object o) {
        class_897 r = (class_897)this.rendererMap.getIfPresent(o);
        this.rendererMap.invalidate(o);
        return r;
    }

    @Override
    public void putAll(@NotNull Map<? extends class_1299<?>, ? extends class_897<?>> map) {
        this.rendererMap.putAll(map);
    }

    @Override
    public void clear() {
        this.rendererMap.invalidateAll();
    }

    @Override
    @NotNull
    public Set<class_1299<?>> keySet() {
        return this.rendererProviders.keySet();
    }

    @Override
    @NotNull
    public Collection<class_897<?>> values() {
        return this.rendererMap.asMap().values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<class_1299<?>, class_897<?>>> entrySet() {
        return this.rendererMap.asMap().entrySet();
    }

    class RenderConstructor
    extends CacheLoader<class_1299<?>, class_897<?>> {
        RenderConstructor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public class_897<?> load(class_1299<?> key) throws Exception {
            class_5617<?> provider = EntityRendererMap.this.rendererProviders.get(key);
            Class<class_5619> clazz = class_5619.class;
            synchronized (class_5619.class) {
                ErroredEntityRenderer renderer;
                try {
                    if (provider == null) {
                        throw new RuntimeException("Provider not registered");
                    }
                    renderer = provider.create(EntityRendererMap.this.context);
                    ModernFix.LOGGER.info("Loaded entity {}", (Object)class_7923.field_41177.method_10221(key));
                }
                catch (RuntimeException e) {
                    ModernFix.LOGGER.error("Failed to create entity model for " + class_7923.field_41177.method_10221(key) + ":", (Throwable)e);
                    renderer = new ErroredEntityRenderer(EntityRendererMap.this.context);
                }
                return renderer;
            }
        }
    }
}

