/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.DiscoveryPacket;
import io.github.kosmx.emotes.common.network.objects.EmoteDataPacket;
import io.github.kosmx.emotes.common.network.objects.EmoteHeaderPacket;
import io.github.kosmx.emotes.common.network.objects.EmoteIconPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.common.network.objects.NetHashMap;
import io.github.kosmx.emotes.common.network.objects.PlayerDataPacket;
import io.github.kosmx.emotes.common.network.objects.SongPacket;
import io.github.kosmx.emotes.common.network.objects.StopPacket;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EmotePacket {
    public static final HashMap<Byte, Byte> defaultVersions = new HashMap();
    public final NetHashMap subPackets = new NetHashMap();
    public final NetData data;
    int version;

    protected EmotePacket(@Nonnull NetData data) {
        if (data.versions == null) {
            data.versions = new HashMap();
        }
        defaultVersions.forEach((aByte, bByte) -> {
            if (!data.versions.containsKey(aByte)) {
                data.versions.put((Byte)aByte, (Byte)bByte);
            }
        });
        this.data = data;
        this.subPackets.put(new EmoteDataPacket());
        this.subPackets.put(new PlayerDataPacket());
        this.subPackets.put(new StopPacket());
        this.subPackets.put(new DiscoveryPacket());
        this.subPackets.put(new SongPacket());
        this.subPackets.put(new EmoteHeaderPacket());
        this.subPackets.put(new EmoteIconPacket());
    }

    public ByteBuffer write() throws IOException {
        if (this.data.purpose == PacketTask.UNKNOWN) {
            throw new IllegalArgumentException("Can't send packet without any purpose...");
        }
        AtomicReference<Byte> partCount = new AtomicReference<Byte>((byte)0);
        AtomicInteger sizeSum = new AtomicInteger(6);
        this.subPackets.forEach((aByte, packet) -> {
            if (packet.doWrite(this.data) && !(packet instanceof SongPacket)) {
                partCount.getAndSet((byte)((Byte)partCount.get() + 1));
                sizeSum.addAndGet(packet.calculateSize(this.data) + 6);
            }
        });
        if (sizeSum.get() > this.data.sizeLimit) {
            throw new IOException("Can't send emote, packet's size is bigger than max allowed");
        }
        SongPacket songPacket = (SongPacket)this.subPackets.get((byte)3);
        int songSize = songPacket.calculateSize(this.data) + 6;
        if (songPacket.doWrite(this.data) && sizeSum.get() + songSize <= this.data.sizeLimit) {
            partCount.getAndSet((byte)(partCount.get() + 1));
            sizeSum.addAndGet(songSize);
        } else {
            this.data.writeSong = false;
        }
        ByteBuffer buf = ByteBuffer.allocate(sizeSum.get());
        buf.putInt(((AbstractNetworkPacket)this.subPackets.get((byte)8)).getVer(this.data.versions));
        buf.put(this.data.purpose.id);
        buf.put(partCount.get());
        AtomicBoolean ex = new AtomicBoolean(false);
        this.subPackets.forEach((aByte, packet) -> {
            try {
                this.writeSubPacket(buf, (AbstractNetworkPacket)packet);
            }
            catch (IOException exception) {
                exception.printStackTrace();
                ex.set(true);
            }
        });
        if (ex.get()) {
            throw new IOException("Exception while writing sub-packages");
        }
        return buf;
    }

    void writeSubPacket(ByteBuffer byteBuffer, AbstractNetworkPacket packetSender) throws IOException {
        if (packetSender.doWrite(this.data)) {
            int len = packetSender.calculateSize(this.data);
            byteBuffer.put(packetSender.getID());
            byteBuffer.put(packetSender.getVer(this.data.versions));
            byteBuffer.putInt(len);
            int currentIndex = byteBuffer.position();
            packetSender.write(byteBuffer, this.data);
            if (byteBuffer.position() != currentIndex + len) {
                throw new IOException("Incorrect size calculator: " + packetSender.getClass());
            }
        }
    }

    @Nullable
    public NetData read(ByteBuffer byteBuffer) throws IOException {
        try {
            this.version = byteBuffer.getInt();
            if (this.version > 8) {
                throw new IOException("Can't read newer version");
            }
            this.data.purpose = PacketTask.getTaskFromID(byteBuffer.get());
            int count = byteBuffer.get();
            for (int i = 0; i < count; ++i) {
                byte id = byteBuffer.get();
                byte sub_version = byteBuffer.get();
                int size = byteBuffer.getInt();
                int currentPos = byteBuffer.position();
                if (this.subPackets.containsKey(id)) {
                    if (!((AbstractNetworkPacket)this.subPackets.get(id)).read(byteBuffer, this.data, sub_version)) {
                        throw new IOException("Invalid " + ((AbstractNetworkPacket)this.subPackets.get(id)).getClass().getName() + " sub-packet received");
                    }
                    if (byteBuffer.position() == size + currentPos) continue;
                    ((Buffer)byteBuffer).position(currentPos + size);
                    continue;
                }
                ((Buffer)byteBuffer).position(currentPos + size);
            }
            if (this.data.prepareAndValidate()) {
                return this.data;
            }
            return null;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new IOException(e.getClass().getTypeName() + " has occurred: " + e.getMessage());
        }
    }

    static {
        AbstractNetworkPacket tmp = new EmoteDataPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new PlayerDataPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new DiscoveryPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new StopPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new SongPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new EmoteHeaderPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new EmoteIconPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
    }

    public static class Builder {
        final NetData data;

        public Builder setVersion(HashMap<Byte, Byte> versions) {
            this.data.versions = versions;
            return this;
        }

        public NetData copyAndGetData() {
            return this.data.copy();
        }

        public Builder(NetData data) {
            this.data = data;
        }

        public Builder copy() {
            return new Builder(this.data.copy());
        }

        public Builder() {
            this.data = new NetData();
        }

        public Builder setThreshold(float t) {
            this.data.threshold = t;
            return this;
        }

        public EmotePacket build() {
            return new EmotePacket(this.data);
        }

        public EmotePacket build(int sizeLimit) {
            return this.setSizeLimit(sizeLimit).build();
        }

        public Builder setSizeLimit(int sizeLimit) {
            if (sizeLimit <= 0) {
                throw new IllegalArgumentException("Size limit must be positive");
            }
            this.data.sizeLimit = sizeLimit;
            return this;
        }

        public Builder configureToStreamEmote(KeyframeAnimation emoteData, @Nullable UUID player) {
            if (this.data.purpose != PacketTask.UNKNOWN) {
                throw new IllegalArgumentException("Can's send and stop emote at the same time");
            }
            this.data.purpose = PacketTask.STREAM;
            this.data.emoteData = emoteData;
            this.data.player = player;
            return this;
        }

        public Builder configureToSaveEmote(KeyframeAnimation emoteData) {
            if (this.data.purpose != PacketTask.UNKNOWN) {
                throw new IllegalArgumentException("already configured?!");
            }
            this.data.purpose = PacketTask.FILE;
            this.data.sizeLimit = Integer.MAX_VALUE;
            this.data.emoteData = emoteData;
            return this;
        }

        public Builder configureEmoteTick(int tick) {
            this.data.tick = tick;
            return this;
        }

        public Builder configureTarget(@Nullable UUID target) {
            this.data.player = target;
            return this;
        }

        public Builder configureToStreamEmote(KeyframeAnimation emoteData) {
            return this.configureToStreamEmote(emoteData, null);
        }

        public Builder configureToSendStop(UUID emoteID, @Nullable UUID player) {
            if (this.data.purpose != PacketTask.UNKNOWN) {
                throw new IllegalArgumentException("Can't send emote and stop at the same time");
            }
            this.data.purpose = PacketTask.STOP;
            this.data.stopEmoteID = emoteID;
            this.data.player = player;
            return this;
        }

        public Builder configureToSendStop(UUID emoteID) {
            return this.configureToSendStop(emoteID, null);
        }

        public Builder configureToConfigExchange(boolean songEnabled) {
            if (this.data.purpose != PacketTask.UNKNOWN) {
                throw new IllegalArgumentException("Can't send config with emote or stop data...");
            }
            this.data.purpose = PacketTask.CONFIG;
            HashMap<Byte, Byte> versions = new HashMap<Byte, Byte>(defaultVersions);
            if (!songEnabled) {
                versions.replace((byte)3, (byte)0);
            }
            this.data.versions = versions;
            return this;
        }

        public void removePlayerID() {
            this.data.player = null;
        }
    }
}

