/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1086;
import net.minecraft.class_1100;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_8177;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseButtonBlock
extends class_2269
implements BlockModelProvider,
TagProvider,
DropSelfLootProvider<BaseButtonBlock> {
    private final class_2248 parent;

    protected BaseButtonBlock(class_2248 parent, class_4970.class_2251 properties, boolean sensitive, class_8177 type) {
        this(parent, properties, 30, sensitive, type);
    }

    protected BaseButtonBlock(class_2248 parent, class_4970.class_2251 properties, int ticksToStayPressed, boolean sensitive, class_8177 type) {
        super(properties.method_9634(), type, ticksToStayPressed, sensitive);
        this.parent = parent;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_793 getItemModel(class_2960 blockId) {
        class_2960 parentId = class_7923.field_41175.method_10221((Object)this.parent);
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.ITEM_BUTTON, parentId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_793 getBlockModel(class_2960 resourceLocation, class_2680 blockState) {
        class_2960 parentId = class_7923.field_41175.method_10221((Object)this.parent);
        Optional<String> pattern = (Boolean)blockState.method_11654((class_2769)field_10729) != false ? PatternsHelper.createJson(BasePatterns.BLOCK_BUTTON_PRESSED, parentId) : PatternsHelper.createJson(BasePatterns.BLOCK_BUTTON, parentId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1100 getModelVariant(class_2960 stateId, class_2680 blockState, Map<class_2960, class_1100> modelCache) {
        String powered = (Boolean)blockState.method_11654((class_2769)field_10729) != false ? "_powered" : "";
        class_2960 modelId = new class_2960(stateId.method_12836(), "block/" + stateId.method_12832() + powered);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        class_2738 face = (class_2738)blockState.method_11654((class_2769)field_11007);
        boolean isCeiling = face == class_2738.field_12473;
        int x = 0;
        int y = 0;
        switch (face) {
            case field_12473: {
                x = 180;
                break;
            }
            case field_12471: {
                x = 90;
                break;
            }
        }
        switch ((class_2350)blockState.method_11654((class_2769)field_11177)) {
            case field_11043: {
                if (!isCeiling) break;
                y = 180;
                break;
            }
            case field_11034: {
                y = isCeiling ? 270 : 90;
                break;
            }
            case field_11035: {
                if (isCeiling) break;
                y = 180;
                break;
            }
            case field_11039: {
                y = isCeiling ? 90 : 270;
                break;
            }
        }
        class_1086 rotation = class_1086.method_4699((int)x, (int)y);
        return ModelsHelper.createMultiVariant(modelId, rotation.method_3509(), face == class_2738.field_12471);
    }

    @Override
    public void addTags(List<class_6862<class_2248>> blockTags, List<class_6862<class_1792>> itemTags) {
        blockTags.add((class_6862<class_2248>)class_3481.field_15493);
        itemTags.add((class_6862<class_1792>)class_3489.field_15551);
    }

    public static BaseButtonBlock from(class_2248 source, class_8177 type) {
        return BehaviourHelper.from(source, type, Wood::new, Stone::new, Metal::new);
    }

    public static class Wood
    extends BaseButtonBlock
    implements BehaviourWood {
        public Wood(class_2248 source, class_8177 type) {
            super(source, class_4970.class_2251.method_9630((class_4970)source).method_9629(0.5f, 0.5f).method_22488(), true, type);
        }

        @Override
        public void addTags(List<class_6862<class_2248>> blockTags, List<class_6862<class_1792>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((class_6862<class_2248>)class_3481.field_15499);
            itemTags.add((class_6862<class_1792>)class_3489.field_15555);
        }
    }

    public static class Stone
    extends BaseButtonBlock
    implements BehaviourStone {
        public Stone(class_2248 source, class_8177 type) {
            super(source, class_4970.class_2251.method_9630((class_4970)source).method_22488(), false, type);
        }

        @Override
        public void addTags(List<class_6862<class_2248>> blockTags, List<class_6862<class_1792>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((class_6862<class_2248>)class_3481.field_44590);
            itemTags.add((class_6862<class_1792>)class_3489.field_44592);
        }
    }

    public static class Metal
    extends BaseButtonBlock
    implements BehaviourMetal {
        public Metal(class_2248 source, class_8177 type) {
            super(source, class_4970.class_2251.method_9630((class_4970)source).method_22488(), false, type);
        }
    }
}

