/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials.entry;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.betterx.bclib.complexmaterials.ComplexMaterialSet;
import org.betterx.bclib.complexmaterials.entry.MaterialSlot;
import org.jetbrains.annotations.NotNull;

public class SlotMap<M extends ComplexMaterialSet<? extends ComplexMaterialSet<?>>>
implements Iterable<MaterialSlot<M>> {
    private final Map<String, MaterialSlot<M>> map = new LinkedHashMap<String, MaterialSlot<M>>();

    public static <M extends ComplexMaterialSet<? extends ComplexMaterialSet<?>>> SlotMap<M> of(MaterialSlot<M> ... slots) {
        SlotMap<M> map = new SlotMap<M>();
        for (MaterialSlot<M> slot : slots) {
            map.add(slot);
        }
        return map;
    }

    public SlotMap<M> replace(MaterialSlot<M> slot) {
        return this.add(slot);
    }

    public SlotMap<M> add(MaterialSlot<M> slot) {
        this.map.put(slot.suffix, slot);
        return this;
    }

    public SlotMap<M> remove(MaterialSlot<M> slot) {
        this.map.remove(slot.suffix);
        return this;
    }

    public SlotMap<M> remove(String slot) {
        this.map.remove(slot);
        return this;
    }

    @Override
    @NotNull
    public Iterator<MaterialSlot<M>> iterator() {
        return this.map.values().iterator();
    }
}

