/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.BasinLidBlock;
import com.jesz.createdieselgenerators.recipes.RecipeRegistry;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class BasinLidBlockEntity
extends BasinOperatingBlockEntity {
    public int processingTime;
    public boolean running;
    private static final Object BasinFermentingRecipesKey = new Object();

    public BasinLidBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("MeltingTime", this.processingTime);
        compound.method_10556("Running", this.running);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.processingTime = compound.method_10550("MeltingTime");
        this.running = compound.method_10577("Running");
    }

    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.processingTime = 0;
        this.currentRecipe = null;
        this.running = false;
    }

    public void tick() {
        super.tick();
        if (!(this.field_11863.field_9236 || this.currentRecipe != null && this.processingTime != -1)) {
            this.running = false;
            this.processingTime = -1;
            this.basinChecker.scheduleUpdate();
        }
        if (this.running && this.field_11863 != null) {
            if (!this.field_11863.field_9236 && this.processingTime <= 0) {
                this.processingTime = -1;
                this.applyBasinRecipe();
                this.sendData();
            }
            if (!this.field_11863.field_9236 && this.processingTime % 20 == 0) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14650, class_3419.field_15245, 0.75f, this.speed < 65.0f ? 0.75f : 1.5f);
            }
            if (this.processingTime > 0) {
                --this.processingTime;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        boolean slow;
        super.tickAudio();
        boolean bl = slow = Math.abs(this.getSpeed()) < 65.0f;
        if (slow && AnimationTickHolder.getTicks() % 2 == 0) {
            return;
        }
        if (this.processingTime == 20) {
            AllSoundEvents.MIXING.playAt(this.field_11863, (class_2382)this.field_11867, 0.75f, 1.0f, true);
        }
    }

    protected boolean updateBasin() {
        if (this.running) {
            return true;
        }
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return true;
        }
        if (this.getBasin().filter(BasinBlockEntity::canContinueProcessing).isEmpty()) {
            return true;
        }
        List recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = (class_1860)recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    public void startProcessingBasin() {
        int n;
        if (this.running && this.processingTime > 0) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        class_1860 class_18602 = this.currentRecipe;
        if (class_18602 instanceof ProcessingRecipe) {
            ProcessingRecipe processed = (ProcessingRecipe)class_18602;
            n = processed.getProcessingDuration();
        } else {
            n = 20;
        }
        this.processingTime = n;
    }

    protected boolean isRunning() {
        return this.running;
    }

    protected Optional<BasinBlockEntity> getBasin() {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        class_2586 basinBE = this.field_11863.method_8321(this.field_11867.method_10087(1));
        if (!(basinBE instanceof BasinBlockEntity)) {
            return Optional.empty();
        }
        if (((Boolean)this.method_11010().method_11654((class_2769)BasinLidBlock.OPEN)).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of((BasinBlockEntity)basinBE);
    }

    protected <C extends class_1263> boolean matchStaticFilters(class_1860<C> recipe) {
        return recipe.method_17716() == RecipeRegistry.BASIN_FERMENTING.getType();
    }

    protected Object getRecipeCacheKey() {
        return BasinFermentingRecipesKey;
    }
}

