/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats;

import com.mojang.brigadier.CommandDispatcher;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.command.StatisticsCommand;
import io.github.thecsdev.betterstats.network.BetterStatsNetworkHandler;
import io.github.thecsdev.betterstats.server.BetterStatsServer;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.events.server.command.CommandManagerEvent;
import io.github.thecsdev.tcdcommons.command.PlayerBadgeCommand;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetterStats {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)BetterStats.getModID());
    private static final String ModName = "Better Statistics Screen";
    private static final String ModID = "betterstats";
    private static BetterStats Instance;
    protected final BetterStatsConfig config;
    public static final String URL_SOURCES;
    public static final String URL_ISSUES;
    public static final String URL_CURSEFORGE;
    public static final String URL_MODRINTH;
    public static final String URL_YOUTUBE;
    public static final String URL_KOFI;
    public static final String URL_DISCORD;

    public BetterStats() {
        if (BetterStats.isModInitialized()) {
            throw new IllegalStateException(BetterStats.getModID() + " has already been initialized.");
        }
        if (!BetterStats.isInstanceValid(this)) {
            throw new UnsupportedOperationException("Invalid " + BetterStats.getModID() + " type: " + this.getClass().getName());
        }
        Instance = this;
        LOGGER.info("Initializing '" + BetterStats.getModName() + "' as '" + this.getClass().getSimpleName() + "'.");
        this.config = new BetterStatsConfig(BetterStats.getModID());
        this.config.loadFromFileOrCrash(true);
        BetterStatsNetworkHandler.init();
        CommandManagerEvent.COMMAND_REGISTRATION_CALLBACK.register((dispatcher, commandRegAccess, regEnv) -> {
            if (!this.getConfig().registerCommands) {
                return;
            }
            StatisticsCommand.register((CommandDispatcher<class_2168>)dispatcher, commandRegAccess);
            if (TCDCommons.getInstance().getConfig().enablePlayerBadges) {
                PlayerBadgeCommand.register((CommandDispatcher)dispatcher);
            }
        });
    }

    public static BetterStats getInstance() {
        return Instance;
    }

    public BetterStatsConfig getConfig() {
        return this.config;
    }

    public static String getModName() {
        return ModName;
    }

    public static String getModID() {
        return ModID;
    }

    public static boolean isModInitialized() {
        return BetterStats.isInstanceValid(Instance);
    }

    private static boolean isInstanceValid(BetterStats instance) {
        return BetterStats.isServer(instance) || BetterStats.isClient(instance);
    }

    public static boolean isServer() {
        return BetterStats.isServer(Instance);
    }

    public static boolean isClient() {
        return BetterStats.isClient(Instance);
    }

    private static boolean isServer(BetterStats arg0) {
        return arg0 instanceof BetterStatsServer;
    }

    private static boolean isClient(BetterStats arg0) {
        return arg0 instanceof BetterStatsClient;
    }

    static {
        ModContainer modInfo = (ModContainer)FabricLoader.getInstance().getModContainer(ModID).get();
        URL_SOURCES = (String)modInfo.getMetadata().getContact().get("sources").get();
        URL_ISSUES = (String)modInfo.getMetadata().getContact().get("issues").get();
        CustomValue.CvObject modMenuLinks = modInfo.getMetadata().getCustomValue("modmenu").getAsObject().get("links").getAsObject();
        URL_CURSEFORGE = modMenuLinks.get("modmenu.curseforge").getAsString();
        URL_MODRINTH = modMenuLinks.get("modmenu.modrinth").getAsString();
        URL_YOUTUBE = modMenuLinks.get("modmenu.youtube").getAsString();
        URL_KOFI = modMenuLinks.get("modmenu.kofi").getAsString();
        URL_DISCORD = modMenuLinks.get("modmenu.discord").getAsString();
    }
}

