/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.util;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.GeneralStatWidget;
import io.github.thecsdev.betterstats.api.client.gui.widget.SelectStatsTabWidget;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterGroupBy;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterSortCustomsBy;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterSortItemsBy;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterSortMobsBy;
import io.github.thecsdev.betterstats.client.gui.stats.panel.StatFiltersPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.config.TConfigPanelBuilder;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TTextureElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TCheckboxWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectEnumWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TTextFieldWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.awt.Rectangle;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class StatsTabUtils {
    public static final int GAP = 3;
    public static final class_2960 FILTER_ID_SEARCH = new class_2960(BetterStats.getModID(), "search_query");
    public static final class_2960 FILTER_ID_SHOWEMPTY = new class_2960(BetterStats.getModID(), "show_empty_stats");
    public static final class_2960 FILTER_ID_GROUP = new class_2960(BetterStats.getModID(), "group_by");
    public static final class_2960 FILTER_ID_SORT_CUSTOMS = new class_2960(BetterStats.getModID(), "sort_customs_by");
    public static final class_2960 FILTER_ID_SORT_ITEMS = new class_2960(BetterStats.getModID(), "sort_items_by");
    public static final class_2960 FILTER_ID_SORT_MOBS = new class_2960(BetterStats.getModID(), "sort_mobs_by");

    private StatsTabUtils() {
    }

    public static void initDefaultFilters(StatsTab.FiltersInitContext initContext) {
        StatFilterSettings filterSettings = initContext.getFilterSettings();
        TPanelElement panel = initContext.getFiltersPanel();
        TLabelElement lbl_filters = StatsTabUtils.initGroupLabel(panel, StatFiltersPanel.TXT_FILTERS);
        lbl_filters.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        lbl_filters.setTextColor(0xFFFFFF);
        StatsTab statsTab = initContext.getSelectedStatsTab();
        Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
        SelectStatsTabWidget select_tab = new SelectStatsTabWidget(n1.x, n1.y + panel.getScrollPadding(), n1.width, n1.height);
        try {
            select_tab.setSelected(statsTab);
        }
        catch (NoSuchElementException nse) {
            select_tab.setSelected(null);
        }
        select_tab.setText((class_2561)(statsTab != null ? statsTab.getName() : TextUtils.literal((String)"-")));
        select_tab.eSelectionChanged.register((__, sel) -> initContext.setSelectedStatsTab(sel.getStatsTab()));
        panel.addChild((TElement)select_tab, false);
        Rectangle n2 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
        TTextFieldWidget input_search = new TTextFieldWidget(n2.x, n2.y + 3, n2.width, n2.height);
        input_search.setInput((String)filterSettings.getPropertyOrDefault(FILTER_ID_SEARCH, ""));
        input_search.eTextChanged.register((__, txt) -> {
            filterSettings.setProperty(FILTER_ID_SEARCH, new String[]{txt});
            initContext.refreshStatsTab();
        });
        panel.addChild((TElement)input_search, false);
    }

    public static void initShowEmptyStatsFilter(StatsTab.FiltersInitContext initContext) {
        StatFilterSettings filterSettings = initContext.getFilterSettings();
        TPanelElement panel = initContext.getFiltersPanel();
        int gap = 3 * (panel.getChildren().size() == 0 ? 0 : 1);
        Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
        TCheckboxWidget check_showEmpty = new TCheckboxWidget(n1.x, n1.y + gap, n1.width, n1.height);
        check_showEmpty.setText((class_2561)TextUtils.translatable((String)"betterstats.api.client.gui.stats.panel.statfilterspanel.show_empty_stats", (Object[])new Object[0]));
        check_showEmpty.setChecked(((Boolean)filterSettings.getPropertyOrDefault(FILTER_ID_SHOWEMPTY, false)).booleanValue());
        check_showEmpty.eClicked.register(__ -> {
            filterSettings.setProperty(FILTER_ID_SHOWEMPTY, new Boolean[]{check_showEmpty.getChecked()});
            initContext.refreshStatsTab();
        });
        panel.addChild((TElement)check_showEmpty, false);
    }

    public static void initGroupByFilter(StatsTab.FiltersInitContext initContext) {
        UITexture tex = new UITexture(BSComponentPanel.BS_WIDGETS_TEXTURE, new Rectangle(0, 0, 20, 20));
        StatsTabUtils.initEnumFilter(initContext, tex, FILTER_ID_GROUP, FilterGroupBy.DEFAULT);
    }

    public static void initSortCustomsByFilter(StatsTab.FiltersInitContext initContext) {
        UITexture tex = new UITexture(BSComponentPanel.BS_WIDGETS_TEXTURE, new Rectangle(0, 20, 20, 20));
        StatsTabUtils.initEnumFilter(initContext, tex, FILTER_ID_SORT_CUSTOMS, FilterSortCustomsBy.DEFAULT);
    }

    public static void initSortItemsByFilter(StatsTab.FiltersInitContext initContext) {
        UITexture tex = new UITexture(BSComponentPanel.BS_WIDGETS_TEXTURE, new Rectangle(0, 20, 20, 20));
        StatsTabUtils.initEnumFilter(initContext, tex, FILTER_ID_SORT_ITEMS, FilterSortItemsBy.DEFAULT);
    }

    public static void initSortMobsByFilter(StatsTab.FiltersInitContext initContext) {
        UITexture tex = new UITexture(BSComponentPanel.BS_WIDGETS_TEXTURE, new Rectangle(0, 20, 20, 20));
        StatsTabUtils.initEnumFilter(initContext, tex, FILTER_ID_SORT_MOBS, FilterSortMobsBy.DEFAULT);
    }

    public static <E extends Enum<E>> void initEnumFilter(StatsTab.FiltersInitContext initContext, @Nullable UITexture icon, class_2960 filterId, E defaultValue) throws NullPointerException {
        Objects.requireNonNull(initContext);
        Objects.requireNonNull(filterId);
        Objects.requireNonNull(defaultValue);
        StatFilterSettings filterSettings = initContext.getFilterSettings();
        TPanelElement panel = initContext.getFiltersPanel();
        int gap = 3 * (panel.getChildren().size() == 0 ? 0 : 1);
        Enum filterValue = (Enum)filterSettings.getPropertyOrDefault(filterId, defaultValue);
        Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)panel);
        n1.y += gap;
        if (icon != null) {
            int i = n1.height + 3;
            n1.x += i;
            n1.width -= i;
            TTextureElement ico = new TTextureElement(n1.x - i, n1.y, n1.height, n1.height, icon);
            panel.addChild((TElement)ico, false);
        }
        TSelectEnumWidget sel = new TSelectEnumWidget(n1.x, n1.y, n1.width, n1.height, filterValue);
        sel.eSelectionChanged.register((__, newValue) -> {
            filterSettings.setProperty(filterId, new Enum[]{newValue.getEnumValue()});
            initContext.refreshStatsTab();
        });
        panel.addChild((TElement)sel, false);
    }

    public static TLabelElement initGroupLabel(TPanelElement panel, class_2561 text) {
        int nextX = panel.getScrollPadding();
        int nextY = TConfigPanelBuilder.nextPanelBottomY((TPanelElement)panel) - panel.getY() + (panel.getChildren().size() != 0 ? 10 : 0);
        int nextW = panel.getWidth() - nextX * 2;
        TLabelElement label = new TLabelElement(nextX, nextY, nextW, GeneralStatWidget.HEIGHT, text);
        label.setTextColor(-256);
        label.setTextSideOffset(0);
        panel.addChild((TElement)label, true);
        return label;
    }
}

