/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IllegalHeaderException;
import io.github.thecsdev.betterstats.api.util.io.RAMStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.betterstats.api.util.stats.SUPlayerBadgeStat;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.exceptions.UnsupportedFileVersionException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_7923;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class StatsProviderIO {
    @ApiStatus.Internal
    private static final String MC_ID = new class_2960("air").method_12836();
    public static final String FILE_EXTENSION = "mcbs";
    public static final int FILE_VERSION = 2;

    private StatsProviderIO() {
    }

    public static final void write(class_2540 buffer, IStatsProvider statsProvider) throws NullPointerException {
        Objects.requireNonNull(statsProvider);
        Objects.requireNonNull(buffer);
        buffer.writeBytes("RIFF".getBytes(StandardCharsets.US_ASCII));
        StatsProviderIO.write_file(buffer, statsProvider);
    }

    private static final void write_file(class_2540 buffer, IStatsProvider statsProvider) {
        class_2540 buffer_file = new class_2540(Unpooled.buffer());
        if (FILE_EXTENSION.length() != 4) {
            throw new IllegalStateException("Illegal file extension length, must be 4! Current value: mcbs");
        }
        buffer_file.writeBytes(FILE_EXTENSION.toUpperCase().getBytes(StandardCharsets.US_ASCII));
        buffer_file.writeIntLE(2);
        StatsProviderIO.write_fileChunk("metadata", buffer_file, statsProvider);
        StatsProviderIO.write_fileChunk("general", buffer_file, statsProvider);
        StatsProviderIO.write_fileChunk("item", buffer_file, statsProvider);
        StatsProviderIO.write_fileChunk("mob", buffer_file, statsProvider);
        StatsProviderIO.write_fileChunk("player_badge", buffer_file, statsProvider);
        buffer.writeIntLE(buffer_file.readableBytes());
        buffer.writeBytes((ByteBuf)buffer_file);
        buffer_file.release();
    }

    private static final void write_fileChunk(String chunkId, class_2540 buffer_file, IStatsProvider statsProvider) {
        class_2540 buffer_chunk = new class_2540(Unpooled.buffer());
        buffer_chunk.method_10814(chunkId);
        switch (chunkId) {
            case "metadata": {
                StatsProviderIO.write_fileChunk_meta(buffer_chunk, statsProvider);
                break;
            }
            case "general": {
                StatsProviderIO.write_fileChunk_general(buffer_chunk, statsProvider);
                break;
            }
            case "item": {
                StatsProviderIO.write_fileChunk_item(buffer_chunk, statsProvider);
                break;
            }
            case "mob": {
                StatsProviderIO.write_fileChunk_mob(buffer_chunk, statsProvider);
                break;
            }
            case "player_badge": {
                StatsProviderIO.write_fileChunk_playerBadge(buffer_chunk, statsProvider);
                break;
            }
        }
        buffer_file.writeIntLE(buffer_chunk.readableBytes());
        buffer_file.writeBytes((ByteBuf)buffer_chunk);
        buffer_chunk.release();
    }

    private static final void write_fileChunk_meta(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        @Nullable class_2561 displayName = statsProvider.getDisplayName();
        if (displayName == null) {
            displayName = TextUtils.literal((String)"-");
        }
        buffer_chunk.method_10805(displayName);
        StatsProviderIO.writeGameProfile(buffer_chunk, statsProvider.getGameProfile());
    }

    private static final void write_fileChunk_general(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        ArrayList customStats = Lists.newArrayList((Iterator)class_7923.field_41183.iterator());
        Map<String, List<class_2960>> customStatsMap = customStats.stream().filter(stat -> class_7923.field_41183.method_10221(stat) != null).filter(stat -> statsProvider.getStatValue(class_3468.field_15419.method_14956(stat)) != 0).collect(Collectors.groupingBy(stat -> class_7923.field_41183.method_10221(stat).method_12836()));
        for (Map.Entry<String, List<class_2960>> entry : customStatsMap.entrySet()) {
            String groupModId = entry.getKey();
            List<class_2960> groupStats = entry.getValue();
            buffer_chunk.method_10814(groupModId);
            buffer_chunk.method_10804(groupStats.size());
            for (class_2960 customStatAsIdentifier : groupStats) {
                class_3445 customStat = class_3468.field_15419.method_14956((Object)customStatAsIdentifier);
                int customStatValue = statsProvider.getStatValue(customStat);
                buffer_chunk.method_10814(customStatAsIdentifier.method_12832());
                buffer_chunk.method_10804(customStatValue);
            }
        }
    }

    private static final void write_fileChunk_item(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        Map<String, List<SUItemStat>> stats = SUItemStat.getItemStatsByModGroups(statsProvider, stat -> !stat.isEmpty());
        for (Map.Entry<String, List<SUItemStat>> entry : stats.entrySet()) {
            String groupModId = entry.getKey();
            List<SUItemStat> groupStats = entry.getValue();
            buffer_chunk.method_10814(groupModId);
            buffer_chunk.method_10804(groupStats.size());
            for (SUItemStat stat2 : groupStats) {
                buffer_chunk.method_10814(stat2.getStatID().method_12832());
                buffer_chunk.method_10804(stat2.mined);
                buffer_chunk.method_10804(stat2.crafted);
                buffer_chunk.method_10804(stat2.used);
                buffer_chunk.method_10804(stat2.broken);
                buffer_chunk.method_10804(stat2.pickedUp);
                buffer_chunk.method_10804(stat2.dropped);
            }
        }
    }

    private static final void write_fileChunk_mob(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        Map<String, List<SUMobStat>> stats = SUMobStat.getMobStatsByModGroups(statsProvider, stat -> !stat.isEmpty());
        for (Map.Entry<String, List<SUMobStat>> entry : stats.entrySet()) {
            String groupModId = entry.getKey();
            List<SUMobStat> groupStats = entry.getValue();
            buffer_chunk.method_10814(groupModId);
            buffer_chunk.method_10804(groupStats.size());
            for (SUMobStat stat2 : groupStats) {
                buffer_chunk.method_10814(stat2.getStatID().method_12832());
                buffer_chunk.method_10804(stat2.kills);
                buffer_chunk.method_10804(stat2.deaths);
            }
        }
    }

    private static final void write_fileChunk_playerBadge(class_2540 buffer_chunk, IStatsProvider statsProvider) {
        Map<String, List<SUPlayerBadgeStat>> stats = SUPlayerBadgeStat.getPlayerBadgeStatsByModGroups(statsProvider, stat -> !stat.isEmpty());
        for (Map.Entry<String, List<SUPlayerBadgeStat>> entry : stats.entrySet()) {
            String groupModId = entry.getKey();
            List<SUPlayerBadgeStat> groupStats = entry.getValue();
            buffer_chunk.method_10814(groupModId);
            buffer_chunk.method_10804(groupStats.size());
            for (SUPlayerBadgeStat stat2 : groupStats) {
                buffer_chunk.method_10814(stat2.getStatID().method_12832());
                buffer_chunk.method_10804(stat2.value);
            }
        }
    }

    public static final void read(class_2540 buffer, IEditableStatsProvider statsProvider) throws IllegalHeaderException, UnsupportedFileVersionException {
        if (buffer.readableBytes() < 8) {
            throw new IllegalHeaderException("chunk size >= 8", "chunk size == " + buffer.readableBytes());
        }
        buffer.markReaderIndex();
        try {
            String RIFF = buffer.readSlice(4).toString(StandardCharsets.US_ASCII);
            if (!"RIFF".equalsIgnoreCase(RIFF)) {
                throw new IllegalHeaderException("RIFF", RIFF);
            }
            int fileLength = buffer.readIntLE();
            if (buffer.readableBytes() < fileLength) {
                throw new IllegalHeaderException("chunk size >= " + fileLength, "chunk size == " + buffer.readableBytes());
            }
            class_2540 buffer_file = new class_2540(buffer.readSlice(fileLength));
            StatsProviderIO.read_file(buffer_file, statsProvider);
        }
        catch (IllegalHeaderException | UnsupportedFileVersionException exc) {
            buffer.resetReaderIndex();
            throw exc;
        }
    }

    private static final void read_file(class_2540 buffer_file, IEditableStatsProvider statsProvider) throws IllegalHeaderException, UnsupportedFileVersionException {
        String FEXT = buffer_file.readSlice(4).toString(StandardCharsets.US_ASCII);
        if (!FILE_EXTENSION.equalsIgnoreCase(FEXT)) {
            throw new IllegalHeaderException(FILE_EXTENSION, FEXT);
        }
        int fileVersion = buffer_file.readIntLE();
        if (fileVersion != 2) {
            throw new UnsupportedFileVersionException(Integer.toString(fileVersion));
        }
        while (buffer_file.readableBytes() > 0) {
            String chunkId;
            int chunkSize = buffer_file.readIntLE();
            if (buffer_file.readableBytes() < chunkSize) {
                throw new IllegalHeaderException("chunk size >= " + chunkSize, "chunk size == " + buffer_file.readableBytes());
            }
            class_2540 buffer_chunk = new class_2540(buffer_file.readSlice(chunkSize));
            switch (chunkId = buffer_chunk.method_19772()) {
                case "metadata": {
                    StatsProviderIO.read_fileChunk_meta(buffer_chunk, statsProvider);
                    break;
                }
                case "general": {
                    StatsProviderIO.read_fileChunk_general(buffer_chunk, statsProvider);
                    break;
                }
                case "item": {
                    StatsProviderIO.read_fileChunk_item(buffer_chunk, statsProvider);
                    break;
                }
                case "mob": {
                    StatsProviderIO.read_fileChunk_mob(buffer_chunk, statsProvider);
                    break;
                }
                case "player_badge": {
                    StatsProviderIO.read_fileChunk_playerBadge(buffer_chunk, statsProvider);
                    break;
                }
            }
        }
    }

    private static final void read_fileChunk_meta(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        class_2561 displayName = buffer_chunk.method_10808();
        statsProvider.setDisplayName(displayName);
        if (buffer_chunk.readableBytes() < 2) {
            return;
        }
        @Nullable GameProfile gameProfile = StatsProviderIO.readGameProfile(buffer_chunk);
        statsProvider.setGameProfile(gameProfile);
    }

    private static final void read_fileChunk_general(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.method_19772();
            int entryCount = buffer_chunk.method_10816();
            for (int i = 0; i < entryCount; ++i) {
                String customStatIdPath = buffer_chunk.method_19772();
                int customStatValue = buffer_chunk.method_10816();
                class_2960 customStatId = new class_2960(modId, customStatIdPath);
                class_2960 customStat = (class_2960)class_7923.field_41183.method_10223(customStatId);
                if (customStat == null) continue;
                statsProvider.setStatValue(class_3468.field_15419.method_14956((Object)customStat), customStatValue);
            }
        }
    }

    private static final void read_fileChunk_item(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.method_19772();
            int entryCount = buffer_chunk.method_10816();
            for (int i = 0; i < entryCount; ++i) {
                class_2248 block;
                String itemIdPath = buffer_chunk.method_19772();
                int mined = buffer_chunk.method_10816();
                int crafted = buffer_chunk.method_10816();
                int used = buffer_chunk.method_10816();
                int broken = buffer_chunk.method_10816();
                int pickedUp = buffer_chunk.method_10816();
                int dropped = buffer_chunk.method_10816();
                class_2960 itemId = new class_2960(modId, itemIdPath);
                @Nullable class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
                class_2248 class_22482 = block = item != null ? class_2248.method_9503((class_1792)item) : null;
                if (item == null) continue;
                if (block != null) {
                    statsProvider.setStatValue(class_3468.field_15427, block, mined);
                }
                statsProvider.setStatValue(class_3468.field_15370, item, crafted);
                statsProvider.setStatValue(class_3468.field_15372, item, used);
                statsProvider.setStatValue(class_3468.field_15383, item, broken);
                statsProvider.setStatValue(class_3468.field_15392, item, pickedUp);
                statsProvider.setStatValue(class_3468.field_15405, item, dropped);
            }
        }
    }

    private static final void read_fileChunk_mob(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.method_19772();
            int entryCount = buffer_chunk.method_10816();
            for (int i = 0; i < entryCount; ++i) {
                String mobIdPath = buffer_chunk.method_19772();
                int kills = buffer_chunk.method_10816();
                int deaths = buffer_chunk.method_10816();
                class_2960 mobId = new class_2960(modId, mobIdPath);
                @Nullable class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(mobId);
                if (entityType == null) continue;
                statsProvider.setStatValue(class_3468.field_15403, entityType, kills);
                statsProvider.setStatValue(class_3468.field_15411, entityType, deaths);
            }
        }
    }

    private static final void read_fileChunk_playerBadge(class_2540 buffer_chunk, IEditableStatsProvider statsProvider) {
        while (buffer_chunk.readableBytes() > 0) {
            String modId = buffer_chunk.method_19772();
            int entryCount = buffer_chunk.method_10816();
            for (int i = 0; i < entryCount; ++i) {
                String playerBadgeIdPath = buffer_chunk.method_19772();
                int value = buffer_chunk.method_10816();
                class_2960 playerBadgeId = new class_2960(modId, playerBadgeIdPath);
                statsProvider.setPlayerBadgeValue(playerBadgeId, value);
            }
        }
    }

    public static final void writeGameProfile(class_2540 buffer, @Nullable GameProfile gameProfile) {
        if (gameProfile == null) {
            buffer.writeBoolean(false);
            buffer.writeBoolean(false);
            return;
        }
        UUID uuid = gameProfile.getId();
        String name = gameProfile.getName();
        if (uuid != null) {
            buffer.writeBoolean(true);
            buffer.method_10797(uuid);
        } else {
            buffer.writeBoolean(false);
        }
        if (name != null) {
            buffer.writeBoolean(true);
            buffer.method_10814(name);
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Nullable
    public static final GameProfile readGameProfile(class_2540 buffer) {
        String name;
        UUID uuid = buffer.readBoolean() ? buffer.method_10790() : null;
        String string = name = buffer.readBoolean() ? buffer.method_19772() : null;
        if (name == null && uuid == null) {
            return null;
        }
        return new GameProfile(uuid, name);
    }

    public static void saveToFile(File file, IStatsProvider statsProvider) throws IOException {
        Objects.requireNonNull(file);
        Objects.requireNonNull(statsProvider);
        class_2540 buffer = new class_2540(Unpooled.buffer());
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            try (FileOutputStream fos = new FileOutputStream(file);
                 FileChannel fileChannel = fos.getChannel();){
                StatsProviderIO.write(buffer, statsProvider);
                while (buffer.isReadable()) {
                    buffer.readBytes((GatheringByteChannel)fileChannel, buffer.readableBytes());
                }
            }
        }
        catch (SecurityException se) {
            throw new IOException(se);
        }
        finally {
            buffer.release();
        }
    }

    public static IEditableStatsProvider loadFromFile(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        byte[] fileData = FileUtils.readFileToByteArray((File)file);
        class_2540 buffer = new class_2540(Unpooled.wrappedBuffer((byte[])fileData));
        return new RAMStatsProvider(buffer, true);
    }
}

