/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.util.stats;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.api.util.stats.SUGeneralStat;
import io.github.thecsdev.betterstats.network.BetterStatsNetworkHandler;
import io.github.thecsdev.betterstats.network.PlayerPreferences;
import io.github.thecsdev.betterstats.util.stats.SASConfig;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.Internal
public final class StatAnnouncementSystem {
    private static final String P = "betterstats.util.stats.statannouncementsystem.";
    public static final String TXT_FIRST_MINED = "betterstats.util.stats.statannouncementsystem.first_mine";
    public static final String TXT_FIRST_CRAFTED = "betterstats.util.stats.statannouncementsystem.first_craft";
    public static final String TXT_FIRST_DEATH = "betterstats.util.stats.statannouncementsystem.first_death";
    public static final String TXT_FIRST_DEATH_HC1 = "betterstats.util.stats.statannouncementsystem.first_death.hc1";
    public static final String TXT_FIRST_KILLED = "betterstats.util.stats.statannouncementsystem.first_kill";
    public static final String TXT_FIRST_KILLED_BY = "betterstats.util.stats.statannouncementsystem.first_death_to";
    public static final String TXT_CUSTOM = "betterstats.util.stats.statannouncementsystem.custom";
    private static final class_2561 WATERMARK;
    private static final BetterStatsConfig BSSC;
    private static final SASConfig SASC;
    public static final HashSet<class_2248> FIRST_MINED_BLOCKS;
    public static final HashSet<class_1792> FIRST_CRAFTED_ITEMS;
    public static final HashSet<class_1299<?>> FIRST_KILLED_ENTITIES;
    public static final HashSet<class_1299<?>> FIRST_KILLED_BY_ENTITIES;
    public static final HashSet<class_2960> FIRST_CUSTOM_STATS;

    private StatAnnouncementSystem() {
    }

    @ApiStatus.Internal
    public static final void __handleStatChange(class_3222 player, class_3445<?> stat, int oldValue, int newValue) throws NullPointerException {
        if (!StatAnnouncementSystem.BSSC.enableServerSAS) {
            return;
        }
        if (oldValue == 0 && newValue > 0) {
            Objects.requireNonNull(player);
            Objects.requireNonNull(stat);
            if (player.method_31549().field_7477) {
                return;
            }
            if (stat.method_14949() == class_3468.field_15427 && FIRST_MINED_BLOCKS.contains(stat.method_14951())) {
                StatAnnouncementSystem.broadcastFirstMine(player, (class_2248)stat.method_14951());
            } else if (stat.method_14949() == class_3468.field_15370 && FIRST_CRAFTED_ITEMS.contains(stat.method_14951())) {
                StatAnnouncementSystem.broadcastFirstCraft(player, (class_1792)stat.method_14951());
            } else if (stat.method_14949() == class_3468.field_15403 && FIRST_KILLED_ENTITIES.contains(stat.method_14951())) {
                StatAnnouncementSystem.broadcastFirstKilled(player, (class_1299)stat.method_14951());
            } else if (stat.method_14949() == class_3468.field_15411 && FIRST_KILLED_BY_ENTITIES.contains(stat.method_14951())) {
                StatAnnouncementSystem.broadcastFirstKilledBy(player, (class_1299)stat.method_14951());
            } else if (stat.method_14949() == class_3468.field_15419 && Objects.equals(stat.method_14951(), class_3468.field_15421) && FIRST_CUSTOM_STATS.contains(stat.method_14951())) {
                StatAnnouncementSystem.broadcastFirstDeath(player);
            } else if (stat.method_14949() == class_3468.field_15419 && FIRST_CUSTOM_STATS.contains(stat.method_14951())) {
                class_3445<?> cStat = stat;
                StatAnnouncementSystem.broadcastFirstCustomStat(player, cStat, stat.method_14953(newValue));
            }
        }
    }

    private static final class_5250 formatPlayerText(class_1657 entity) {
        Objects.requireNonNull(entity);
        class_5250 pText = TextUtils.literal((String)"").method_10852(entity.method_5476()).method_27692(class_124.field_1054);
        pText.method_10862(pText.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtils.literal((String)"").method_10852(entity.method_5476()).method_27693("\n").method_10852((class_2561)TextUtils.literal((String)Objects.toString(entity.method_5667()).formatted(class_124.field_1080))))));
        return pText;
    }

    private static final class_5250 formatBlockText(class_2248 block) {
        Objects.requireNonNull(block);
        String blockId = Objects.toString(class_7923.field_41175.method_10221((Object)block));
        class_5250 bText = TextUtils.literal((String)"").method_10852((class_2561)block.method_9518()).method_27692(class_124.field_1060);
        bText.method_10862(bText.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtils.literal((String)"").method_10852((class_2561)block.method_9518()).method_27693("\n").method_10852((class_2561)TextUtils.literal((String)blockId).method_27692(class_124.field_1080)))));
        return bText;
    }

    private static final class_5250 formatItemText(class_1792 item) {
        Objects.requireNonNull(item);
        String itemId = Objects.toString(class_7923.field_41178.method_10221((Object)item));
        class_5250 iText = TextUtils.literal((String)"").method_10852(item.method_7848()).method_27692(class_124.field_1060);
        iText.method_10862(iText.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtils.literal((String)"").method_10852(item.method_7848()).method_27693("\n").method_10852((class_2561)TextUtils.literal((String)itemId).method_27692(class_124.field_1080)))));
        return iText;
    }

    private static final class_5250 formatEntityTypeText(class_1299<?> entityType) {
        Objects.requireNonNull(entityType);
        String entityTypeId = Objects.toString(class_7923.field_41177.method_10221(entityType));
        class_5250 pText = TextUtils.literal((String)"").method_10852(entityType.method_5897()).method_27692(class_124.field_1054);
        pText.method_10862(pText.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtils.literal((String)"").method_10852(entityType.method_5897()).method_27693("\n").method_10852((class_2561)TextUtils.literal((String)entityTypeId).method_27692(class_124.field_1080)))));
        return pText;
    }

    public static final void broadcastFirstMine(class_3222 player, class_2248 minedBlock) throws NullPointerException {
        class_5250 pText = StatAnnouncementSystem.formatPlayerText((class_1657)player);
        class_5250 bText = StatAnnouncementSystem.formatBlockText(minedBlock);
        StatAnnouncementSystem.broadcastBssMessage(player.method_5682(), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)TextUtils.translatable((String)TXT_FIRST_MINED, (Object[])new Object[]{pText, bText})), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)pText).method_27693(" just mined their first ").method_10852((class_2561)bText).method_27693("."));
    }

    public static final void broadcastFirstCraft(class_3222 player, class_1792 craftedItem) throws NullPointerException {
        class_5250 pText = StatAnnouncementSystem.formatPlayerText((class_1657)player);
        class_5250 iText = StatAnnouncementSystem.formatItemText(craftedItem);
        StatAnnouncementSystem.broadcastBssMessage(player.method_5682(), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)TextUtils.translatable((String)TXT_FIRST_CRAFTED, (Object[])new Object[]{pText, iText})), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)pText).method_27693(" just crafted their first ").method_10852((class_2561)iText).method_27693("."));
    }

    public static final void broadcastFirstKilled(class_3222 player, class_1299<?> victimType) {
        class_5250 pText = StatAnnouncementSystem.formatPlayerText((class_1657)player);
        class_5250 etText = StatAnnouncementSystem.formatEntityTypeText(victimType);
        StatAnnouncementSystem.broadcastBssMessage(player.method_5682(), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)TextUtils.translatable((String)TXT_FIRST_KILLED, (Object[])new Object[]{pText, etText})), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)pText).method_27693(" just killed a ").method_10852((class_2561)etText).method_27693(" for their first time."));
    }

    public static final void broadcastFirstKilledBy(class_3222 player, class_1299<?> killerType) {
        class_5250 pText = StatAnnouncementSystem.formatPlayerText((class_1657)player);
        class_5250 etText = StatAnnouncementSystem.formatEntityTypeText(killerType);
        StatAnnouncementSystem.broadcastBssMessage(player.method_5682(), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)TextUtils.translatable((String)TXT_FIRST_KILLED_BY, (Object[])new Object[]{pText, etText})), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)pText).method_27693(" just died to a ").method_10852((class_2561)etText).method_27693(" for their first time."));
    }

    public static final void broadcastFirstDeath(class_3222 player) {
        boolean hardcore = player.method_5682().method_3754();
        String key = hardcore ? TXT_FIRST_DEATH_HC1 : TXT_FIRST_DEATH;
        String literalBrightSide = hardcore ? " On the bright side, it likely won't happen again." : "";
        class_5250 pText = StatAnnouncementSystem.formatPlayerText((class_1657)player);
        StatAnnouncementSystem.broadcastBssMessage(player.method_5682(), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)TextUtils.translatable((String)key, (Object[])new Object[]{pText})), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)pText).method_27693(" died for their first time." + literalBrightSide));
    }

    public static final void broadcastFirstCustomStat(class_3222 player, class_3445<class_2960> stat, String statValue) throws NullPointerException {
        class_5250 pText = StatAnnouncementSystem.formatPlayerText((class_1657)player);
        class_5250 sText = TextUtils.literal((String)"").method_10852(SUGeneralStat.getGeneralStatText(stat)).method_27692(class_124.field_1080);
        class_5250 vText = TextUtils.literal((String)statValue).method_27692(class_124.field_1060);
        StatAnnouncementSystem.broadcastBssMessage(player.method_5682(), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)TextUtils.translatable((String)TXT_CUSTOM, (Object[])new Object[]{pText, sText, vText})), (class_2561)TextUtils.literal((String)"").method_10852(WATERMARK).method_27693(" ").method_10852((class_2561)pText).method_27693(" just increased their ").method_10852((class_2561)sText).method_27693(" stat value to ").method_10852((class_2561)vText).method_27693("."));
    }

    private static final void broadcastBssMessage(MinecraftServer server, class_2561 withBssTranslations, class_2561 allLiteral) throws NullPointerException {
        Objects.requireNonNull(server);
        Objects.requireNonNull(withBssTranslations);
        Objects.requireNonNull(allLiteral);
        if (TCDCommons.isClient() && server instanceof class_1132 && server.method_3788() == 1) {
            server.method_3760().method_43514(withBssTranslations, false);
            return;
        }
        server.method_40000(() -> server.method_3760().method_14571().forEach(player -> {
            PlayerPreferences pp = BetterStatsNetworkHandler.PlayerPrefs.get(player);
            boolean hasBss = pp != null && pp.hasBss;
            class_2561 msg = hasBss ? withBssTranslations : allLiteral;
            player.method_7353(msg, false);
        }));
    }

    static {
        class_2960 id;
        if (!BetterStats.isModInitialized()) {
            throw new ExceptionInInitializerError("Attempted to initialize " + StatAnnouncementSystem.class.getSimpleName() + " prior to " + BetterStats.class.getSimpleName() + "'s initialization.");
        }
        BSSC = BetterStats.getInstance().getConfig();
        SASC = Objects.requireNonNull(StatAnnouncementSystem.BSSC.sasConfig, "SAS config didn't load properly. This shouldn't even happen..");
        class_5250 hoverText = TextUtils.literal((String)BetterStats.getModName()).method_27692(class_124.field_1054).method_27693("\n").method_10852((class_2561)TextUtils.literal((String)BetterStats.getModID()).method_27692(class_124.field_1080));
        class_2568 hoverEvent = new class_2568(class_2568.class_5247.field_24342, (Object)hoverText);
        class_2558 clickEvent = new class_2558(class_2558.class_2559.field_11749, BetterStats.URL_MODRINTH);
        class_5250 text = TextUtils.literal((String)"[\u2261]").method_27692(class_124.field_1064);
        text.method_10862(text.method_10866().method_10949(hoverEvent).method_10958(clickEvent));
        WATERMARK = text;
        FIRST_MINED_BLOCKS = new HashSet();
        FIRST_CRAFTED_ITEMS = new HashSet();
        FIRST_KILLED_ENTITIES = new HashSet();
        FIRST_KILLED_BY_ENTITIES = new HashSet();
        FIRST_CUSTOM_STATS = new HashSet();
        for (String fmbId : StatAnnouncementSystem.SASC.firstMinedBlocks) {
            try {
                id = new class_2960(fmbId);
                class_2248 fmb = class_7923.field_41175.method_17966(id).orElse(null);
                if (fmb == null) continue;
                FIRST_MINED_BLOCKS.add(fmb);
            }
            catch (class_151 e) {
                // empty catch block
            }
        }
        for (String fciId : StatAnnouncementSystem.SASC.firstCraftedItems) {
            try {
                id = new class_2960(fciId);
                class_1792 fci = class_7923.field_41178.method_17966(id).orElse(null);
                if (fci == null) continue;
                FIRST_CRAFTED_ITEMS.add(fci);
            }
            catch (class_151 e) {
                // empty catch block
            }
        }
        for (String fkeId : StatAnnouncementSystem.SASC.firstKilledEntities) {
            try {
                id = new class_2960(fkeId);
                class_1299 fke = class_7923.field_41177.method_17966(id).orElse(null);
                if (fke == null) continue;
                FIRST_KILLED_ENTITIES.add(fke);
            }
            catch (class_151 e) {
                // empty catch block
            }
        }
        for (String fkbeId : StatAnnouncementSystem.SASC.firstKilledByEntities) {
            try {
                id = new class_2960(fkbeId);
                class_1299 fkbe = class_7923.field_41177.method_17966(id).orElse(null);
                if (fkbe == null) continue;
                FIRST_KILLED_BY_ENTITIES.add(fkbe);
            }
            catch (class_151 e) {
                // empty catch block
            }
        }
        for (String fcsId : StatAnnouncementSystem.SASC.firstCustomStats) {
            try {
                id = new class_2960(fcsId);
                class_2960 fcs = class_7923.field_41183.method_17966(id).orElse(null);
                if (fcs == null) continue;
                FIRST_CUSTOM_STATS.add(fcs);
            }
            catch (class_151 e) {
                // empty catch block
            }
        }
    }
}

