/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.block;

import com.tom.cpl.block.BiomeHandler;
import java.util.List;

public class Biome {
    private final BiomeHandler<Object> handler;
    private final Object biome;

    protected <T> Biome(BiomeHandler<T> handler, T biome) {
        this.biome = biome;
        this.handler = handler;
    }

    public Object getBiome() {
        return this.biome;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Biome other = (Biome)obj;
        return this.handler == other.handler && this.handler.equals(this.biome, other.biome);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getBiomeId().hashCode();
        result = 31 * result + this.handler.hashCode();
        return result;
    }

    public boolean isInTag(String tag) {
        return this.handler.isInTag(tag, this.biome);
    }

    public List<String> listTags() {
        return this.handler.listTags(this.biome);
    }

    public String getBiomeId() {
        return this.handler.getBiomeId(this.biome);
    }

    public float getTemperature() {
        return this.handler.getTemperature(this.biome);
    }

    public float getHumidity() {
        return this.handler.getHumidity(this.biome);
    }

    public BiomeHandler.RainType getRainType() {
        return this.handler.getRainType(this.biome);
    }
}

