/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.tom.cpl.command.AbstractCommandBuilder;
import com.tom.cpl.command.ArgType;
import com.tom.cpl.command.CommandCtx;
import com.tom.cpl.command.CommandHandler;
import com.tom.cpl.command.LiteralCommandBuilder;
import com.tom.cpl.command.RequiredCommandBuilder;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class BrigadierCommandHandler<S>
implements CommandHandler<S> {
    private static final DynamicCommandExceptionType ERROR_FAILED = new DynamicCommandExceptionType(a -> (Message)new FormatText("commands.cpm.genericFail", a).remap());
    private final CommandDispatcher<S> dispatcher;

    public BrigadierCommandHandler(CommandDispatcher<S> dispatcher) {
        this.dispatcher = dispatcher;
        this.register();
    }

    protected abstract boolean hasOPPermission(S var1);

    @Override
    public void register(LiteralCommandBuilder builder) {
        LiteralArgumentBuilder cmd = (LiteralArgumentBuilder)this.literal(builder.getName()).requires(this::hasOPPermission);
        this.build((ArgumentBuilder<S, ?>)cmd, builder, Collections.emptyList(), cmd.getLiteral().toLowerCase(Locale.ROOT));
        this.dispatcher.register(cmd);
    }

    private void build(ArgumentBuilder<S, ?> a, AbstractCommandBuilder<?> b, List<RequiredCommandBuilder> args, String prefix) {
        for (AbstractCommandBuilder<?> v : b.getNext()) {
            if (v instanceof LiteralCommandBuilder) {
                LiteralArgumentBuilder<S> n = this.literal(((LiteralCommandBuilder)v).getName());
                this.build((ArgumentBuilder<S, ?>)n, v, args, prefix + "_" + n.getLiteral().toLowerCase(Locale.ROOT));
                a.then(n);
                continue;
            }
            if (!(v instanceof RequiredCommandBuilder)) continue;
            RequiredCommandBuilder rcb = (RequiredCommandBuilder)v;
            RequiredArgumentBuilder n = this.argument(rcb.getId(), this.getType(rcb.getType(), rcb.getSettings()));
            ArrayList<RequiredCommandBuilder> newArgs = new ArrayList<RequiredCommandBuilder>(args);
            newArgs.add(rcb);
            String name = prefix + "_" + rcb.getId().toLowerCase(Locale.ROOT);
            this.build((ArgumentBuilder<S, ?>)n, v, (List<RequiredCommandBuilder>)newArgs, name);
            Function<CommandCtx<?>, List<String>> s = rcb.getPossibleValues();
            if (s != null) {
                n.suggests((c, bu) -> BrigadierCommandHandler.suggestMatching((List)s.apply(new WrappedCtx(c, args)), bu));
            }
            a.then(n);
        }
        if (b.getFunc() != null) {
            Consumer<CommandCtx<?>> cmd = b.getFunc();
            a.executes(c -> {
                WrappedCtx ctx = new WrappedCtx(c, args);
                cmd.accept(ctx);
                if (ctx.getFail() != null) {
                    throw ERROR_FAILED.create((Object)ctx.getFail());
                }
                return ctx.getResult();
            });
        }
    }

    private static CompletableFuture<Suggestions> suggestMatching(List<String> list, SuggestionsBuilder builder) {
        String txt = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String elem : list) {
            if (!elem.toLowerCase(Locale.ROOT).startsWith(txt)) continue;
            builder.suggest(elem);
        }
        return builder.buildFuture();
    }

    protected <T> ArgumentType<T> getType(ArgType type, Object settings) {
        switch (type) {
            case BOOLEAN: {
                return BoolArgumentType.bool();
            }
            case PLAYER: {
                return this.player();
            }
            case INT: {
                if (settings != null) {
                    Pair p = (Pair)settings;
                    return IntegerArgumentType.integer((int)((Integer)p.getKey()), (int)((Integer)p.getValue()));
                }
                return IntegerArgumentType.integer();
            }
            case STRING: {
                if (settings == null || !((Boolean)settings).booleanValue()) {
                    return StringArgumentType.string();
                }
                return StringArgumentType.greedyString();
            }
            case FLOAT: {
                if (settings != null) {
                    Pair p = (Pair)settings;
                    return FloatArgumentType.floatArg((float)((Float)p.getKey()).floatValue(), (float)((Float)p.getValue()).floatValue());
                }
                return FloatArgumentType.floatArg();
            }
        }
        return StringArgumentType.word();
    }

    protected <T> T getValue(CommandContext<S> ctx, ArgType type, String id) throws CommandSyntaxException {
        switch (type) {
            case BOOLEAN: {
                return (T)Boolean.valueOf(BoolArgumentType.getBool(ctx, (String)id));
            }
            case PLAYER: {
                return (T)this.getPlayer(ctx, id);
            }
            case INT: {
                return (T)Integer.valueOf(IntegerArgumentType.getInteger(ctx, (String)id));
            }
            case FLOAT: {
                return (T)Float.valueOf(FloatArgumentType.getFloat(ctx, (String)id));
            }
        }
        return (T)ctx.getArgument(id, String.class);
    }

    public LiteralArgumentBuilder<S> literal(String text) {
        return LiteralArgumentBuilder.literal((String)text);
    }

    public <T> RequiredArgumentBuilder<S, T> argument(String id, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)id, type);
    }

    protected abstract ArgumentType<?> player();

    protected abstract Object getPlayer(CommandContext<S> var1, String var2) throws CommandSyntaxException;

    private class WrappedCtx
    extends CommandCtx<S> {
        public WrappedCtx(CommandContext<S> ctx, List<RequiredCommandBuilder> args) throws CommandSyntaxException {
            super(ctx.getSource(), BrigadierCommandHandler.this);
            for (RequiredCommandBuilder arg : args) {
                this.arg(arg.getId(), BrigadierCommandHandler.this.getValue(ctx, arg.getType(), arg.getId()));
            }
        }
    }
}

