/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui;

import com.google.common.collect.Sets;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UI;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.util.ErrorLog;
import com.tom.cpm.shared.util.Log;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;

public interface IGui
extends UI {
    public static final Set<String> ALLOWED_PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});

    public void drawBox(int var1, int var2, int var3, int var4, int var5);

    public void drawGradientBox(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public void drawText(int var1, int var2, String var3, int var4);

    @Override
    public String i18nFormat(String var1, Object ... var2);

    public int textWidth(String var1);

    public void drawTexture(int var1, int var2, int var3, int var4, int var5, int var6, String var7);

    public void drawTexture(int var1, int var2, int var3, int var4, int var5, int var6, String var7, int var8);

    public void drawTexture(int var1, int var2, int var3, int var4, float var5, float var6, float var7, float var8);

    public void closeGui();

    public UIColors getColors();

    public void setCloseListener(Consumer<Runnable> var1);

    public boolean isShiftDown();

    public boolean isCtrlDown();

    public boolean isAltDown();

    public KeyCodes getKeyCodes();

    public NativeGuiComponents getNative();

    public void setClipboardText(String var1);

    public String getClipboardText();

    public Frame getFrame();

    public void setScale(int var1);

    public int getScale();

    public int getMaxScale();

    public CtxStack getStack();

    public void displayError(String var1);

    public void drawFormattedText(float var1, float var2, IText var3, int var4, float var5);

    public int textWidthFormatted(IText var1);

    public void openURL0(String var1);

    public void drawStack(int var1, int var2, Stack var3);

    public void drawStackTooltip(int var1, int var2, Stack var3);

    default public void drawBox(float x, float y, float w, float h, int color) {
        this.drawBox((int)x, (int)y, (int)w, (int)h, color);
    }

    @Override
    default public void executeLater(Runnable r) {
        MinecraftClientAccess.get().executeLater(() -> {
            try {
                r.run();
            }
            catch (Throwable e) {
                Log.error("Exception while executing task", e);
                ErrorLog.addLog(ErrorLog.LogLevel.ERROR, "Exception while executing task", e);
            }
        });
    }

    default public void pushMatrix() {
        this.getStack().push();
    }

    default public void setPosOffset(Box box) {
        Ctx current = this.getContext();
        current.cutBox = current.cutBox.intersect(new Box(current.off.x + box.x, current.off.y + box.y, box.w, box.h));
        current.cutBox.w = Math.max(current.cutBox.w, 0);
        current.cutBox.h = Math.max(current.cutBox.h, 0);
        current.off = new Vec2i(current.off.x + box.x, current.off.y + box.y);
    }

    public void setupCut();

    default public void popMatrix() {
        this.getStack().pop();
    }

    default public Ctx getContext() {
        return this.getStack().current;
    }

    default public Vec2i getOffset() {
        return this.getStack().current.off;
    }

    default public void drawRectangle(int x, int y, int w, int h, int color) {
        this.drawBox(x, y, w, 1, color);
        this.drawBox(x, y, 1, h, color);
        this.drawBox(x, y + h - 1, w, 1, color);
        this.drawBox(x + w - 1, y, 1, h, color);
    }

    default public void drawRectangle(float x, float y, float w, float h, int color) {
        this.drawBox(x, y, w, 1.0f, color);
        this.drawBox(x, y, 1.0f, h, color);
        this.drawBox(x, y + h - 1.0f, w, 1.0f, color);
        this.drawBox(x + w - 1.0f, y, 1.0f, h, color);
    }

    @Override
    default public void onGuiException(String msg, Throwable e, boolean fatal) {
        Log.error(msg, e);
        ErrorLog.addLog(ErrorLog.LogLevel.ERROR, msg, e);
        if (fatal) {
            Frame frm = this.getFrame();
            if (frm != null) {
                try {
                    frm.onCrashed(msg, e);
                }
                catch (Throwable ex) {
                    e.addSuppressed(ex);
                }
            }
            this.displayError(msg + ": " + e.toString());
        } else {
            Frame frm = this.getFrame();
            if (frm != null) {
                try {
                    frm.logMessage(msg + ": " + e.toString());
                }
                catch (Throwable ex) {
                    e.addSuppressed(ex);
                    this.onGuiException(msg, e, true);
                }
            } else {
                this.displayError(msg + "\n" + e.toString());
            }
        }
    }

    default public String wordWrap(String in, int w) {
        return IGui.wordWrap(in, w, this::textWidth);
    }

    public static String wordWrap(String in, int w, ToIntFunction<String> width) {
        ArrayList<String> text = new ArrayList<String>();
        int splitStart = 0;
        int space = -1;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == ' ' || c == '\\') {
                String s = in.substring(splitStart, i);
                int lw = width.applyAsInt(s);
                if (lw > w) {
                    if (splitStart == space + 1) {
                        text.add(s);
                        splitStart = i + 1;
                    } else {
                        text.add(in.substring(splitStart, space));
                        splitStart = space + 1;
                    }
                }
                space = i;
            }
            if (c != '\\') continue;
            text.add(in.substring(splitStart, i));
            splitStart = i + 1;
        }
        text.add(in.substring(splitStart, in.length()));
        return text.stream().collect(Collectors.joining("\\"));
    }

    default public void drawText(int x, int y, String text, int bgColor, int color) {
        this.drawBox(x, y, this.textWidth(text), 10, bgColor);
        this.drawText(x, y + 1, text, color);
    }

    default public boolean canScaleVanilla() {
        return true;
    }

    default public void openURL(String url) {
        try {
            URI uri = new URI(url);
            String s = uri.getScheme();
            if (s == null) {
                throw new URISyntaxException(url, "Missing protocol");
            }
            if (!ALLOWED_PROTOCOLS.contains(s.toLowerCase(Locale.ROOT))) {
                throw new URISyntaxException(url, "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
            }
            ConfirmPopup p = new ConfirmPopup(this.getFrame(), this.i18nFormat("label.cpm.openURL.title", new Object[0]), this.i18nFormat("label.cpm.openURL.text", url), () -> this.openURL0(url), null);
            GuiElement cancel = p.getElements().remove(p.getElements().size() - 1);
            String c = this.i18nFormat("button.cpm.copy", new Object[0]);
            Button copy = new Button(this, c, () -> {
                this.setClipboardText(url);
                p.close();
            });
            copy.setBounds(new Box(cancel.getBounds().x, cancel.getBounds().y, 25 + this.textWidth(c), 20));
            cancel.setBounds(new Box(cancel.getBounds().x + copy.getBounds().w + 5, cancel.getBounds().y, cancel.getBounds().w, cancel.getBounds().h));
            p.addElement(copy);
            p.addElement(cancel);
            this.getFrame().openPopup(p);
        }
        catch (URISyntaxException urisyntaxexception) {
            Log.error("Can't open url for " + url, urisyntaxexception);
        }
    }

    default public <T> T getNativeGui() {
        return (T)this;
    }

    @Override
    default public void displayMessagePopup(String title, String text, String closeBtn) {
        this.getFrame().openPopup(new MessagePopup(this.getFrame(), title, text, closeBtn));
    }

    @Override
    default public void displayPopup(Function<Frame, PopupPanel> factory) {
        this.getFrame().openPopup(factory.apply(this.getFrame()));
    }

    @Override
    default public void displayConfirm(String title, String msg, Runnable ok, Runnable cancel, String okTxt, String cancelTxt) {
        this.getFrame().openPopup(new ConfirmPopup(this.getFrame(), title, msg, ok, cancel, okTxt, cancelTxt));
    }

    public static class CtxStack {
        private java.util.Stack<Ctx> stack;
        private Ctx current;

        public CtxStack(int w, int h) {
            this.current = new Ctx(w, h);
            this.stack = new java.util.Stack();
        }

        public void push() {
            this.stack.push(this.current);
            this.current = new Ctx(this.current);
        }

        public Ctx pop() {
            this.current = this.stack.pop();
            return this.current;
        }
    }

    public static class Ctx {
        public Vec2i off;
        public Box cutBox;

        public Ctx(Ctx old) {
            this.off = new Vec2i(old.off);
            this.cutBox = new Box(old.cutBox);
        }

        public Ctx(int w, int h) {
            this.off = new Vec2i(0, 0);
            this.cutBox = new Box(0, 0, w, h);
        }
    }
}

