/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.math.Box;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class PopupMenu
extends PopupPanel {
    private int x;
    private int y;
    private Frame frame;
    private ScrollPanel scroll;
    private Panel panel;

    public PopupMenu(IGui gui, Frame frm) {
        super(gui);
        this.frame = frm;
        this.scroll = new ScrollPanel(gui);
        this.panel = new Panel(gui);
        this.scroll.setDisplay(this.panel);
        this.addElement(this.scroll);
    }

    public Button addButton(String name, Runnable r) {
        Button btn = new Button(this.gui, name, () -> {
            r.run();
            this.close();
        });
        btn.setBounds(new Box(0, this.panel.elements.size() * 20, 80, 20));
        this.panel.addElement(btn);
        return btn;
    }

    public Button addMenuButton(String name, PopupMenu menu) {
        int y = this.panel.elements.size() * 20;
        Button btn = new Button(this.gui, name, null);
        btn.setAction(() -> {
            menu.display(this.x + this.getBounds().w, this.y + y - this.scroll.getScrollY());
            menu.setOnClosed(this::close);
        });
        btn.setBounds(new Box(0, y, 80, 20));
        this.panel.addElement(btn);
        return btn;
    }

    public Button addMenuButton(String name, Supplier<PopupMenu> menuIn) {
        int y = this.panel.elements.size() * 20;
        Button btn = new Button(this.gui, name, null);
        btn.setAction(() -> {
            PopupMenu menu = (PopupMenu)menuIn.get();
            menu.display(this.x + this.getBounds().w, this.y + y - this.scroll.getScrollY());
            menu.setOnClosed(this::close);
        });
        btn.setBounds(new Box(0, y, 80, 20));
        this.panel.addElement(btn);
        return btn;
    }

    public Checkbox addCheckbox(String name, Runnable r) {
        Checkbox box = new Checkbox(this.gui, name);
        box.setAction(() -> {
            r.run();
            this.close();
        });
        box.setBounds(new Box(0, this.panel.elements.size() * 20, 80, 20));
        this.panel.addElement(box);
        return box;
    }

    public Checkbox addCheckbox(String name, Consumer<Checkbox> r) {
        Checkbox box = new Checkbox(this.gui, name);
        box.setAction(() -> {
            r.accept(box);
            this.close();
        });
        box.setBounds(new Box(0, this.panel.elements.size() * 20, 80, 20));
        this.panel.addElement(box);
        return box;
    }

    public void add(GuiElement elem) {
        if (elem.bounds == null) {
            elem.bounds = new Box(0, 0, 0, 0);
        }
        elem.setBounds(new Box(elem.bounds.x, elem.bounds.y + this.panel.elements.size() * 20, 80, 20));
        this.panel.addElement(elem);
    }

    public void display(int x, int y) {
        this.display(x, y, 80);
    }

    public void display(int x, int y, int w) {
        this.x = x;
        this.y = y;
        for (GuiElement elem : this.panel.elements) {
            if (elem instanceof Button) {
                w = Math.max(w, this.gui.textWidth(((Button)elem).getText()) + 20);
                continue;
            }
            if (!(elem instanceof Checkbox)) continue;
            w = Math.max(w, this.gui.textWidth(((Checkbox)elem).getText()) + 30);
        }
        for (GuiElement elem : this.panel.elements) {
            Box b = elem.getBounds();
            elem.setBounds(new Box(b.x, b.y, w, b.h));
        }
        int h = this.panel.elements.size() * 20;
        int ph = Math.min(h, this.frame.getBounds().h - y);
        this.panel.setBounds(new Box(0, 0, w, h));
        this.setBounds(new Box(x, y, w, ph));
        this.scroll.setBounds(new Box(0, 0, w, ph));
        this.frame.openPopup(this);
    }

    @Override
    public void mouseClick(MouseEvent event) {
        if (!event.isConsumed() && !event.isInBounds(this.bounds)) {
            this.close();
        }
        super.mouseClick(event);
    }

    @Override
    public boolean hasDecoration() {
        return false;
    }

    public int getY() {
        return this.panel.elements.size() * 20;
    }
}

