/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.util.StackTooltip;
import com.tom.cpl.item.Stack;
import com.tom.cpl.tag.TagManager;
import com.tom.cpm.shared.MinecraftClientAccess;
import java.util.Arrays;
import java.util.List;

public class StackTagSlot
extends GuiElement {
    private TagManager<Stack> mngr;
    private String elem;
    private int size;
    private int index;
    private long lastInc;

    public StackTagSlot(IGui gui, TagManager<Stack> mngr, String elem) {
        super(gui);
        this.mngr = mngr;
        this.elem = elem;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        List<Stack> stacks = this.mngr.listStacks(Arrays.asList(this.elem));
        if (this.size != stacks.size()) {
            this.index = 0;
            this.size = stacks.size();
        }
        if (stacks.isEmpty()) {
            this.gui.drawBox(this.bounds.x, this.bounds.y, 16, 16, -65536);
            return;
        }
        long ticks = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
        if (this.lastInc + 1000L < ticks && this.size > 1) {
            this.lastInc = ticks;
            this.index = (this.index + 1) % this.size;
        }
        Stack st = stacks.get(this.index);
        this.gui.drawStack(this.bounds.x, this.bounds.y, st);
        if (event.isHovered(this.bounds)) {
            new StackTooltip(this.gui.getFrame(), st).set();
        }
    }
}

