/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.nbt;

import com.tom.cpl.math.MathHelper;
import com.tom.cpl.nbt.NBTTag;
import com.tom.cpm.shared.io.IOHelper;
import java.io.IOException;

public class NBTTagFloat
extends NBTTag.NBTPrimitive {
    private float data;

    NBTTagFloat() {
    }

    public NBTTagFloat(float data) {
        this.data = data;
    }

    @Override
    public void write(IOHelper output) throws IOException {
        output.writeFloat(this.data);
    }

    @Override
    public void read(IOHelper input) throws IOException {
        this.data = input.readFloat();
    }

    @Override
    public byte getId() {
        return 5;
    }

    public String toString() {
        return this.data + "f";
    }

    @Override
    public NBTTag copy() {
        return new NBTTagFloat(this.data);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            NBTTagFloat nbttagfloat = (NBTTagFloat)other;
            return this.data == nbttagfloat.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Float.floatToIntBits(this.data);
    }

    @Override
    public long getLong() {
        return (long)this.data;
    }

    @Override
    public int getInt() {
        return MathHelper.floor(this.data);
    }

    @Override
    public short getShort() {
        return (short)(MathHelper.floor(this.data) & 0xFFFF);
    }

    @Override
    public byte getByte() {
        return (byte)(MathHelper.floor(this.data) & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }
}

