/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.TriangleBoundingBox;
import com.tom.cpl.math.Vec2f;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.util.Image;
import java.util.ArrayList;
import java.util.List;

public class VirtualTriangleRenderer {
    public static final Vec4f WHITE = new Vec4f(1.0f, 1.0f, 1.0f, 1.0f);

    private static void plot(Triangle tri, Image img, Vec2i cursor, Image bound) {
        if (tri.culled) {
            return;
        }
        boolean isH = false;
        VirtualTriangleRenderer.triangle(img, (int)tri.verts[0].x, (int)tri.verts[0].y, (int)tri.verts[1].x, (int)tri.verts[1].y, (int)tri.verts[2].x, (int)tri.verts[2].y, isH ? -256 : -16711681);
    }

    private static int sample(float u, float v, Image bound, float r, float g, float b, float a) {
        if (bound == null) {
            int ri = (int)(r * 255.0f) & 0xFF;
            int gi = (int)(g * 255.0f) & 0xFF;
            int bi = (int)(b * 255.0f) & 0xFF;
            int ai = (int)(a * 255.0f) & 0xFF;
            return ai << 24 | ri << 16 | gi << 8 | bi;
        }
        int w = bound.getWidth();
        int h = bound.getHeight();
        int x = (MathHelper.floor(u * (float)w) % w + w) % w;
        int y = (MathHelper.floor(v * (float)h) % h + h) % h;
        return bound.getRGB(x, y);
    }

    public static void triangle(Image img, int x0, int y0, int x1, int y1, int x2, int y2, int col) {
        VirtualTriangleRenderer.line(img, x0, y0, x1, y1, col);
        VirtualTriangleRenderer.line(img, x1, y1, x2, y2, col);
        VirtualTriangleRenderer.line(img, x2, y2, x0, y0, col);
    }

    public static void line(Image img, int x0, int y0, int x1, int y1, int col) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        while (true) {
            int ix = MathHelper.clamp(x0, 0, img.getWidth() - 1);
            int iy = MathHelper.clamp(y0, 0, img.getHeight() - 1);
            img.setRGB(ix, iy, col);
            if (x0 == x1 && y0 == y1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x0 += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y0 += sy;
        }
    }

    public static void plot(TriangleBoundingBox tbb, Image img, Vec2i cursor, Image bound) {
        tbb.getTriangles().forEach(t -> VirtualTriangleRenderer.plot(new Triangle((TriangleBoundingBox.Triangle)t), img, cursor, bound));
        if (cursor.x > 0 && cursor.y > 0) {
            img.fill(cursor.x - 1, cursor.y - 1, 3, 3, -65536);
        }
    }

    private static void swap(Vec2i a, Vec2i b) {
        int x = a.x;
        int y = a.y;
        a.x = b.x;
        a.y = b.y;
        b.x = x;
        b.y = y;
    }

    private static void swap(Vec3f a, Vec3f b) {
        float x = a.x;
        float y = a.y;
        float z = a.z;
        a.x = b.x;
        a.y = b.y;
        a.z = b.z;
        b.x = x;
        b.y = y;
        b.z = z;
    }

    private static void swap(Vec4f a, Vec4f b) {
        float x = a.x;
        float y = a.y;
        float z = a.z;
        float w = a.w;
        a.x = b.x;
        a.y = b.y;
        a.z = b.z;
        a.w = b.w;
        b.x = x;
        b.y = y;
        b.z = z;
        b.w = w;
    }

    public static class Triangle {
        public Vec4f[] verts;
        public Vec2f[] uvs;
        public Vec4f[] colors;
        public boolean culled;

        public Triangle(Vec3f a, Vec3f b, Vec3f c, Vec2f aUV, Vec2f bUV, Vec2f cUV, Vec4f ac, Vec4f bc, Vec4f cc) {
            this.verts = new Vec4f[3];
            this.verts[0] = new Vec4f(a, 1.0f);
            this.verts[1] = new Vec4f(b, 1.0f);
            this.verts[2] = new Vec4f(c, 1.0f);
            this.uvs = new Vec2f[3];
            this.uvs[0] = aUV;
            this.uvs[1] = bUV;
            this.uvs[2] = cUV;
            this.colors = new Vec4f[3];
            this.colors[0] = ac;
            this.colors[1] = bc;
            this.colors[2] = cc;
        }

        public Triangle(TriangleBoundingBox.Triangle tri) {
            this.verts = tri.verts;
            this.uvs = tri.uvs;
            this.culled = tri.culled;
            this.colors = new Vec4f[3];
            this.colors[0] = WHITE;
            this.colors[1] = WHITE;
            this.colors[2] = WHITE;
        }
    }

    public static class VirtualBuffer
    implements VertexBuffer {
        private List<Vertex[]> quads = new ArrayList<Vertex[]>();
        private Vertex current = new Vertex();
        private Vertex[] currentArray = new Vertex[4];
        private int currentV;

        private VirtualBuffer() {
        }

        @Override
        public VertexBuffer pos(float x, float y, float z) {
            this.current.x = x;
            this.current.y = y;
            this.current.z = z;
            return this;
        }

        @Override
        public VertexBuffer tex(float u, float v) {
            this.current.u = u;
            this.current.v = v;
            return this;
        }

        @Override
        public VertexBuffer color(float red, float green, float blue, float alpha) {
            this.current.r = red;
            this.current.g = green;
            this.current.b = blue;
            this.current.a = alpha;
            return this;
        }

        @Override
        public VertexBuffer normal(float x, float y, float z) {
            return this;
        }

        @Override
        public void endVertex() {
            this.currentArray[this.currentV++] = this.current;
            this.current = new Vertex();
            if (this.currentV > 3) {
                this.quads.add(this.currentArray);
                this.currentArray = new Vertex[4];
                this.currentV = 0;
            }
        }

        @Override
        public void finish() {
        }

        public List<Triangle> build() {
            ArrayList<Triangle> tris = new ArrayList<Triangle>();
            for (Vertex[] v : this.quads) {
                Vec3f v0 = new Vec3f(v[0].x, v[0].y, v[0].z);
                Vec3f v1 = new Vec3f(v[1].x, v[1].y, v[1].z);
                Vec3f v2 = new Vec3f(v[2].x, v[2].y, v[2].z);
                Vec3f v3 = new Vec3f(v[3].x, v[3].y, v[3].z);
                Vec2f t0 = new Vec2f(v[0].u, v[0].v);
                Vec2f t1 = new Vec2f(v[1].u, v[1].v);
                Vec2f t2 = new Vec2f(v[2].u, v[2].v);
                Vec2f t3 = new Vec2f(v[3].u, v[3].v);
                Vec4f c0 = new Vec4f(v[0].r, v[0].g, v[0].b, v[0].a);
                Vec4f c1 = new Vec4f(v[1].r, v[1].g, v[1].b, v[1].a);
                Vec4f c2 = new Vec4f(v[2].r, v[2].g, v[2].b, v[2].a);
                Vec4f c3 = new Vec4f(v[3].r, v[3].g, v[3].b, v[3].a);
                tris.add(new Triangle(v0, v1, v2, t0, t1, t2, c0, c1, c2));
                tris.add(new Triangle(v0, v2, v3, t0, t2, t3, c0, c2, c3));
            }
            return tris;
        }

        private static class Vertex {
            private float x;
            private float y;
            private float z;
            private float u;
            private float v;
            private float r;
            private float g;
            private float b;
            private float a;

            private Vertex() {
            }
        }
    }
}

