/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.tag;

import com.tom.cpl.tag.Tag;
import com.tom.cpl.tag.TagManager;
import java.util.Collections;
import java.util.List;

public class CPMTag<T>
implements Tag<T> {
    private final TagManager<T> manager;
    protected List<T> stacks;
    protected final List<String> entries;
    protected final String id;
    protected final boolean builtin;

    public CPMTag(TagManager<T> manager, String id, List<String> entries) {
        this.manager = manager;
        this.id = id;
        this.entries = entries;
        this.builtin = false;
    }

    public CPMTag(TagManager<T> manager, String id, List<String> entries, boolean builtin) {
        this.manager = manager;
        this.id = id;
        this.entries = builtin ? Collections.unmodifiableList(entries) : entries;
        this.builtin = builtin;
    }

    @Override
    public List<T> getAllStacks() {
        return this.getAllStacksInt(null);
    }

    protected List<T> getAllStacksInt(List<CPMTag<T>> dejavu) {
        if (this.stacks == null) {
            this.stacks = this.manager.listStacksInt(this.entries, dejavu);
        }
        return this.stacks;
    }

    @Override
    public boolean is(T stack) {
        return this.manager.isInTag(this.entries, stack);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CPMTag other = (CPMTag)obj;
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    @Override
    public String getId() {
        return "$" + this.id;
    }

    public List<String> getEntries() {
        return this.entries;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }
}

