/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.tag;

import com.tom.cpl.tag.CPMTag;
import com.tom.cpl.tag.NativeTag;
import com.tom.cpl.tag.NativeTagManager;
import com.tom.cpl.tag.Tag;
import com.tom.cpm.shared.util.ErrorLog;
import com.tom.cpm.shared.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TagManager<T> {
    protected final NativeTagManager<T> nativeManager;
    protected TagManager<T> parent;
    protected Map<String, CPMTag<T>> tags = new HashMap<String, CPMTag<T>>();

    public TagManager(NativeTagManager<T> nativeManager) {
        this.nativeManager = nativeManager;
    }

    public TagManager(TagManager<T> parent) {
        this.nativeManager = parent.nativeManager;
        this.parent = parent;
    }

    public Tag<T> create(String id, String ... strings) {
        CPMTag tag = new CPMTag(this, id, Arrays.asList(strings));
        this.tags.put(id, tag);
        return tag;
    }

    public List<T> listStacks(List<String> entries) {
        return this.listStacksInt(entries, null);
    }

    protected List<T> listStacksInt(List<String> entries, List<CPMTag<T>> dejavu) {
        return this.listStacksInt(entries, true, dejavu);
    }

    private List<T> listStacksInt(List<String> entries, boolean scanNative, List<CPMTag<T>> dejavu) {
        if (dejavu == null) {
            dejavu = new ArrayList<CPMTag<T>>();
        }
        LinkedHashSet<T> list = new LinkedHashSet<T>();
        if (this.parent != null) {
            list.addAll(this.parent.listStacksInt(entries, false, dejavu));
        }
        for (String e : entries) {
            if (e.isEmpty()) continue;
            if (e.charAt(0) == '$') {
                CPMTag<T> tag = this.tags.get(e.substring(1));
                if (!dejavu.add(tag) || tag == null) continue;
                list.addAll(tag.getAllStacksInt(dejavu));
                continue;
            }
            if (!scanNative) continue;
            list.addAll(this.nativeManager.listNativeEntries(e));
        }
        return new ArrayList(list);
    }

    public boolean isInTag(List<String> entries, T stack) {
        return this.isInTag(entries, stack, true);
    }

    private boolean isInTag(List<String> entries, T stack, boolean scanNative) {
        if (this.parent != null && this.parent.isInTag(entries, stack, false)) {
            return true;
        }
        for (String e : entries) {
            CPMTag<T> tag;
            if (e.isEmpty() || !(e.charAt(0) == '$' ? (tag = this.tags.get(e.substring(1))) != null && tag.is(stack) : scanNative && this.nativeManager.isInNativeTag(e, stack))) continue;
            return true;
        }
        return false;
    }

    public List<Tag<T>> listStackTags(T stack) {
        return this.listStackTags(stack, true);
    }

    private List<Tag<T>> listStackTags(T stack, boolean scanNative) {
        ArrayList<Tag<T>> list = new ArrayList<Tag<T>>();
        if (this.parent != null) {
            list.addAll(this.parent.listStackTags(stack, false));
        }
        for (CPMTag<T> e : this.tags.values()) {
            if (!e.is(stack)) continue;
            list.add(e);
        }
        if (scanNative) {
            list.addAll(this.nativeManager.listNativeTags(stack).stream().map(t -> new NativeTag<T>(this.nativeManager, (String)t)).collect(Collectors.toList()));
        }
        return list;
    }

    public void applyBuiltin(Map<String, List<Map<String, Object>>> tagMap, String prefix) {
        this.tags.clear();
        tagMap.forEach((t, j) -> {
            try {
                ArrayList<String> entries = new ArrayList<String>();
                boolean builtin = true;
                for (Map map : j) {
                    if (map.getOrDefault("replace", false).booleanValue()) {
                        entries.clear();
                        builtin = true;
                    }
                    builtin &= map.getOrDefault("builtin", false).booleanValue();
                    ((List)map.get("entries")).forEach(e -> entries.add((String)e));
                }
                this.tags.put((String)t, new CPMTag(this, (String)t, (List<String>)entries, builtin));
            }
            catch (Exception e2) {
                ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm builtin tag: " + t, e2);
            }
        });
        Log.info("Loaded " + this.tags.size() + " builtin " + prefix + " tags");
    }

    protected void setParent(TagManager<T> parent) {
        this.parent = parent;
    }

    public List<Tag<T>> listAllTags() {
        return this.listAllTags(true);
    }

    private List<Tag<T>> listAllTags(boolean listNative) {
        ArrayList<Tag<T>> list = new ArrayList<Tag<T>>();
        if (this.parent != null) {
            list.addAll(this.parent.listAllTags(false));
        }
        list.addAll(this.tags.values());
        if (listNative) {
            this.nativeManager.listNativeTags().stream().map(t -> new NativeTag<T>(this.nativeManager, (String)t)).forEach(list::add);
        }
        return list;
    }

    public NativeTagManager<T> getNativeManager() {
        return this.nativeManager;
    }

    public void fromMap(Map<String, List<String>> tagsIn) {
        tagsIn.forEach((k, e) -> this.create((String)k, e.toArray(new String[0])));
    }
}

