/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.LabelText;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpl.text.LiteralText;
import com.tom.cpl.text.StyledText;
import com.tom.cpl.text.TextStyle;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.MarkdownRenderer;
import com.tom.cpl.util.StringBuilderStream;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MarkdownParser {
    private static final Line NULL_LINE = new Line(){

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            return Collections.emptyList();
        }
    };
    private static final Pattern LIST = Pattern.compile("^(\\d+)\\..*$");
    private static final String ESC_CHARS = "!#()*+-.[\\]_{}~";
    private final List<Line> lines = new ArrayList<Line>();
    private final Map<Line, String> headerLines = new HashMap<Line, String>();

    public static MarkdownParser makeErrorPage(IGui gui, Throwable e) {
        StringBuilder sb = new StringBuilder("# ");
        sb.append(gui.i18nFormat("label.cpm.md.loadFail", new Object[0]));
        sb.append("\n");
        sb.append(gui.i18nFormat("label.cpm.md.loadFail." + (e instanceof IOException ? "network" : "unknown"), new Object[0]));
        sb.append("\n```");
        StringBuilderStream.stacktraceToString(e, sb, "\t");
        sb.append("```");
        return new MarkdownParser(sb.toString());
    }

    public MarkdownParser(String input) {
        try (BufferedReader rd = new BufferedReader(new StringReader(input));){
            String ln;
            StringBuilder sb = new StringBuilder();
            String codeBlock = null;
            ArrayList<Component> prefix = new ArrayList<Component>();
            while ((ln = rd.readLine()) != null) {
                String lnt = ln.trim();
                if (lnt.startsWith("```")) {
                    if (codeBlock == null) {
                        this.parseLine(sb, 1.0f, prefix);
                        codeBlock = lnt.substring(3);
                        continue;
                    }
                    this.lines.add(new CodeLine(codeBlock, sb.toString()));
                    sb.setLength(0);
                    codeBlock = null;
                    continue;
                }
                if (codeBlock != null) {
                    sb.append(ln);
                    sb.append('\n');
                    continue;
                }
                if (ln.startsWith("|")) {
                    this.parseLine(sb, 1.0f, prefix);
                    ArrayList<String> t = new ArrayList<String>();
                    t.add(lnt);
                    while ((ln = rd.readLine()) != null && ln.startsWith("|")) {
                        t.add(ln.trim());
                    }
                    this.lines.add(new TableLine(t));
                    continue;
                }
                if (lnt.isEmpty()) {
                    this.parseLine(sb, 1.0f, prefix);
                    this.lines.add(new EmptyLine(12));
                    continue;
                }
                if (lnt.startsWith("#")) {
                    this.parseLine(sb, 1.0f, prefix);
                    this.lines.add(new EmptyLine(8));
                    float scl = 1.0f;
                    if (lnt.startsWith("####")) {
                        scl = 1.1f;
                    } else if (lnt.startsWith("###")) {
                        scl = 1.2f;
                    } else if (lnt.startsWith("##")) {
                        scl = 1.5f;
                    } else if (lnt.startsWith("#")) {
                        scl = 2.0f;
                    }
                    String h = lnt.replaceAll("^#+", "").trim();
                    sb.append(h);
                    Line line = this.parseLine(sb, scl, prefix);
                    this.headerLines.put(line, h.replaceAll("[^a-zA-Z0-9_\\-\\s]", "").replaceAll("[\\s\\-]", "-").toLowerCase(Locale.ROOT));
                    if (scl > 1.3f) {
                        this.lines.add(new HorizontalLine());
                        continue;
                    }
                    this.lines.add(new EmptyLine(4));
                    continue;
                }
                if (lnt.startsWith("- ") || lnt.startsWith("* ")) {
                    this.parseLine(sb, 1.0f, prefix);
                    boolean sub = ln.startsWith(" ");
                    prefix.add(new ListComponent(sub, "* "));
                    sb.append(lnt.substring(1).trim());
                    continue;
                }
                if (LIST.matcher(lnt).matches()) {
                    this.parseLine(sb, 1.0f, prefix);
                    boolean sub = ln.startsWith(" ");
                    Matcher m = LIST.matcher(lnt);
                    m.find();
                    String num = m.group(1);
                    prefix.add(new ListComponent(sub, m.group(1) + ". "));
                    sb.append(lnt.substring(num.length() + 1).trim());
                    continue;
                }
                if (ln.endsWith("  ")) {
                    sb.append(lnt);
                    this.parseLine(sb, 1.0f, prefix);
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(lnt);
            }
            this.parseLine(sb, 1.0f, prefix);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int toElements(MarkdownRenderer mdr, int width, Consumer<List<GuiElement>> elementAdder, Map<String, Integer> header) {
        Cursor c = new Cursor();
        c.maxWidth = width;
        this.lines.forEach(l -> {
            String h = this.headerLines.get(l);
            if (h != null) {
                header.put(h, c.y);
            }
            elementAdder.accept(l.toElements(mdr, c));
        });
        return c.y;
    }

    private Line parseLine(StringBuilder sb, float scl, List<Component> prefix) {
        return MarkdownParser.parseLine(sb, scl, prefix, this.lines);
    }

    private static Line parseLine(StringBuilder sb, float scl, List<Component> prefix, List<Line> lines) {
        if (sb.length() == 0 && (prefix == null || prefix.isEmpty())) {
            return NULL_LINE;
        }
        String text = sb.toString();
        sb.setLength(0);
        ArrayList<Component> comp = new ArrayList<Component>();
        if (prefix != null) {
            comp.addAll(prefix);
            prefix.clear();
        }
        TextStyle current = new TextStyle();
        for (int i = 0; i < text.length(); ++i) {
            String lnk;
            int j;
            char c = text.charAt(i);
            if (c == '\\') {
                char n = MarkdownParser.at(text, i + 1);
                if (ESC_CHARS.indexOf(n) > -1) {
                    sb.append(n);
                    ++i;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '*' || c == '_') {
                if (c == MarkdownParser.at(text, i + 1)) {
                    comp.add(new TextComponent(sb, current));
                    current.bold = !current.bold;
                    ++i;
                    continue;
                }
                comp.add(new TextComponent(sb, current));
                current.italic = !current.italic;
                sb.setLength(0);
                continue;
            }
            if (c == '~' && MarkdownParser.at(text, i + 1) == '~') {
                comp.add(new TextComponent(sb, current));
                current.strikethrough = !current.strikethrough;
                sb.setLength(0);
                ++i;
                continue;
            }
            if (c == '!' && MarkdownParser.at(text, i + 1) == '[') {
                comp.add(new TextComponent(sb, current));
                sb.setLength(0);
                j = i++;
                ++i;
                while (i < text.length() && text.charAt(i) != ']') {
                    sb.append(text.charAt(i));
                    ++i;
                }
                String alt = sb.toString();
                sb.setLength(0);
                if (MarkdownParser.at(text, i + 1) == '(') {
                    ++i;
                    ++i;
                    while (i < text.length() && text.charAt(i) != ')') {
                        sb.append(text.charAt(i));
                        ++i;
                    }
                    lnk = sb.toString();
                    sb.setLength(0);
                    comp.add(new ImageComponent(alt, lnk));
                    continue;
                }
                i = j + 2;
                sb.append("![");
                continue;
            }
            if (c == '$' && MarkdownParser.at(text, i + 1) == '[') {
                comp.add(new TextComponent(sb, current));
                sb.setLength(0);
                j = i++;
                ++i;
                while (i < text.length() && text.charAt(i) != ']') {
                    sb.append(text.charAt(i));
                    ++i;
                }
                String id = sb.toString();
                sb.setLength(0);
                if (MarkdownParser.at(text, i + 1) == '(') {
                    ++i;
                    ++i;
                    while (i < text.length() && text.charAt(i) != ')') {
                        sb.append(text.charAt(i));
                        ++i;
                    }
                    String args = sb.toString();
                    sb.setLength(0);
                    comp.add(new CustomComponent(id, args));
                    continue;
                }
                i = j + 2;
                sb.append("$[");
                continue;
            }
            if (c == '[') {
                comp.add(new TextComponent(sb, current));
                sb.setLength(0);
                j = i++;
                while (i < text.length() && text.charAt(i) != ']') {
                    sb.append(text.charAt(i));
                    ++i;
                }
                String lnkText = sb.toString();
                sb.setLength(0);
                if (MarkdownParser.at(text, i + 1) == '(') {
                    ++i;
                    ++i;
                    while (i < text.length() && text.charAt(i) != ')') {
                        sb.append(text.charAt(i));
                        ++i;
                    }
                    lnk = sb.toString();
                    sb.setLength(0);
                    comp.add(new LinkComponent(lnkText, lnk));
                    continue;
                }
                i = j + 1;
                sb.append("[");
                continue;
            }
            if (c == '`') {
                comp.add(new TextComponent(sb, current));
                sb.setLength(0);
                ++i;
                while (i < text.length() && text.charAt(i) != '`') {
                    sb.append(text.charAt(i));
                    ++i;
                }
                comp.add(new CodeComponent(sb));
                continue;
            }
            sb.append(c);
        }
        comp.add(new TextComponent(sb, current));
        sb.setLength(0);
        ComponentLine line = new ComponentLine(comp, scl);
        if (lines != null) {
            lines.add(line);
        }
        return line;
    }

    private static char at(String s, int i) {
        if (s.length() > i) {
            return s.charAt(i);
        }
        return '\u0000';
    }

    public static List<GuiElement> linewrapSimple(String textIn, Cursor cursor, Function<String, GuiElement> lbl, ToIntFunction<String> width) {
        return MarkdownParser.linewrap(textIn, cursor, Function.identity(), lbl, width);
    }

    public static <T> List<GuiElement> linewrap(String textIn, Cursor cursor, Function<String, T> toText, Function<T, GuiElement> lbl, ToIntFunction<T> width) {
        ArrayList<GuiElement> text = new ArrayList<GuiElement>();
        int splitStart = 0;
        int space = -1;
        float h = 10.0f * cursor.scale;
        for (int i = 0; i < textIn.length(); ++i) {
            char c = textIn.charAt(i);
            if (c != ' ') continue;
            T s = toText.apply(textIn.substring(splitStart, i));
            float lw = (float)width.applyAsInt(s) * cursor.scale;
            if ((float)cursor.x + lw > (float)cursor.maxWidth) {
                if (space != -1 || cursor.x <= cursor.maxWidth / 2) {
                    if (splitStart == space + 1) {
                        text.add(lbl.apply(s).setBounds(cursor.bounds(lw, h)));
                        splitStart = i + 1;
                    } else {
                        s = toText.apply(textIn.substring(splitStart, space));
                        text.add(lbl.apply(s).setBounds(cursor.bounds(lw, h)));
                        splitStart = space + 1;
                    }
                }
                cursor.x = cursor.xStart;
                cursor.y = (int)((float)cursor.y + cursor.scale * 10.0f);
            }
            space = i;
        }
        T s = toText.apply(textIn.substring(splitStart, textIn.length()));
        float lw = (float)width.applyAsInt(s) * cursor.scale;
        if ((float)cursor.x + lw > (float)cursor.maxWidth && space != -1) {
            if (splitStart == space + 1) {
                text.add(lbl.apply(s).setBounds(cursor.bounds(lw, h)));
                splitStart = textIn.length();
            } else {
                s = toText.apply(textIn.substring(splitStart, space));
                text.add(lbl.apply(s).setBounds(cursor.bounds(lw, h)));
                splitStart = space + 1;
            }
            cursor.x = cursor.xStart;
            cursor.y = (int)((float)cursor.y + cursor.scale * 10.0f);
        }
        if (splitStart < textIn.length()) {
            s = toText.apply(textIn.substring(splitStart, textIn.length()));
            lw = (float)width.applyAsInt(s) * cursor.scale;
            if ((float)cursor.x + lw > (float)cursor.maxWidth && (space == -1 && cursor.x > cursor.maxWidth / 2 || space != -1)) {
                cursor.x = cursor.xStart;
                cursor.y = (int)((float)cursor.y + cursor.scale * 10.0f);
            }
            text.add(lbl.apply(s).setBounds(cursor.bounds(lw, h)));
            cursor.x = (int)((float)cursor.x + lw);
        }
        return text;
    }

    public static <T> List<GuiElement> linewrapStyled(String textIn, Cursor cursor, TextStyle style, Function<IText, GuiElement> lbl, ToIntFunction<IText> width) {
        return MarkdownParser.linewrap(textIn, cursor, t -> new StyledText(new LiteralText((String)t), style), lbl, width);
    }

    private static interface Line {
        public List<GuiElement> toElements(MarkdownRenderer var1, Cursor var2);
    }

    private static class CodeLine
    implements Line {
        private String[] code;
        private String lang;
        private String c;

        public CodeLine(String lang, String code) {
            this.code = code.split("\n");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.code.length; ++i) {
                String ln = this.code[i];
                for (int j = 0; j < ln.length(); ++j) {
                    char c = ln.charAt(j);
                    if (c == '\t') {
                        int s = 4 - j % 4;
                        for (int k = 0; k < s; ++k) {
                            sb.append(' ');
                        }
                        continue;
                    }
                    sb.append(c);
                }
                this.code[i] = sb.toString();
                sb.setLength(0);
            }
            this.c = code;
            this.lang = lang;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            Code c = new Code(mdr.getGui(), this.lang, this.c, this.code, cursor.bounds(cursor.maxWidth, this.code.length * 10 + 8));
            cursor.y += this.code.length * 10 + 15;
            return Arrays.asList(c);
        }

        private static class Code
        extends Panel {
            public Code(IGui gui, String lang, String c, final String[] code, Box b) {
                super(gui);
                this.setBounds(b);
                Panel p = new Panel(gui);
                p.setBackgroundColor(gui.getColors().button_fill);
                ScrollPanel scp = new ScrollPanel(gui);
                this.addElement(scp);
                scp.setDisplay(p);
                scp.setBounds(new Box(0, 0, b.w, b.h));
                int w = Arrays.stream(code).mapToInt(gui::textWidth).max().orElse(0) + 1;
                if (w > this.bounds.w - 52) {
                    w += 55;
                }
                p.setBounds(new Box(0, 0, w, b.h - 4));
                p.addElement(new GuiElement(gui){

                    @Override
                    public void draw(MouseEvent event, float partialTicks) {
                        int x = this.bounds.x + 3;
                        int y = this.bounds.y + 5;
                        int c = this.gui.getColors().label_text_color;
                        for (int i = 0; i < code.length; ++i) {
                            this.gui.drawText(x, y + i * 10, code[i], c);
                        }
                    }
                }.setBounds(new Box(0, 0, w, b.h - 4)));
                Button cpy = new Button(gui, gui.i18nFormat("button.cpm.copy", new Object[0]), () -> gui.setClipboardText(c));
                cpy.setBounds(new Box(this.bounds.w - 52, 3, 50, 12));
                this.addElement(cpy);
            }
        }
    }

    private static class TableLine
    implements Line {
        private Line[][] table;
        private int cols;

        public TableLine(List<String> lines) {
            try {
                String[][] table = (String[][])lines.stream().map(l -> (String[])Arrays.stream(l.substring(1, l.length() - 1).split("\\|")).map(String::trim).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
                this.cols = table[0].length;
                this.table = new ComponentLine[table.length - 1][this.cols];
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < table.length; ++i) {
                    if (i == 1) continue;
                    String[] c = table[i];
                    for (int j = 0; j < this.cols; ++j) {
                        String txt = c[j];
                        sb.append(txt);
                        this.table[i == 0 ? 0 : i - 1][j] = MarkdownParser.parseLine(sb, 1.0f, null, null);
                    }
                }
            }
            catch (Exception e) {
                Log.warn("Error parsing markdown table", e);
                this.table = null;
            }
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            if (this.table == null) {
                Label l = new Label(mdr.getGui(), "Error parsing table in Markdown");
                l.setBounds(cursor.bounds(0.0f, 0.0f));
                l.setColor(-65536);
                cursor.y += 10;
                return Arrays.asList(l);
            }
            return Arrays.asList(new Table(mdr, cursor));
        }

        private class Table
        extends Panel {
            public Table(MarkdownRenderer mdr, Cursor cursor) {
                super(mdr.getGui());
                Panel[] ps = new Panel[TableLine.this.cols];
                int y = 1;
                int mw = (cursor.maxWidth - 1) / TableLine.this.cols;
                for (int i = 0; i < TableLine.this.table.length; ++i) {
                    int j;
                    Line[] lines = TableLine.this.table[i];
                    int mh = 0;
                    for (j = 0; j < lines.length; ++j) {
                        Panel p;
                        Line line = lines[j];
                        ps[j] = p = new Panel(this.gui);
                        p.setBackgroundColor(i == 0 ? this.gui.getColors().menu_bar_background : (i % 2 == 0 ? this.gui.getColors().button_fill : this.gui.getColors().button_border));
                        Cursor c = new Cursor();
                        c.maxWidth = mw - 1;
                        p.getElements().addAll(line.toElements(mdr, c));
                        mh = Math.max(mh, c.y);
                        this.addElement(p);
                    }
                    for (j = 0; j < ps.length; ++j) {
                        ps[j].setBounds(new Box(1 + j * mw, y, mw - 1, mh));
                    }
                    y += mh;
                    ++y;
                }
                this.setBounds(cursor.bounds(mw * TableLine.this.cols + 1, y));
                this.setBackgroundColor(this.gui.getColors().popup_background);
                cursor.y += y + 10;
            }
        }
    }

    private static class EmptyLine
    implements Line {
        private int height;

        public EmptyLine(int height) {
            this.height = height;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            cursor.y += this.height;
            return Collections.emptyList();
        }
    }

    private static class HorizontalLine
    implements Line {
        private HorizontalLine() {
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            cursor.y += 4;
            return Arrays.asList(new HLine(mdr.getGui()).setBounds(cursor.bounds(0, -4, cursor.maxWidth, 1)));
        }

        private static class HLine
        extends GuiElement {
            public HLine(IGui gui) {
                super(gui);
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, 1, this.gui.getColors().button_disabled);
            }
        }
    }

    private static class ListComponent
    implements Component {
        private boolean sub;
        private String h;

        public ListComponent(boolean sub, String h) {
            this.sub = sub;
            this.h = h;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            int w = mdr.getGui().textWidth(this.h);
            cursor.x = this.sub ? 20 : 5;
            cursor.xStart = cursor.x + w;
            List<GuiElement> l = Arrays.asList(new Label(mdr.getGui(), this.h).setBounds(cursor.bounds(0.0f, 0.0f)));
            cursor.x += w;
            return l;
        }
    }

    public static class Cursor {
        public int maxWidth;
        public int x;
        public int y;
        public int xStart;
        public float scale = 1.0f;

        public Box bounds(float w, float h) {
            return new Box(this.x, this.y, (int)w, (int)h);
        }

        public Box bounds(int x, int y, int w, int h) {
            return new Box(x, this.y + y, w, h);
        }
    }

    private static class TextComponent
    implements Component {
        private String text;
        private TextStyle style;

        public TextComponent(StringBuilder text, TextStyle style) {
            this.text = text.toString();
            text.setLength(0);
            this.style = new TextStyle(style);
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            IGui gui = mdr.getGui();
            return MarkdownParser.linewrapStyled(this.text, cursor, this.style, s -> new LabelText(gui, (IText)s).setScale(cursor.scale), gui::textWidthFormatted);
        }
    }

    private static class ImageComponent
    implements Component {
        private String altText;
        private String url;
        private Vec2i size = new Vec2i();

        public ImageComponent(String altText, String url) {
            this.altText = altText;
            this.url = url;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            IGui gui = mdr.getGui();
            Img i = new Img(gui);
            i.tooltip = new Tooltip(gui.getFrame(), this.altText);
            boolean[] refresh = new boolean[]{false};
            ((CompletableFuture)mdr.getLoader().loadImage(this.url).thenAcceptAsync(img -> {
                if (this.size.x == 0) {
                    this.size.x = img.getWidth();
                    this.size.y = img.getHeight();
                    if (refresh[0]) {
                        mdr.refresh();
                        return;
                    }
                }
                TextureProvider p = new TextureProvider((Image)img, new Vec2i());
                mdr.registerCleanup(p::free);
                i.pr = p;
            }, gui::executeLater)).exceptionally(e -> {
                this.size.x = 16;
                this.size.y = 16;
                i.tooltip = new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.failedToLoadImage", e.getMessage()));
                return null;
            });
            refresh[0] = true;
            if (this.size.x > cursor.maxWidth) {
                float sc = (float)this.size.x / (float)cursor.maxWidth;
                this.size.x = cursor.maxWidth;
                this.size.y = (int)((float)this.size.y / sc);
            }
            i.setBounds(cursor.bounds(this.size.x, this.size.y));
            cursor.x += this.size.x + 1;
            cursor.y += this.size.y + 1;
            return Arrays.asList(i);
        }

        private static class Img
        extends GuiElement {
            private Tooltip tooltip;
            private TextureProvider pr;
            private boolean error;

            public Img(IGui gui) {
                super(gui);
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                if (event.isHovered(this.bounds)) {
                    this.tooltip.set();
                }
                if (this.error) {
                    this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, -65536);
                } else if (this.pr != null) {
                    this.pr.bind();
                    this.gui.drawTexture(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, 0.0f, 0.0f, 1.0f, 1.0f);
                } else {
                    this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_fill);
                }
            }
        }
    }

    private static class CustomComponent
    implements Component {
        private String id;
        private String args;

        public CustomComponent(String id, String args) {
            this.id = id;
            this.args = args;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            MarkdownRenderer.CustomMdElementFactory f = mdr.customElementFactories.get(this.id);
            if (f == null) {
                Label lbl = new Label(mdr.getGui(), "??");
                lbl.setBounds(cursor.bounds(10.0f, 10.0f));
                lbl.setColor(0xFF0000);
                lbl.setTooltip(new Tooltip(mdr.getGui().getFrame(), "Unknown custom component: " + this.id));
                cursor.x += 10;
                return Arrays.asList(lbl);
            }
            return f.create(mdr, cursor, this.args);
        }
    }

    private static class LinkComponent
    implements Component {
        private String text;
        private String url;

        public LinkComponent(String text, String url) {
            this.text = text;
            this.url = url;
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            float s = cursor.scale;
            String url = this.url;
            Runnable click = () -> mdr.browse(url);
            ArrayList hovers = new ArrayList();
            return MarkdownParser.linewrapSimple(this.text, cursor, t -> new Lbl(mdr.getGui(), (String)t, click, s, hovers), mdr.getGui()::textWidth);
        }

        private static class Lbl
        extends GuiElement {
            private LiteralText txt;
            private float scale;
            private Runnable click;
            private List<Predicate<MouseEvent>> hovers;

            public Lbl(IGui gui, String text, Runnable click, float scale, List<Predicate<MouseEvent>> hovers) {
                super(gui);
                this.txt = new LiteralText(text);
                this.scale = scale;
                this.click = click;
                this.hovers = hovers;
                hovers.add(e -> e.isHovered(this.bounds));
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                this.gui.drawFormattedText(this.bounds.x, this.bounds.y, this.txt, this.hovers.stream().anyMatch(p -> p.test(event)) ? this.gui.getColors().link_hover : this.gui.getColors().link_normal, this.scale);
            }

            @Override
            public void mouseClick(MouseEvent event) {
                if (event.isHovered(this.bounds) && event.btn == 0) {
                    this.click.run();
                }
            }
        }
    }

    private static class CodeComponent
    implements Component {
        private String text;

        public CodeComponent(StringBuilder text) {
            this.text = text.toString();
            text.setLength(0);
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            float s = cursor.scale;
            return MarkdownParser.linewrapSimple(this.text, cursor, t -> new Lbl(mdr.getGui(), (String)t, s), mdr.getGui()::textWidth);
        }

        private static class Lbl
        extends GuiElement {
            private String text;
            private LiteralText txt;
            private float scale;

            public Lbl(IGui gui, String text, float scale) {
                super(gui);
                this.text = text;
                this.txt = new LiteralText(text);
                this.scale = scale;
            }

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                this.gui.drawBox((float)this.bounds.x, (float)(this.bounds.y - 1), (float)this.gui.textWidth(this.text) * this.scale, this.scale * 10.0f, this.gui.getColors().button_fill);
                this.gui.drawFormattedText(this.bounds.x, this.bounds.y, this.txt, this.gui.getColors().label_text_color, this.scale);
            }
        }
    }

    private static class ComponentLine
    implements Line {
        private List<Component> components;
        private float scale;

        public ComponentLine(List<Component> components, float scale) {
            this.components = components;
            this.scale = scale;
        }

        public String toString() {
            return this.scale + " " + this.components.toString();
        }

        @Override
        public List<GuiElement> toElements(MarkdownRenderer mdr, Cursor cursor) {
            Cursor sc = new Cursor();
            sc.y = cursor.y;
            sc.maxWidth = cursor.maxWidth;
            sc.scale = this.scale;
            List<GuiElement> e = this.components.stream().flatMap(c -> c.toElements(mdr, sc).stream()).collect(Collectors.toList());
            cursor.y = (int)((float)sc.y + this.scale * 10.0f);
            return e;
        }
    }

    private static interface Component {
        public List<GuiElement> toElements(MarkdownRenderer var1, Cursor var2);
    }
}

