/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IModelComponent;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.animation.interpolator.Interpolator;
import com.tom.cpm.shared.animation.interpolator.InterpolatorType;
import com.tom.cpm.shared.definition.ModelDefinition;

public class Animation
implements IAnimation {
    private final IModelComponent[] componentIDs;
    private final Interpolator[][] psfs;
    private final Boolean[][] show;
    private boolean add;
    private final int duration;
    private final int frames;
    private final int priority;

    public Animation(IModelComponent[] components2, float[][][] data, Boolean[][] show, int duration, int priority, boolean add, InterpolatorType itType) {
        this.componentIDs = components2;
        this.duration = duration;
        this.show = show;
        this.add = add;
        this.priority = priority;
        if (components2.length == 0) {
            this.frames = 0;
            this.psfs = new Interpolator[0][];
            return;
        }
        int components = data.length;
        this.frames = data[0][0].length;
        this.psfs = new Interpolator[components2.length][InterpolatorChannel.VALUES.length];
        for (int component = 0; component < components; ++component) {
            for (InterpolatorChannel channel : InterpolatorChannel.VALUES) {
                Interpolator i = itType.create();
                i.init(data[component][channel.channelID()], channel);
                this.psfs[component][channel.channelID()] = i;
            }
        }
    }

    @Override
    public void animate(long millis, ModelDefinition def) {
        if (this.frames == 0) {
            return;
        }
        float step = (float)millis % (float)this.duration / (float)this.duration * (float)this.frames;
        for (int componentId = 0; componentId < this.componentIDs.length; ++componentId) {
            IModelComponent component = this.componentIDs[componentId];
            component.setRotation(this.add, this.getValue(componentId, InterpolatorChannel.ROT_X, step), this.getValue(componentId, InterpolatorChannel.ROT_Y, step), this.getValue(componentId, InterpolatorChannel.ROT_Z, step));
            component.setPosition(this.add, this.getValue(componentId, InterpolatorChannel.POS_X, step), this.getValue(componentId, InterpolatorChannel.POS_Y, step), this.getValue(componentId, InterpolatorChannel.POS_Z, step));
            component.setColor(this.getValue(componentId, InterpolatorChannel.COLOR_R, step), this.getValue(componentId, InterpolatorChannel.COLOR_G, step), this.getValue(componentId, InterpolatorChannel.COLOR_B, step));
            component.setVisible(this.show[componentId][(int)step]);
            component.setRenderScale(this.add, this.getValue(componentId, InterpolatorChannel.SCALE_X, step), this.getValue(componentId, InterpolatorChannel.SCALE_Y, step), this.getValue(componentId, InterpolatorChannel.SCALE_Z, step));
        }
    }

    private float getValue(int component, InterpolatorChannel attribute, double time) {
        return (float)this.psfs[component][attribute.channelID()].applyAsDouble(time);
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

