/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation.interpolator;

import com.tom.cpm.shared.animation.interpolator.Interpolator;
import com.tom.cpm.shared.animation.interpolator.LinearInterpolator;
import com.tom.cpm.shared.animation.interpolator.LinearLoopInterpolator;
import com.tom.cpm.shared.animation.interpolator.NoInterpolate;
import com.tom.cpm.shared.animation.interpolator.PolynomialSplineInterpolator;
import com.tom.cpm.shared.animation.interpolator.PolynomialSplineLoopInterpolator;
import com.tom.cpm.shared.animation.interpolator.TrigonometricInterpolator;
import com.tom.cpm.shared.animation.interpolator.TrigonometricLoopInterpolator;
import java.util.function.Supplier;

public enum InterpolatorType {
    POLY_LOOP(PolynomialSplineLoopInterpolator::new),
    POLY_SINGLE(PolynomialSplineInterpolator::new, POLY_LOOP),
    LINEAR_LOOP(LinearLoopInterpolator::new),
    LINEAR_SINGLE(LinearInterpolator::new, LINEAR_LOOP),
    NO_INTERPOLATE(NoInterpolate::new),
    TRIG_LOOP(TrigonometricLoopInterpolator::new),
    TRIG_SINGLE(TrigonometricInterpolator::new, TRIG_LOOP);

    public static final InterpolatorType[] VALUES;
    private final Supplier<Interpolator> factory;
    private InterpolatorType altLoop;
    private InterpolatorType altSingle;

    private InterpolatorType(Supplier<Interpolator> factory) {
        this.factory = factory;
    }

    private InterpolatorType(Supplier<Interpolator> factory, InterpolatorType loop) {
        this.factory = factory;
        this.altLoop = loop;
        loop.altSingle = this;
    }

    public Interpolator create() {
        return this.factory.get();
    }

    public InterpolatorType getAlt(boolean loop) {
        if (loop) {
            if (this.altLoop != null) {
                return this.altLoop;
            }
        } else if (this.altSingle != null) {
            return this.altSingle;
        }
        return this;
    }

    static {
        VALUES = InterpolatorType.values();
    }
}

