/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.config;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.shared.animation.ServerAnimationState;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.network.ModelEventType;
import com.tom.cpm.shared.util.ScalingOptions;
import java.util.Base64;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class PlayerData {
    public long ticksSinceLogin;
    public byte[] data;
    public boolean forced;
    public boolean save;
    public final Map<ScalingOptions, Float> scale = new EnumMap<ScalingOptions, Float>(ScalingOptions.class);
    public final EnumSet<ModelEventType> eventSubs = EnumSet.noneOf(ModelEventType.class);
    public byte[] gestureData = new byte[0];
    public Map<String, AnimationInfo> animNames = new HashMap<String, AnimationInfo>();
    public final Map<String, NBTTagCompound> pluginStates = new HashMap<String, NBTTagCompound>();
    public final ServerAnimationState state = new ServerAnimationState();

    public void setModel(byte[] data, boolean forced, boolean save) {
        this.data = data;
        this.forced = forced;
        this.save = save;
    }

    public void setModel(String data, boolean forced, boolean save) {
        this.data = data != null ? Base64.getDecoder().decode(data) : null;
        this.forced = forced;
        this.save = save;
    }

    public boolean canChangeModel() {
        return this.data == null || !this.forced;
    }

    public void load(String id) {
        ConfigEntry sc;
        ConfigEntry e = ModConfig.getWorldConfig().getEntry("skins").getEntry(id);
        boolean forced = e.getBoolean("forced", false);
        String b64 = e.getString("model", null);
        if (b64 != null) {
            this.setModel(b64, forced, true);
        }
        if ((sc = ModConfig.getWorldConfig().getEntry("player_scaling")).hasEntry(id)) {
            sc = sc.getEntry(id);
            for (ScalingOptions opt : ScalingOptions.VALUES) {
                float v = sc.getFloat(opt.getNetKey(), 1.0f);
                if (v == 1.0f) continue;
                this.scale.put(opt, Float.valueOf(v));
            }
        }
    }

    public void save(String id) {
        ConfigEntry e = ModConfig.getWorldConfig().getEntry("skins");
        if (this.save) {
            if (this.data == null) {
                e.clearValue(id);
            } else {
                e = e.getEntry(id);
                e.setString("model", Base64.getEncoder().encodeToString(this.data));
                e.setBoolean("forced", this.forced);
            }
        } else {
            e.clearValue(id);
        }
        ConfigEntry sc = ModConfig.getWorldConfig().getEntry("player_scaling").getEntry(id);
        sc.clear();
        this.scale.forEach((k, v) -> sc.setFloat(k.getNetKey(), v.floatValue()));
        ModConfig.getWorldConfig().save();
    }

    public static class AnimationInfo {
        public final int type;
        public final int id;

        public AnimationInfo(int type, int id) {
            this.type = type;
            this.id = id;
        }

        public boolean isCommandControlled() {
            return (this.type & 0x10) != 0;
        }
    }
}

