/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.anim;

import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.animation.interpolator.Interpolator;
import com.tom.cpm.shared.animation.interpolator.InterpolatorType;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.anim.AnimFrame;
import com.tom.cpm.shared.editor.anim.AnimationProperties;
import com.tom.cpm.shared.editor.anim.IElem;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.project.loaders.AnimationsLoaderV1;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class EditorAnim
implements IAnimation {
    private List<ModelElement> components;
    private final List<AnimFrame> frames = new ArrayList<AnimFrame>();
    public int duration = 1000;
    private Interpolator[][] psfs;
    private AnimFrame currentFrame;
    public final Editor editor;
    public String filename;
    public AnimationType type;
    public IPose pose;
    public String displayName;
    public boolean add = true;
    public boolean loop;
    public boolean command;
    public boolean layerControlled = true;
    public int priority;
    public InterpolatorType intType = InterpolatorType.POLY_LOOP;
    public float layerDefault;
    public int order;
    public boolean isProperty;
    public String group;

    public EditorAnim(Editor e, String filename, AnimationType type, boolean initNew) {
        this.editor = e;
        this.filename = filename;
        this.type = type;
        if (initNew) {
            this.addFrame();
        }
    }

    public EditorAnim(EditorAnim anim) {
        this.editor = anim.editor;
        this.filename = AnimationsLoaderV1.getFileName(anim.pose, anim.displayName);
        this.type = anim.type;
        this.displayName = anim.displayName;
        this.pose = anim.pose;
        this.add = anim.add;
        this.duration = anim.duration;
        this.priority = anim.priority;
        this.loop = anim.loop;
        this.intType = anim.intType;
        this.layerDefault = anim.layerDefault;
        this.order = anim.order;
        this.isProperty = anim.isProperty;
        this.group = anim.group;
        this.command = anim.command;
        anim.frames.stream().map(AnimFrame::new).forEach(this.frames::add);
        if (this.frames.size() > 0) {
            this.currentFrame = this.frames.get(0);
        }
    }

    public void setProperties(AnimationProperties p, ActionBuilder ab) {
        String fn = AnimationsLoaderV1.getFileName(p.pose, p.displayName);
        ab.updateValueOp(this, this.add, p.add, (a, b) -> {
            a.add = b;
        }).updateValueOp(this, this.loop, p.loop, (a, b) -> {
            a.loop = b;
        }).updateValueOp(this, this.displayName, p.displayName, (a, b) -> {
            a.displayName = b;
        }).updateValueOp(this, this.pose, p.pose, (a, b) -> {
            a.pose = b;
        }).updateValueOp(this, this.type, p.type, (a, b) -> {
            a.type = b;
        }).updateValueOp(this, this.filename, fn, (a, b) -> {
            a.filename = b;
        }).updateValueOp(this, this.intType, p.it, (a, b) -> {
            a.intType = b;
        }).updateValueOp(this, this.command, p.command, (a, b) -> {
            a.command = b;
        }).updateValueOp(this, this.layerControlled, p.layerCtrl, (a, b) -> {
            a.layerControlled = b;
        });
    }

    private void calculateSplines() {
        this.components = this.frames.stream().flatMap(AnimFrame::getAllElementsFiltered).distinct().collect(Collectors.toList());
        this.psfs = new Interpolator[this.components.size()][InterpolatorChannel.VALUES.length];
        for (int component = 0; component < this.components.size(); ++component) {
            for (InterpolatorChannel channel : InterpolatorChannel.VALUES) {
                Interpolator i = this.intType.create();
                i.init(AnimFrame.toArray(this, this.components.get(component), channel), channel);
                this.psfs[component][channel.channelID()] = i;
            }
        }
    }

    public float getValue(ModelElement component, InterpolatorChannel attribute, double time) {
        return (float)this.psfs[this.components.indexOf(component)][attribute.channelID()].applyAsDouble(time);
    }

    public void apply() {
        if (this.currentFrame != null) {
            this.currentFrame.apply();
        }
    }

    @Override
    public void animate(long millis, ModelDefinition def) {
        float step;
        if (this.components == null || this.psfs == null) {
            this.calculateSplines();
        }
        boolean remap = false;
        if (this.pose != null && this.pose instanceof VanillaPose && ((VanillaPose)this.pose).hasStateGetter()) {
            step = this.editor.animTestSliders.getOrDefault("__pose", Float.valueOf(0.0f)).floatValue();
            remap = true;
        } else if (this.type == AnimationType.VALUE_LAYER) {
            step = this.editor.animTestSliders.getOrDefault(this.getId(), Float.valueOf(this.layerDefault)).floatValue();
            remap = true;
        } else {
            step = (float)millis % (float)this.duration / (float)this.duration * (float)this.frames.size();
        }
        if (remap) {
            int dd = (int)(step * 1000.0f);
            step = (float)dd % 1001.0f / 1001.0f * (float)this.frames.size();
        }
        for (int i = 0; i < this.components.size(); ++i) {
            ModelElement component = this.components.get(i);
            component.rc.setRotation(this.add, this.getValue(component, InterpolatorChannel.ROT_X, step), this.getValue(component, InterpolatorChannel.ROT_Y, step), this.getValue(component, InterpolatorChannel.ROT_Z, step));
            component.rc.setPosition(this.add, this.getValue(component, InterpolatorChannel.POS_X, step), this.getValue(component, InterpolatorChannel.POS_Y, step), this.getValue(component, InterpolatorChannel.POS_Z, step));
            component.rc.setColor(this.getValue(component, InterpolatorChannel.COLOR_R, step), this.getValue(component, InterpolatorChannel.COLOR_G, step), this.getValue(component, InterpolatorChannel.COLOR_B, step));
            component.rc.setVisible(this.frames.get((int)step).getVisible(component));
            component.rc.setRenderScale(this.add, this.getValue(component, InterpolatorChannel.SCALE_X, step), this.getValue(component, InterpolatorChannel.SCALE_Y, step), this.getValue(component, InterpolatorChannel.SCALE_Z, step));
        }
    }

    public void setPosition(Vec3f v) {
        if (this.currentFrame != null && this.editor.getSelectedElement() != null) {
            this.currentFrame.setPos(this.editor.getSelectedElement(), v);
        }
        this.components = null;
        this.psfs = null;
    }

    public void setRotation(Vec3f v) {
        if (this.currentFrame != null && this.editor.getSelectedElement() != null) {
            this.currentFrame.setRot(this.editor.getSelectedElement(), v);
        }
        this.components = null;
        this.psfs = null;
    }

    public void setScale(Vec3f v) {
        if (this.currentFrame != null && this.editor.getSelectedElement() != null) {
            this.currentFrame.setScale(this.editor.getSelectedElement(), v);
        }
        this.components = null;
        this.psfs = null;
    }

    public void switchVisible() {
        if (this.currentFrame != null && this.editor.getSelectedElement() != null) {
            this.currentFrame.switchVis(this.editor.getSelectedElement());
        }
        this.components = null;
        this.psfs = null;
    }

    public void clearSelectedData(boolean all) {
        if (this.currentFrame != null && this.editor.getSelectedElement() != null) {
            ActionBuilder ab = this.editor.action("clearAnim");
            if (all) {
                this.frames.forEach(f -> f.clearSelectedData(ab, this.editor.getSelectedElement()));
            } else {
                this.currentFrame.clearSelectedData(ab, this.editor.getSelectedElement());
            }
            ab.execute();
        }
        this.components = null;
        this.psfs = null;
    }

    public void setColor(int rgb) {
        if (this.currentFrame != null && this.editor.getSelectedElement() != null) {
            this.currentFrame.setColor(this.editor.getSelectedElement(), rgb);
        }
        this.components = null;
        this.psfs = null;
    }

    public void addFrame() {
        AnimFrame frm = new AnimFrame(this);
        this.editor.action("add", "action.cpm.animFrame").addToList(this.frames, frm).onAction(this::clearCache).execute();
        if (this.currentFrame != null) {
            frm.copy(this.currentFrame);
        }
        this.currentFrame = frm;
    }

    public void addFrame(AnimFrame cpyFrame) {
        AnimFrame frm = new AnimFrame(this, cpyFrame);
        this.editor.action("add", "action.cpm.animFrame").addToList(this.frames, frm).onAction(this::clearCache).execute();
        this.currentFrame = frm;
    }

    public void deleteFrame() {
        if (this.currentFrame != null) {
            int ind = this.frames.indexOf(this.currentFrame) - 1 + this.frames.size();
            this.editor.action("remove", "action.cpm.animFrame").removeFromList(this.frames, this.currentFrame).onAction(this::clearCache).execute();
            if (!this.frames.isEmpty()) {
                this.currentFrame = this.frames.get(ind % this.frames.size());
            }
        }
    }

    public List<AnimFrame> getFrames() {
        return this.frames;
    }

    public List<ModelElement> getComponentsFiltered() {
        return this.frames.stream().flatMap(AnimFrame::getAllElementsFiltered).distinct().collect(Collectors.toList());
    }

    public String toString() {
        if (this.pose != null) {
            return this.editor.ui.i18nFormat("label.cpm.anim_pose", this.pose.getName(this.editor.ui, this.getDisplayName()));
        }
        if (this.type.isStaged()) {
            EditorAnim anim = this.findLinkedAnim();
            if (anim == null) {
                return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), this.getDisplayName());
            }
            return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), anim.toString());
        }
        return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), this.getDisplayName());
    }

    public AnimFrame getSelectedFrame() {
        return this.currentFrame;
    }

    public void setSelectedFrame(AnimFrame currentFrame) {
        this.currentFrame = currentFrame;
    }

    public void prevFrame() {
        if (this.currentFrame == null && !this.frames.isEmpty()) {
            this.currentFrame = this.frames.get(0);
        }
        if (this.frames.size() > 1) {
            int ind = this.frames.indexOf(this.currentFrame) - 1 + this.frames.size();
            this.currentFrame = this.frames.get(ind % this.frames.size());
        }
    }

    public void nextFrame() {
        if (this.currentFrame == null && !this.frames.isEmpty()) {
            this.currentFrame = this.frames.get(0);
        }
        if (this.frames.size() > 1) {
            int ind = this.frames.indexOf(this.currentFrame) + 1;
            this.currentFrame = this.frames.get(ind % this.frames.size());
        }
    }

    public boolean isCustom() {
        return this.type.isCustom();
    }

    public void clearCache() {
        this.components = null;
        this.psfs = null;
    }

    public void moveFrame(int i) {
        if (this.currentFrame == null || this.frames.size() < 2) {
            return;
        }
        int ind = this.frames.indexOf(this.currentFrame);
        if (ind == -1) {
            return;
        }
        int newInd = ind + i;
        if (newInd < 0 || newInd > this.frames.size()) {
            return;
        }
        ActionBuilder ab = this.editor.action("move", "action.cpm.animFrame");
        HashMap<AnimFrame, Float> map = new HashMap<AnimFrame, Float>();
        for (int j = 0; j < this.frames.size(); ++j) {
            map.put(this.frames.get(j), Float.valueOf(j));
        }
        ab.addToMap(map, this.currentFrame, Float.valueOf((float)newInd + 0.1f * (float)i));
        ab.onAction(() -> this.frames.sort(Comparator.comparing(map::get)));
        ab.onAction(this::clearCache);
        ab.execute();
    }

    public float getAnimProgess() {
        int ind = this.frames.indexOf(this.currentFrame);
        if (ind == -1) {
            return 0.0f;
        }
        if (this.frames.size() == 1) {
            return 1.0f;
        }
        return (float)ind / (float)(this.frames.size() - 1);
    }

    public IPose getPose() {
        return this.pose;
    }

    public String getId() {
        String nm = this.displayName;
        int i = nm.indexOf(35);
        if (i == -1) {
            return nm;
        }
        if (i == 0) {
            return "";
        }
        return nm.substring(0, i);
    }

    public String getDisplayGroup() {
        if (this.pose != null) {
            return this.editor.ui.i18nFormat("label.cpm.anim_pose", this.pose.getName(this.editor.ui, this.getId()));
        }
        if (this.type.isStaged()) {
            EditorAnim anim = this.findLinkedAnim();
            if (anim == null) {
                return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), this.getId());
            }
            return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), anim.getDisplayGroup());
        }
        return this.editor.ui.i18nFormat("label.cpm.anim_" + this.type.name().toLowerCase(Locale.ROOT), this.getId());
    }

    public EditorAnim findLinkedAnim() {
        String[] nm = this.displayName.split(":", 2);
        if (nm.length == 2) {
            Predicate<EditorAnim> search = null;
            block5 : switch (nm[0]) {
                case "p": {
                    for (VanillaPose p : VanillaPose.VALUES) {
                        if (!nm[1].equals(p.name().toLowerCase(Locale.ROOT))) continue;
                        search = a -> a.pose == p;
                        break block5;
                    }
                    break;
                }
                case "c": {
                    search = a -> a.pose instanceof CustomPose && ((CustomPose)a.pose).getName().equals(nm[1]);
                    break;
                }
                case "g": {
                    search = a -> a.pose == null && a.getId().equals(nm[1]);
                    break;
                }
            }
            if (search != null) {
                return this.editor.animations.stream().filter(search).findFirst().orElse(null);
            }
        }
        return null;
    }

    public void updateGui() {
        AnimFrame selFrm = this.getSelectedFrame();
        if (selFrm != null) {
            ModelElement selectedElement = this.editor.getSelectedElement();
            this.editor.setAnimFrame.accept(this.getFrames().indexOf(selFrm));
            if (selectedElement != null) {
                IElem dt = selFrm.getData(selectedElement);
                if (dt == null) {
                    if (this.add) {
                        this.editor.setAnimPos.accept(new Vec3f());
                        this.editor.setAnimRot.accept(new Vec3f());
                        if (selectedElement.type != ElementType.ROOT_PART) {
                            this.editor.setAnimScale.accept(new Vec3f(1.0f, 1.0f, 1.0f));
                        }
                    } else if (selectedElement.type == ElementType.ROOT_PART) {
                        PartValues val = ((VanillaModelPart)selectedElement.typeData).getDefaultSize(this.editor.skinType);
                        this.editor.setAnimPos.accept(val.getPos().add(selectedElement.pos));
                        this.editor.setAnimRot.accept(selectedElement.rotation);
                        this.editor.setAnimScale.accept(null);
                    } else {
                        this.editor.setAnimPos.accept(selectedElement.pos);
                        this.editor.setAnimRot.accept(selectedElement.rotation);
                        this.editor.setAnimScale.accept(new Vec3f(1.0f, 1.0f, 1.0f));
                    }
                    if (selectedElement.type != ElementType.ROOT_PART) {
                        if (!selectedElement.texture || selectedElement.recolor) {
                            this.editor.setAnimColor.accept(selectedElement.rgb);
                        }
                        this.editor.setAnimShow.accept(!selectedElement.hidden);
                    }
                } else {
                    if (!selectedElement.texture || selectedElement.recolor) {
                        Vec3f c = dt.getColor();
                        this.editor.setAnimColor.accept((int)c.x << 16 | (int)c.y << 8 | (int)c.z);
                    }
                    this.editor.setAnimPos.accept(dt.getPosition());
                    this.editor.setAnimRot.accept(dt.getRotation());
                    if (selectedElement.type != ElementType.ROOT_PART) {
                        this.editor.setAnimScale.accept(dt.getScale());
                        this.editor.setAnimShow.accept(dt.isVisible());
                    }
                }
            }
            this.editor.setFrameDelEn.accept(true);
        }
        this.editor.setFrameAddEn.accept(true);
        this.editor.setAnimDelEn.accept(true);
        if (!(this.pose instanceof VanillaPose) || !((VanillaPose)this.pose).hasStateGetter()) {
            this.editor.setAnimDuration.accept(this.duration);
        }
        this.editor.setAnimPlayEn.accept(this.getFrames().size() > 1);
        this.editor.setAnimPriority.accept(this.priority);
        if (this.type.isCustom() && !this.type.isStaged()) {
            this.editor.setAnimOrder.accept(this.order);
        }
    }

    public void beginDrag() {
        ModelElement sel = this.editor.getSelectedElement();
        if (this.currentFrame != null && sel != null) {
            this.currentFrame.beginDrag(sel);
        }
    }

    public void endDrag() {
        if (this.currentFrame != null) {
            this.currentFrame.endDrag();
        }
    }

    public void dragVal(TreeElement.VecType type, Vec3f vec) {
        if (this.currentFrame != null) {
            this.currentFrame.dragVal(type, vec);
        }
    }

    public boolean isDragging() {
        return this.currentFrame != null ? this.currentFrame.isDragging() : false;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isLayer() {
        return this.type.isLayer();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    public void reverseFrameOrder(ActionBuilder ab) {
        ArrayList<AnimFrame> f = new ArrayList<AnimFrame>(this.frames);
        ArrayList<AnimFrame> nf = new ArrayList<AnimFrame>(this.frames);
        Collections.reverse(nf);
        ab.onRun(() -> {
            this.frames.clear();
            this.frames.addAll(nf);
        });
        ab.onUndo(() -> {
            this.frames.clear();
            this.frames.addAll(f);
        });
        ab.onRun(this.editor::updateGui);
    }

    public int getSelectedFrameIndex() {
        return this.frames.indexOf(this.currentFrame);
    }
}

