/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.gui.Keybinds;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class PartSearchPopup
extends PopupPanel {
    private TextField search;
    private Editor editor;
    private List<ModelElement> searchIndex = new ArrayList<ModelElement>();
    private List<ModelElement> filteredElems = new ArrayList<ModelElement>();
    private List<TreeElement> treeOpen;
    private String prev = "";

    public PartSearchPopup(IGui gui, Editor editor) {
        super(gui);
        this.editor = editor;
        editor.elements.forEach(this::walk);
        this.treeOpen = editor.treeHandler.getOpenElements();
        String info = gui.i18nFormat("label.cpm.findElement.info", Keybinds.TREE_PREV.getSetKey(gui), Keybinds.TREE_NEXT.getSetKey(gui));
        int w = Math.min(Math.max(gui.textWidth(info) + 12, 160), gui.getFrame().getBounds().w / 2);
        this.search = new TextField(gui){

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                super.draw(event, partialTicks);
                if (PartSearchPopup.this.filteredElems.isEmpty() && !this.getText().isEmpty()) {
                    Box b = this.getBounds();
                    this.gui.drawRectangle(b.x, b.y, b.w, b.h, -65536);
                }
            }
        };
        this.search.setBounds(new Box(5, 5, w - 10, 20));
        this.search.setEventListener(this::updateSearch);
        this.search.setFocused(true);
        this.addElement(this.search);
        this.addElement(new Label(gui, info).setBounds(new Box(5, 30, 0, 0)));
        this.setBounds(new Box(0, 0, w, 45));
    }

    private void walk(ModelElement me) {
        this.searchIndex.add(me);
        me.children.forEach(this::walk);
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.findElement", new Object[0]);
    }

    private void updateSearch() {
        String text = this.search.getText();
        if (text.isEmpty() || this.prev.equals(text)) {
            return;
        }
        this.prev = text;
        Pattern m = null;
        try {
            m = Pattern.compile(text.toLowerCase(), 2);
        }
        catch (Throwable ignore) {
            try {
                m = Pattern.compile(Pattern.quote(text.toLowerCase()), 2);
            }
            catch (Throwable __) {
                return;
            }
        }
        this.filteredElems.clear();
        for (ModelElement me : this.searchIndex) {
            if (!m.matcher(me.name.toLowerCase()).find()) continue;
            this.filteredElems.add(me);
        }
        if (!this.filteredElems.isEmpty() && !this.filteredElems.contains(this.editor.getSelectedElement())) {
            this.editor.treeHandler.setOpenElements(this.treeOpen);
            this.editor.selectedElement = this.filteredElems.get(0);
            this.editor.updateGui();
        }
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (Keybinds.TREE_PREV.isPressed(this.gui, event)) {
            int i = this.filteredElems.indexOf(this.editor.getSelectedElement());
            if (i < 1) {
                return;
            }
            this.editor.treeHandler.setOpenElements(this.treeOpen);
            this.editor.selectedElement = this.filteredElems.get(--i);
            this.editor.updateGui();
            event.consume();
        } else if (Keybinds.TREE_NEXT.isPressed(this.gui, event)) {
            int i = this.filteredElems.indexOf(this.editor.getSelectedElement());
            if (i == -1) {
                return;
            }
            if (++i >= this.filteredElems.size()) {
                return;
            }
            this.editor.treeHandler.setOpenElements(this.treeOpen);
            this.editor.selectedElement = this.filteredElems.get(i);
            this.editor.updateGui();
            event.consume();
        } else if (event.keyCode == this.gui.getKeyCodes().KEY_ESCAPE) {
            this.close();
            event.consume();
        }
        super.keyPressed(event);
    }
}

