/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec3i;
import com.tom.cpl.math.Vec4f;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.elements.MultiSelector;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.tree.TreeElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class UVResizableArea {
    protected final Editor editor;
    protected final TreeElement parent;
    public final TreeElement.TreeSettingElement face;
    public final List<TreeElement.TreeSettingElement> elements;

    public UVResizableArea(Editor editor, TreeElement parent) {
        int i;
        this.editor = editor;
        this.parent = parent;
        this.face = this.face();
        this.elements = new ArrayList<TreeElement.TreeSettingElement>();
        for (i = 0; i < 4; ++i) {
            this.elements.add(new CornerArea(editor, parent, i));
        }
        for (i = 0; i < 4; ++i) {
            this.elements.add(new SideArea(editor, parent, i));
        }
        this.elements.add(this.face);
    }

    protected abstract Area getArea();

    protected abstract void setArea(Area var1, boolean var2);

    protected abstract void setAreaTemp(Area var1);

    protected FaceArea face() {
        return new FaceArea(this.editor, this.parent);
    }

    protected SideArea side(int i) {
        return new SideArea(this.editor, this.parent, i);
    }

    protected CornerArea corner(int i) {
        return new CornerArea(this.editor, this.parent, i);
    }

    public static Vec4f expandBox(Box b, float zoom) {
        if (b.w == 0 || b.h == 0) {
            float sx = b.x;
            float sy = b.y;
            float w = b.w;
            float h = b.h;
            float ex = 2.0f / zoom;
            if (b.w == 0) {
                sx -= ex;
                w = ex * 2.0f;
            }
            if (b.h == 0) {
                sy -= ex;
                h = ex * 2.0f;
            }
            if (b.w == 0 && b.h == 0) {
                sx -= ex;
                w = ex * 4.0f;
                sy -= ex;
                h = ex * 4.0f;
            }
            return new Vec4f(sx, sy, w, h);
        }
        return new Vec4f(b.x, b.y, b.w, b.h);
    }

    public static boolean isHovered(Box b, float x, float y, float zoom) {
        if (b == null) {
            return false;
        }
        if (b.w == 0 || b.h == 0) {
            Vec4f e = UVResizableArea.expandBox(b, zoom);
            return e.x <= x && e.y <= y && e.x + e.z > x && e.y + e.w > y;
        }
        return b.isInBounds((int)x, (int)y);
    }

    protected class FaceArea
    extends BaseArea {
        public FaceArea(Editor editor, TreeElement parent) {
            super(editor, parent);
        }

        @Override
        public Vec3f getVec(TreeElement.VecType type) {
            Area f = UVResizableArea.this.getArea();
            if (type == TreeElement.VecType.TEXTURE) {
                return new Vec3f(f.sx, f.sy, 1.0f);
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVec(Vec3f vec, TreeElement.VecType object) {
            if (object == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                int x = (int)vec.x - f.sx;
                int y = (int)vec.y - f.sy;
                f.sx += x;
                f.sy += y;
                f.ex += x;
                f.ey += y;
                UVResizableArea.this.setArea(f, true);
            }
        }

        @Override
        public void setVecTemp(TreeElement.VecType type, Vec3f vec) {
            if (type == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                int x = (int)vec.x - f.sx;
                int y = (int)vec.y - f.sy;
                f.sx += x;
                f.sy += y;
                f.ex += x;
                f.ey += y;
                UVResizableArea.this.setAreaTemp(f);
            }
        }

        @Override
        public Box getTextureBox() {
            Area f = UVResizableArea.this.getArea();
            int sx = Math.min(f.sx, f.ex);
            int sy = Math.min(f.sy, f.ey);
            int ex = Math.max(f.sx, f.ex);
            int ey = Math.max(f.sy, f.ey);
            return new Box(sx, sy, ex - sx, ey - sy);
        }

        @Override
        public void onClick(IGui gui, Editor e, MouseEvent evt) {
            if (gui.isCtrlDown()) {
                if (e.selectedElement instanceof MultiFaceArea) {
                    if (((MultiFaceArea)e.selectedElement).add(this)) {
                        e.selectedElement = null;
                    }
                } else if (e.selectedElement instanceof FaceArea || e.selectedElement instanceof ModelElement) {
                    MultiFaceArea ms = new MultiFaceArea(e);
                    if (e.selectedElement instanceof ModelElement) {
                        ModelElement me = (ModelElement)e.selectedElement;
                        TreeElement.TreeSettingElement f = me.faceUV.getFaceElement(me, me.editor.perfaceFaceDir.get());
                        if (f != null && f instanceof FaceArea) {
                            ms.add(f);
                        }
                    } else {
                        ms.add(e.selectedElement);
                    }
                    ms.add(this);
                    e.selectedElement = ms;
                } else if (e.selectedElement instanceof MultiSelector) {
                    MultiFaceArea ms = new MultiFaceArea(e);
                    ((MultiSelector)e.selectedElement).forEachSelected(ms::add);
                    ms.add(this);
                    e.selectedElement = ms;
                } else {
                    e.selectedElement = this;
                }
            } else {
                e.selectedElement = this;
            }
        }

        @Override
        protected int getColor() {
            return -6710887;
        }
    }

    protected class CornerArea
    extends BaseArea {
        private int corner;

        public CornerArea(Editor editor, TreeElement parent, int corner) {
            super(editor, parent);
            this.corner = corner;
        }

        @Override
        public Vec3f getVec(TreeElement.VecType type) {
            Area f = UVResizableArea.this.getArea();
            if (type == TreeElement.VecType.TEXTURE) {
                return new Vec3f(this.corner % 2 != 0 ? (float)f.ex : (float)f.sx, this.corner > 1 ? (float)f.ey : (float)f.sy, 1.0f);
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVec(Vec3f vec, TreeElement.VecType object) {
            if (object == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.corner % 2 != 0) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                if (this.corner > 1) {
                    f.ey = (int)vec.y;
                } else {
                    f.sy = (int)vec.y;
                }
                UVResizableArea.this.setArea(f, false);
            }
        }

        @Override
        public void setVecTemp(TreeElement.VecType type, Vec3f vec) {
            if (type == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.corner % 2 != 0) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                if (this.corner > 1) {
                    f.ey = (int)vec.y;
                } else {
                    f.sy = (int)vec.y;
                }
                UVResizableArea.this.setAreaTemp(f);
            }
        }

        @Override
        public Box getTextureBox() {
            Area f = UVResizableArea.this.getArea();
            return new Box(this.corner % 2 != 0 ? f.ex : f.sx, this.corner > 1 ? f.ey : f.sy, 0, 0);
        }

        @Override
        protected int getColor() {
            return -5592406;
        }
    }

    protected class SideArea
    extends BaseArea {
        private int side;

        public SideArea(Editor editor, TreeElement parent, int side) {
            super(editor, parent);
            this.side = side;
        }

        @Override
        public Vec3f getVec(TreeElement.VecType type) {
            Area f = UVResizableArea.this.getArea();
            if (type == TreeElement.VecType.TEXTURE) {
                return new Vec3f(this.side > 1 && this.side % 2 != 0 ? (float)f.ex : (float)f.sx, this.side > 1 && this.side % 2 == 0 ? (float)f.ey : (float)f.sy, 1.0f);
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVec(Vec3f vec, TreeElement.VecType object) {
            if (object == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.side % 2 == 0) {
                    if (this.side > 1) {
                        f.ey = (int)vec.y;
                    } else {
                        f.sy = (int)vec.y;
                    }
                } else if (this.side > 1) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                UVResizableArea.this.setArea(f, false);
            }
        }

        @Override
        public void setVecTemp(TreeElement.VecType type, Vec3f vec) {
            if (type == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.side % 2 == 0) {
                    if (this.side > 1) {
                        f.ey = (int)vec.y;
                    } else {
                        f.sy = (int)vec.y;
                    }
                } else if (this.side > 1) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                UVResizableArea.this.setAreaTemp(f);
            }
        }

        @Override
        public Box getTextureBox() {
            Area f = UVResizableArea.this.getArea();
            return new Box(this.side > 1 && this.side % 2 != 0 ? f.ex : f.sx, this.side > 1 && this.side % 2 == 0 ? f.ey : f.sy, this.side % 2 == 0 ? f.ex - f.sx : 0, this.side % 2 != 0 ? f.ey - f.sy : 0);
        }

        @Override
        protected int getColor() {
            return -10066330;
        }
    }

    public static class MultiFaceArea
    implements MultiSelector {
        private List<FaceArea> elements = new ArrayList<FaceArea>();
        private final Editor editor;

        public MultiFaceArea(Editor editor) {
            this.editor = editor;
        }

        private void addImpl(FaceArea faceArea) {
            if (this.elements.contains(faceArea)) {
                this.elements.remove(faceArea);
            } else {
                this.elements.add(faceArea);
            }
        }

        @Override
        public Vec3f getVec(TreeElement.VecType type) {
            if (type == TreeElement.VecType.TEXTURE) {
                return this.elements.stream().map(e -> e.getVec(TreeElement.VecType.TEXTURE)).reduce(new Vec3f(2.1474836E9f, 2.1474836E9f, 1.0f), (a, b) -> new Vec3f(Math.min(a.x, b.x), Math.min(a.y, b.y), 1.0f));
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVec(Vec3f v, TreeElement.VecType object) {
            if (object == TreeElement.VecType.TEXTURE) {
                Vec3f uv = this.getVec(TreeElement.VecType.TEXTURE);
                float uOff = v.x - uv.x;
                float vOff = v.y - uv.y;
                this.elements.forEach(e -> {
                    Vec3f ve = e.getVec(TreeElement.VecType.TEXTURE);
                    e.setVec(new Vec3f(ve.x + uOff, ve.y + vOff, 1.0f), TreeElement.VecType.TEXTURE);
                });
            }
        }

        @Override
        public void setVecTemp(TreeElement.VecType object, Vec3f v) {
            if (object == TreeElement.VecType.TEXTURE) {
                Vec3f uv = this.getVec(TreeElement.VecType.TEXTURE);
                float uOff = v.x - uv.x;
                float vOff = v.y - uv.y;
                this.elements.forEach(e -> {
                    Vec3f ve = e.getVec(TreeElement.VecType.TEXTURE);
                    e.setVecTemp(TreeElement.VecType.TEXTURE, new Vec3f(ve.x + uOff, ve.y + vOff, 1.0f));
                });
            }
        }

        @Override
        public boolean isSelected(Editor e, TreeElement other) {
            return this.elements.contains(other);
        }

        @Override
        public ETextures getTexture() {
            if (this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(0).getTexture();
        }

        @Override
        public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
            this.elements.forEach(e -> e.drawTexture(gui, x, y, xs, ys));
        }

        @Override
        public boolean add(TreeElement modelElement) {
            if (modelElement instanceof FaceArea) {
                this.addImpl((FaceArea)modelElement);
            } else if (modelElement instanceof ModelElement) {
                ModelElement me = (ModelElement)modelElement;
                if (me.faceUV != null) {
                    me.faceUV.getFaceElements(me).forEach(f -> {
                        if (f instanceof FaceArea) {
                            this.addImpl((FaceArea)f);
                        }
                    });
                }
            }
            return this.elements.isEmpty();
        }

        @Override
        public void forEachSelected(Consumer<TreeElement> c) {
            this.elements.forEach(c);
        }

        @Override
        public void updateGui() {
            this.editor.setModePanel.accept(ModeDisplayType.TEX);
            Vec3f v = this.getVec(TreeElement.VecType.TEXTURE);
            this.editor.setTexturePanel.accept(new Vec3i((int)v.x, (int)v.y, 1));
        }

        @Override
        public Box getTextureBox() {
            return this.elements.stream().map(TreeElement::getTextureBox).filter(e -> e != null).reduce(null, (a, b) -> a == null ? b : (b == null ? a : a.union((Box)b)));
        }
    }

    private abstract class BaseArea
    implements TreeElement.TreeSettingElement {
        protected final Editor editor;
        protected final TreeElement parent;

        public BaseArea(Editor editor, TreeElement parent) {
            this.editor = editor;
            this.parent = parent;
        }

        @Override
        public TreeElement getParent() {
            return this.parent;
        }

        @Override
        public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
            if (this.editor.selectedElement == this) {
                TreeElement.TreeSettingElement.super.drawTexture(gui, x, y, xs, ys);
            }
            Box b = this.getTextureBox();
            Vec4f v = UVResizableArea.expandBox(b, xs);
            gui.drawRectangle((float)x + v.x * xs, (float)y + v.y * ys, v.z * xs, v.w * ys, this.getColor());
        }

        protected abstract int getColor();
    }

    public static class Area {
        public int sx;
        public int sy;
        public int ex;
        public int ey;

        public Area(int sx, int sy, int ex, int ey) {
            this.sx = sx;
            this.sy = sy;
            this.ex = ex;
            this.ey = ey;
        }
    }
}

