/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.effects;

import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.effects.IRenderEffect;
import com.tom.cpm.shared.effects.RenderEffects;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.CopyTransform;
import com.tom.cpm.shared.model.RenderedCube;
import java.io.IOException;

public class EffectCopyTransform
implements IRenderEffect {
    private int from;
    private int to;
    private short copy;

    public EffectCopyTransform() {
    }

    public EffectCopyTransform(int from, int to, short copy) {
        this.from = from;
        this.to = to;
        this.copy = copy;
    }

    @Override
    public void load(IOHelper in) throws IOException {
        this.from = in.readVarInt();
        this.to = in.readVarInt();
        this.copy = (short)in.readVarInt();
    }

    @Override
    public void write(IOHelper out) throws IOException {
        out.writeVarInt(this.from);
        out.writeVarInt(this.to);
        out.writeVarInt(this.copy);
    }

    @Override
    public void apply(ModelDefinition def) {
        RenderedCube from = def.getElementById(this.from);
        RenderedCube to = def.getElementById(this.to);
        if (from != null && to != null) {
            def.getAnimations().addCopy(new CopyTransform(from, to, this.copy));
        }
    }

    @Override
    public RenderEffects getEffect() {
        return RenderEffects.COPY_TRANSFORM;
    }
}

