/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ComboSlider;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.NamedElement;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.Gesture;
import com.tom.cpm.shared.animation.IManualGesture;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.definition.ModelDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class PropertiesPopup
extends PopupPanel {
    private ConfigEntry prop;
    private ConfigEntry current;
    private final ModelDefinition def;
    private List<Runnable> updateState;

    public PropertiesPopup(IGui gui, int h, ModelDefinition def) {
        super(gui);
        Profile sel;
        List ps;
        this.def = def;
        this.updateState = new ArrayList<Runnable>();
        if (def.getAnimations().getProfileId() != null) {
            this.prop = ModConfig.getCommonConfig().getEntry("modelProperties").getEntry(def.getAnimations().getProfileId());
            ps = this.prop.getEntry("profiles").keySet().stream().map(x$0 -> new Profile((String)x$0)).collect(Collectors.toList());
            ps.add(new Profile(null));
            this.current = this.prop.getEntry("values");
            String s = this.prop.getString("selected", null);
            sel = s == null ? null : (Profile)ps.stream().filter(p -> s.equals(p.name)).findFirst().orElse(null);
        } else {
            ps = Collections.emptyList();
            sel = null;
        }
        DropDownBox<Profile> profileBox = new DropDownBox<Profile>(gui.getFrame(), ps);
        profileBox.setBounds(new Box(5, 5, 160, 20));
        if (sel != null) {
            profileBox.setSelected(sel);
        }
        this.addElement(profileBox);
        Button save = new Button(gui, gui.i18nFormat("button.cpm.file.save", new Object[0]), () -> {
            Profile p = (Profile)profileBox.getSelected();
            if (p != null) {
                if (p.name == null) {
                    new InputPopup(gui.getFrame(), gui.i18nFormat("label.cpm.name", new Object[0]), n -> {
                        if (this.prop.getEntry("profiles").hasEntry((String)n)) {
                            ConfirmPopup.confirm(gui.getFrame(), gui.i18nFormat("label.cpm.overwriteProfile", new Object[0]), () -> this.saveProfile((String)n));
                        } else {
                            this.saveProfile((String)n);
                        }
                    }, null).run();
                } else {
                    ConfirmPopup.confirm(gui.getFrame(), gui.i18nFormat("label.cpm.overwriteProfile", new Object[0]), () -> this.saveProfile(p.name));
                }
            }
        });
        save.setBounds(new Box(5, 30, 50, 20));
        this.addElement(save);
        Button load = new Button(gui, gui.i18nFormat("button.cpm.file.load", new Object[0]), () -> {
            Profile p = (Profile)profileBox.getSelected();
            if (p != null && p.name != null) {
                ConfirmPopup.confirm(gui.getFrame(), gui.i18nFormat("label.cpm.loadProfile", p.name), () -> this.loadProfile(p.name));
            }
        });
        load.setBounds(new Box(60, 30, 50, 20));
        this.addElement(load);
        Button del = new Button(gui, gui.i18nFormat("button.cpm.delete", new Object[0]), ConfirmPopup.confirmHandler(gui.getFrame(), gui.i18nFormat("label.cpm.confirmDel", new Object[0]), () -> {
            Profile p = (Profile)profileBox.getSelected();
            if (p != null && p.name != null) {
                ps.remove(p);
                this.prop.getEntry("profiles").clearValue(p.name);
                profileBox.setSelected(null);
            }
        }));
        del.setBounds(new Box(115, 30, 50, 20));
        this.addElement(del);
        ScrollPanel scp = new ScrollPanel(gui);
        scp.setBounds(new Box(5, 55, 160, h - 60));
        this.addElement(scp);
        Panel panel = new Panel(gui);
        FlowLayout layout = new FlowLayout(panel, 5, 1);
        scp.setDisplay(panel);
        panel.setBounds(new Box(0, 0, 160, 0));
        HashMap groups = new HashMap();
        def.getAnimations().getGestures().values().stream().filter(Gesture::isProperty).sorted(Comparator.comparingInt(IManualGesture::getOrder)).forEach(g -> {
            if (g.type == AnimationType.LAYER) {
                if (g.group != null) {
                    groups.computeIfAbsent(g.group, k -> new Group((String)k, panel)).add((Gesture)g);
                    return;
                }
                Checkbox chbx = new Checkbox(gui, g.name);
                chbx.setBounds(new Box(5, 0, 150, 20));
                chbx.setAction(() -> {
                    chbx.setSelected(!chbx.isSelected());
                    this.setToggleGesture((Gesture)g, chbx.isSelected());
                });
                this.updateState.add(() -> chbx.setSelected(MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getGestureValue(def.getAnimations(), (Gesture)g) != 0));
                panel.addElement(chbx);
            } else if (g.type == AnimationType.VALUE_LAYER) {
                String nm = g.getName();
                ComboSlider s = new ComboSlider(gui, a -> nm, a -> a * 100.0f, a -> a / 100.0f);
                s.setBounds(new Box(5, 0, 150, 20));
                s.getSpinner().setDp(0);
                s.setAction(() -> {
                    MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().setLayerValue(def.getAnimations(), (Gesture)g, s.getValue());
                    this.current.setFloat(g.name, s.getValue());
                });
                this.updateState.add(() -> s.setValue((float)Byte.toUnsignedInt(MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getGestureValue(def.getAnimations(), (Gesture)g)) / 255.0f));
                panel.addElement(s);
            }
        });
        if (panel.getElements().isEmpty()) {
            panel.addElement(new Label(gui, gui.i18nFormat("label.cpm.nothing_here", new Object[0])).setBounds(new Box(5, 5, 100, 10)));
        } else {
            this.updateState.forEach(Runnable::run);
        }
        if (panel.getElements().isEmpty() || def.getAnimations().getProfileId() == null) {
            profileBox.setEnabled(false);
            save.setEnabled(false);
            load.setEnabled(false);
            del.setEnabled(false);
        }
        layout.reflow();
        this.setBounds(new Box(0, 0, 170, h));
    }

    private void saveProfile(String name) {
        ConfigEntry ce = this.prop.getEntry("profiles").getEntry(name);
        ce.clear();
        this.current.keySet().stream().map(k -> Pair.of(k, Float.valueOf(this.current.getFloat((String)k, 0.0f)))).forEach(p -> ce.setFloat((String)p.getKey(), ((Float)p.getValue()).floatValue()));
        this.prop.setString("selected", name);
        ModConfig.getCommonConfig().save();
    }

    private void loadProfile(String name) {
        ConfigEntry ce = this.prop.getEntry("profiles").getEntry(name);
        this.current.clear();
        ce.keySet().stream().map(k -> Pair.of(k, Float.valueOf(ce.getFloat((String)k, 0.0f)))).forEach(p -> this.current.setFloat((String)p.getKey(), ((Float)p.getValue()).floatValue()));
        this.prop.setString("selected", name);
        ModConfig.getCommonConfig().save();
        this.def.getAnimations().getGestures().values().stream().filter(Gesture::isProperty).sorted(Comparator.comparingInt(IManualGesture::getOrder)).forEach(g -> MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().setLayerValue(this.def.getAnimations(), (Gesture)g, this.current.getFloat(g.name, (float)g.defVal / 255.0f)));
        this.updateState.forEach(Runnable::run);
    }

    private void setToggleGesture(Gesture g, boolean v) {
        MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().setLayerValue(this.def.getAnimations(), g, v ? 1.0f : 0.0f);
        this.current.setFloat(g.name, v ? 1.0f : 0.0f);
    }

    @Override
    public void onClosed() {
        ModConfig.getCommonConfig().save();
        super.onClosed();
    }

    private class Profile
    implements Comparable<Profile> {
        private String name;

        public Profile(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name != null ? this.name : PropertiesPopup.this.gui.i18nFormat("label.cpm.new_profile", new Object[0]);
        }

        @Override
        public int compareTo(Profile o) {
            if (o.name == this.name) {
                return 0;
            }
            if (this.name == null && o.name != null) {
                return -1;
            }
            if (o.name == null && this.name != null) {
                return 1;
            }
            return this.name.compareTo(o.name);
        }
    }

    private class Group {
        private NamedElement.NameMapper<Gesture> groupGestures;
        private List<Gesture> list = new ArrayList<Gesture>();
        private DropDownBox<NamedElement<Gesture>> box;

        public Group(String name, Panel panel) {
            this.groupGestures = new NamedElement.NameMapper<Gesture>(this.list, g -> g == null ? PropertiesPopup.this.gui.i18nFormat("label.cpm.layerNone", new Object[0]) : g.name);
            this.box = new DropDownBox<NamedElement<Gesture>>(PropertiesPopup.this.gui.getFrame(), this.groupGestures.asList());
            this.groupGestures.setSetter(this.box::setSelected);
            Panel p = new Panel(PropertiesPopup.this.gui);
            p.setBounds(new Box(5, 0, 150, 20));
            panel.addElement(p);
            p.addElement(new Label(PropertiesPopup.this.gui, name).setBounds(new Box(0, 12, 70, 10)));
            p.addElement(this.box);
            this.box.setBounds(new Box(70, 0, 80, 20));
            this.box.setAction(() -> {
                Gesture s = this.box.getSelected().getElem();
                this.list.forEach(g -> PropertiesPopup.this.setToggleGesture((Gesture)g, g == s));
            });
            PropertiesPopup.this.updateState.add(this::update);
        }

        public void add(Gesture g) {
            this.list.add(g);
        }

        public void update() {
            this.groupGestures.refreshValues();
            Gesture s = this.list.stream().filter(g -> MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getGestureValue(PropertiesPopup.this.def.getAnimations(), (Gesture)g) != 0).findFirst().orElse(null);
            this.groupGestures.setValue(s);
        }
    }
}

