/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ViewportPanelBase3d;

public class ModelDisplayPanel
extends ViewportPanelBase3d {
    private IModelDisplayPanel skins;
    private String loadingText;

    public ModelDisplayPanel(Frame frm, IModelDisplayPanel skins) {
        super(frm);
        this.skins = skins;
    }

    @Override
    public void render(MatrixStack stack, VBuffers buf, float partialTicks) {
        this.renderModel(stack, buf, partialTicks);
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        Box bounds = this.getBounds();
        if (this.backgroundColor != 0) {
            this.gui.drawBox(bounds.x - 1, bounds.y - 1, bounds.w + 2, bounds.h + 2, -16777216);
            this.gui.drawBox(bounds.x, bounds.y, bounds.w, bounds.h, this.backgroundColor);
        }
        if (!this.skins.doRender()) {
            return;
        }
        if (this.skins.getSelectedDefinition() == null) {
            this.gui.drawText(bounds.x + bounds.w / 2 - this.gui.textWidth(this.loadingText) / 2, bounds.y + bounds.h / 2 - 4, this.loadingText, this.gui.getColors().label_text_color);
        } else {
            super.draw(event, partialTicks);
        }
    }

    @Override
    public ViewportCamera getCamera() {
        return this.skins.getCamera();
    }

    @Override
    public void preRender(MatrixStack stack, VBuffers buf) {
        this.skins.preRender();
    }

    @Override
    public ModelDefinition getDefinition() {
        return this.skins.getSelectedDefinition();
    }

    public void setLoadingText(String loadingText) {
        this.loadingText = loadingText;
    }

    public static interface IModelDisplayPanel {
        public ModelDefinition getSelectedDefinition();

        public ViewportCamera getCamera();

        public void preRender();

        public boolean doRender();
    }
}

