/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ChecksumInputStream
extends InputStream {
    private InputStream is;
    private short sum;

    public ChecksumInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        int v = this.is.read();
        if (v != -1) {
            this.sum = (short)(this.sum + v);
        }
        return v;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rd = this.is.read(b, off, len);
        for (int i = 0; i < rd; ++i) {
            this.sum = (short)(this.sum + Byte.toUnsignedInt(b[off + i]));
        }
        return rd;
    }

    public short getSum() {
        return this.sum;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public void checkSum() throws IOException {
        int ch2;
        int ch1 = this.is.read();
        if ((ch1 | (ch2 = this.is.read())) < 0) {
            throw new EOFException();
        }
        short sum = (short)((ch1 << 8) + (ch2 << 0));
        if (this.getSum() != sum) {
            throw new IOException("Sum error: expected: " + sum + " actual: " + this.getSum());
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
        this.sum = 0;
    }
}

