/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model;

import com.tom.cpl.math.BoundingBox;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.PartRoot;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.render.VanillaModelPart;

public class RootModelElement
extends RenderedCube {
    private VanillaModelPart part;
    public Vec3f posN;
    public Vec3f rotN;
    public Vec3f defPos;
    public Vec3f defRot;
    private ModelDefinition def;
    private boolean rotAdd;
    private boolean posAdd;
    public boolean disableVanilla;

    public RootModelElement(VanillaModelPart part, ModelDefinition def) {
        this.part = part;
        this.posN = new Vec3f();
        this.rotN = new Vec3f();
        this.pos = new Vec3f();
        this.rotation = new Vec3f();
        this.defPos = new Vec3f();
        this.defRot = new Vec3f();
        this.def = def;
    }

    public VanillaModelPart getPart() {
        return this.part;
    }

    @Override
    public void reset() {
        this.pos = new Vec3f();
        this.rotation = new Vec3f();
        this.renderScale = new Vec3f(1.0f, 1.0f, 1.0f);
        this.display = !this.hidden;
        this.posAdd = true;
        this.rotAdd = true;
    }

    @Override
    public void setColor(float x, float y, float z) {
    }

    @Override
    public void setVisible(boolean v) {
    }

    @Override
    public int getId() {
        return this.part.getId(this);
    }

    @Override
    public BoundingBox getBounds() {
        PartValues v = this.part.getDefaultSize(this.def.getSkinType());
        float f = 0.001f;
        float g = f * 2.0f;
        float scale = 0.0625f;
        Vec3f offset = v.getOffset();
        Vec3f size = v.getSize();
        return BoundingBox.create(offset.x * scale - f, offset.y * scale - f, offset.z * scale - f, size.x * scale + g, size.y * scale + g, size.z * scale + g);
    }

    public void setPosAndRot(float px, float py, float pz, float rx, float ry, float rz) {
        if (!this.disableVanilla) {
            this.defPos.x = px + this.posN.x;
            this.defPos.y = py + this.posN.y;
            this.defPos.z = pz + this.posN.z;
            this.defRot.x = rx + this.rotN.x;
            this.defRot.y = ry + this.rotN.y;
            this.defRot.z = rz + this.rotN.z;
        } else {
            PartValues v = this.part.getDefaultSize(this.def.getSkinType());
            Vec3f p = v.getPos();
            this.defPos.x = p.x + this.posN.x;
            this.defPos.y = p.y + this.posN.y;
            this.defPos.z = p.z + this.posN.z;
            this.defRot.x = this.rotN.x;
            this.defRot.y = this.rotN.y;
            this.defRot.z = this.rotN.z;
        }
    }

    public void setPosAndRot(PartRoot cpy) {
        if (!this.disableVanilla) {
            RootModelElement e = cpy.getMainRoot();
            this.defPos.x = e.defPos.x - e.posN.x + this.posN.x;
            this.defPos.y = e.defPos.y - e.posN.y + this.posN.y;
            this.defPos.z = e.defPos.z - e.posN.z + this.posN.z;
            this.defRot.x = e.defRot.x - e.rotN.x + this.rotN.x;
            this.defRot.y = e.defRot.y - e.rotN.y + this.rotN.y;
            this.defRot.z = e.defRot.z - e.rotN.z + this.rotN.z;
        } else {
            PartValues v = this.part.getDefaultSize(this.def.getSkinType());
            Vec3f p = v.getPos();
            this.defPos.x = p.x + this.posN.x;
            this.defPos.y = p.y + this.posN.y;
            this.defPos.z = p.z + this.posN.z;
            this.defRot.x = this.rotN.x;
            this.defRot.y = this.rotN.y;
            this.defRot.z = this.rotN.z;
        }
    }

    @Override
    public void setPosition(boolean add, float x, float y, float z) {
        super.setPosition(add, x, y, z);
        this.posAdd &= add;
    }

    @Override
    public void setRotation(boolean add, float x, float y, float z) {
        super.setRotation(add, x, y, z);
        this.rotAdd &= add;
    }

    public Vec3f getPos() {
        if (this.posAdd) {
            return this.pos.add(this.defPos);
        }
        return this.pos;
    }

    public Vec3f getRot() {
        if (this.rotAdd) {
            return this.rotation.add(this.defRot);
        }
        return this.rotation;
    }

    public boolean renderPart() {
        return true;
    }

    @Override
    public Vec3f getRenderScale() {
        return new Vec3f(1.0f, 1.0f, 1.0f);
    }

    @Override
    public Vec3f getTransformPosition() {
        return this.getPos();
    }

    @Override
    public Vec3f getTransformRotation() {
        return this.getRot();
    }
}

