/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.template.args;

import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.template.args.ArgBase;
import java.io.EOFException;
import java.io.IOException;

public class ColorArg
extends ArgBase {
    private int color;

    public ColorArg() {
    }

    public ColorArg(String name, int color) {
        super(name);
        this.color = color;
    }

    @Override
    public String getType() {
        return "color";
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        dout.write(this.color >>> 16 & 0xFF);
        dout.write(this.color >>> 8 & 0xFF);
        dout.write(this.color >>> 0 & 0xFF);
    }

    @Override
    public void load(IOHelper din) throws IOException {
        int ch4;
        int ch3;
        int ch2 = din.read();
        if ((ch2 | (ch3 = din.read()) | (ch4 = din.read())) < 0) {
            throw new EOFException();
        }
        this.color = -16777216 + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    public Object toJson() {
        return Integer.toHexString(this.color);
    }

    @Override
    public void fromJson(Object v) {
        this.color = Integer.parseUnsignedInt((String)v, 16);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int value) {
        this.color = value;
    }
}

