/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.apace100.calio.data.MultiJsonDataLoader;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.integration.OriginDataLoadedCallback;
import io.github.apace100.origins.origin.OriginLayer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class OriginLayers
extends MultiJsonDataLoader
implements IdentifiableResourceReloadListener {
    private static final HashMap<class_2960, OriginLayer> layers = new HashMap();
    private static int minLayerPriority = Integer.MIN_VALUE;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public OriginLayers() {
        super(GSON, "origin_layers");
    }

    protected void apply(Map<class_2960, List<JsonElement>> loader, class_3300 manager, class_3695 profiler) {
        OriginLayers.clear();
        HashMap layers = new HashMap();
        loader.forEach((id, jel) -> {
            minLayerPriority = Integer.MIN_VALUE;
            jel.forEach(je -> {
                try {
                    Origins.LOGGER.info("Trying to read layer file: " + id);
                    JsonObject jo = je.getAsJsonObject();
                    boolean replace = class_3518.method_15258((JsonObject)jo, (String)"replace", (boolean)false);
                    int priority = class_3518.method_15282((JsonObject)jo, (String)"loading_priority", (int)0);
                    if (priority >= minLayerPriority) {
                        HashMap inner = layers.computeIfAbsent(id, ident -> new HashMap());
                        List layerList = inner.computeIfAbsent(priority, prio -> new LinkedList());
                        if (replace) {
                            layerList.clear();
                            minLayerPriority = priority + 1;
                        }
                        layerList.add(jo);
                    }
                }
                catch (Exception e) {
                    Origins.LOGGER.error("There was a problem reading Origin layer file " + id.toString() + " (skipping): " + e.getMessage());
                }
            });
        });
        for (Map.Entry layerToLoad : layers.entrySet()) {
            class_2960 layerId = (class_2960)layerToLoad.getKey();
            List keys = ((HashMap)layerToLoad.getValue()).keySet().stream().sorted().collect(Collectors.toList());
            OriginLayer layer = null;
            for (Integer key : keys) {
                for (JsonObject jo : (List)((HashMap)layerToLoad.getValue()).get(key)) {
                    if (layer == null) {
                        layer = OriginLayer.fromJson(layerId, jo);
                        continue;
                    }
                    layer.merge(jo);
                }
            }
            OriginLayers.layers.put(layerId, layer);
        }
        Origins.LOGGER.info("Finished loading origin layers from data files. Read " + layers.size() + " layers.");
        ((OriginDataLoadedCallback)OriginDataLoadedCallback.EVENT.invoker()).onDataLoaded(false);
    }

    public static OriginLayer getLayer(class_2960 id) {
        if (!layers.containsKey(id)) {
            throw new IllegalArgumentException("Could not get layer from id '" + id.toString() + "', as it doesn't exist!");
        }
        return layers.get(id);
    }

    public static Collection<OriginLayer> getLayers() {
        return layers.values();
    }

    public static int size() {
        return layers.size();
    }

    public static void clear() {
        layers.clear();
    }

    public static void add(OriginLayer layer) {
        layers.put(layer.getIdentifier(), layer);
    }

    public class_2960 getFabricId() {
        return new class_2960("origins", "origin_layers");
    }

    public Collection<class_2960> getFabricDependencies() {
        return Set.of(Origins.identifier("origins"));
    }
}

