/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.inventory;

import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2481;
import net.minecraft.class_2491;
import net.minecraft.class_2497;
import net.minecraft.class_310;
import net.minecraft.class_437;
import team.creative.creativecore.CreativeCoreGuiRegistry;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlotBase;
import team.creative.creativecore.common.gui.controls.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.manager.GuiManagerItem;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiSlot
extends GuiSlotBase {
    public final class_1735 slot;
    public int draggedIndex = -1;

    public GuiSlot(class_1263 container, int index) {
        this("", container, index);
    }

    public GuiSlot(String name, class_1263 container, int index) {
        this(name + index, new class_1735(container, index, 0, 0));
    }

    public GuiSlot(class_1735 slot) {
        this("" + slot.method_34266(), slot);
    }

    public GuiSlot(String name, class_1735 slot) {
        super(name);
        this.slot = slot;
    }

    @Override
    public class_1799 getStack() {
        return this.slot.method_7677();
    }

    @Override
    protected class_1799 getStackToRender() {
        if (this.draggedIndex != -1) {
            class_1799 stack = this.itemManager().getHand().method_7972();
            int toAdd = Math.min(this.itemManager().additionalDragCount(this.draggedIndex), this.slot.method_7676(stack) - this.slot.method_7677().method_7947());
            stack.method_7939(toAdd + this.slot.method_7677().method_7947());
            return stack;
        }
        return this.getStack();
    }

    public GuiManagerItem itemManager() {
        return this.getLayer().itemManager();
    }

    public IGuiInventory inventory() {
        IGuiParent parent = this.getParent();
        while (!(parent instanceof IGuiInventory)) {
            if (parent instanceof GuiParent) {
                parent = ((GuiParent)parent).getParent();
                continue;
            }
            throw new RuntimeException("Slot needs inventory parent");
        }
        return (IGuiInventory)((Object)parent);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (class_310.method_1551().field_1690.field_1869.method_1417(keyCode, scanCode)) {
            CreativeCoreGuiRegistry.DROP.sendAndExecute(this, class_2481.method_23234((boolean)class_437.method_25441()));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean mouseScrolled(Rect rect, double x, double y, double delta) {
        if (!class_437.method_25442()) {
            return false;
        }
        if (delta > 0.0) {
            CreativeCoreGuiRegistry.INSERT.sendAndExecute(this, class_2497.method_23247((int)((int)delta)));
        } else {
            CreativeCoreGuiRegistry.EXTRACT.sendAndExecute(this, class_2497.method_23247((int)((int)delta)));
        }
        return true;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (this.itemManager().isDragged()) {
            return true;
        }
        if (class_437.method_25442()) {
            if (this.slot.method_7674(this.getPlayer())) {
                CreativeCoreGuiRegistry.INSERT.sendAndExecute(this, class_2497.method_23247((int)this.slot.method_7675()));
            }
            return true;
        }
        class_1799 hand = this.itemManager().getHand();
        if (!hand.method_7960() && button < 2) {
            int stackSize = GuiManagerItem.freeSpace(this.slot, hand);
            if (stackSize > 0) {
                this.itemManager().startDrag(this, button == 1, stackSize);
            }
            if (stackSize != -1) {
                return true;
            }
        }
        if (button == 2) {
            CreativeCoreGuiRegistry.DUPLICATE.sendAndExecute(this, class_2491.field_21033);
        } else if (this.slot.method_7674(this.getPlayer()) && (hand.method_7960() || this.slot.method_7680(hand))) {
            CreativeCoreGuiRegistry.SWAP.sendAndExecute(this, class_2481.method_23234((button == 1 ? 1 : 0) != 0));
        }
        return true;
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        if (this.draggedIndex == -1 && this.itemManager().isDragged() && rect.inside(x + rect.minX, y + rect.minY)) {
            this.itemManager().addToDrag(this);
        }
    }

    public void changed() {
        this.inventory().setChanged(this.slot.method_34266());
        if (this.draggedIndex != -1) {
            this.itemManager().modifyDrag(this);
        }
    }

    public class_1799 insert(class_1799 stack) {
        boolean canStack = class_1703.method_7592((class_1735)this.slot, (class_1799)stack, (boolean)true);
        int availableStackSize = this.slot.method_7676(stack);
        if (canStack && this.slot.method_7680(stack)) {
            int additionalStackSize;
            int neededStackSize = stack.method_7947();
            if (this.slot.method_7681()) {
                availableStackSize -= this.slot.method_7677().method_7947();
            }
            if ((additionalStackSize = Math.min(availableStackSize, neededStackSize)) > 0) {
                class_1799 inSlot = stack.method_7972();
                inSlot.method_7939(additionalStackSize);
                if (this.slot.method_7681()) {
                    inSlot.method_7933(this.slot.method_7677().method_7947());
                }
                this.slot.method_7673(inSlot);
                stack.method_7934(additionalStackSize);
                this.changed();
            }
        }
        return stack;
    }
}

