/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.ITextCollection;
import team.creative.creativecore.common.util.text.TextListBuilder;

public class GuiStateButton
extends GuiButton {
    private int index = 0;
    public CompiledText[] states;

    public GuiStateButton(String name, ITextCollection states) {
        this(name, 0, states);
    }

    public GuiStateButton(String name, int index, ITextCollection states) {
        super(name, null);
        this.pressed = button -> {
            if (button == 1) {
                this.previousState();
            } else {
                this.nextState();
            }
        };
        this.index = index;
        this.buildStates(states);
    }

    public GuiStateButton(String name, int index, String ... states) {
        this(name, index, new TextListBuilder().add(states));
    }

    protected void buildStates(ITextCollection builder) {
        this.states = builder.build();
        if (this.index >= this.states.length) {
            this.index = 0;
        }
    }

    @Override
    public void flowX(int width, int preferred) {
        for (CompiledText text : this.states) {
            text.setDimension(width, Integer.MAX_VALUE);
        }
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        for (CompiledText text : this.states) {
            text.setMaxHeight(height);
        }
    }

    @Override
    public int preferredWidth(int availableWidth) {
        int width = 0;
        for (CompiledText text : this.states) {
            width = Math.max(width, text.getTotalWidth());
        }
        return width;
    }

    @Override
    public int preferredHeight(int width, int availableHeight) {
        int height = 0;
        for (CompiledText text : this.states) {
            height = Math.max(height, text.getTotalHeight());
        }
        return height;
    }

    public void setState(int index) {
        this.index = index;
    }

    public int getState() {
        return this.index;
    }

    public void previousState() {
        int state = this.getState();
        if (--state < 0) {
            state = this.states.length - 1;
        }
        if (state >= this.states.length) {
            state = 0;
        }
        this.setState(state);
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    public void nextState() {
        int state = this.getState();
        if (++state < 0) {
            state = this.states.length - 1;
        }
        if (state >= this.states.length) {
            state = 0;
        }
        this.setState(state);
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void renderContent(class_332 graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        CompiledText text = this.states[this.index];
        class_4587 pose = graphics.method_51448();
        pose.method_22904(rect.getWidth() / 2.0 - (double)(text.getUsedWidth() / 2), rect.getHeight() / 2.0 - (double)(text.getUsedHeight() / 2), 0.0);
        text.render(pose);
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.CLICKABLE;
    }
}

