/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.server.condition.BlownUpByCreeperLootCondition;
import fzzyhmstrs.emi_loot.server.condition.KilledByWitherLootCondition;
import fzzyhmstrs.emi_loot.server.condition.MobSpawnedWithLootCondition;
import fzzyhmstrs.emi_loot.server.function.OminousBannerLootFunction;
import fzzyhmstrs.emi_loot.server.function.SetAnyDamageLootFunction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_131;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_217;
import net.minecraft.class_5335;
import net.minecraft.class_5339;
import net.minecraft.class_5342;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMILoot
implements ModInitializer {
    public static String MOD_ID = "emi_loot";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"emi_loot");
    public static class_5819 emiLootRandom = new class_6575(System.currentTimeMillis());
    public static LootTableParser parser = new LootTableParser();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static EmiLootConfig config = EMILoot.readOrCreate();
    public static boolean DEBUG = EMILoot.config.debugMode;
    public static class_5342 WITHER_KILL = class_217.method_29327((String)"lootify:wither_kill", (class_5335)new KilledByWitherLootCondition.Serializer());
    public static class_5342 SPAWNS_WITH = class_217.method_29327((String)"lootify:spawns_with", (class_5335)new MobSpawnedWithLootCondition.Serializer());
    public static class_5342 CREEPER = class_217.method_29327((String)"lootify:creeper", (class_5335)new BlownUpByCreeperLootCondition.Serializer());
    public static class_5339 SET_ANY_DAMAGE = class_131.method_29323((String)"lootify:set_any_damage", (class_5335)new SetAnyDamageLootFunction.Serializer());
    public static class_5339 OMINOUS_BANNER = class_131.method_29323((String)"lootify:ominous_banner", (class_5335)new OminousBannerLootFunction.Serializer());
    public static class_1887 RANDOM = new class_1887(class_1887.class_1888.field_9091, class_1886.field_9073, class_1304.values()){

        public boolean method_25949() {
            return false;
        }

        public boolean method_25950() {
            return false;
        }
    };

    public void onInitialize() {
        parser.registerServer();
    }

    private static EmiLootConfig readOrCreate() {
        File dir = FabricLoader.getInstance().getConfigDir().toFile();
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.error("EMI Loot could not find or create config directory, using default configs");
            return new EmiLootConfig();
        }
        String f_old_name = "EmiLootConfig.json";
        String f_name = "EmiLootConfig_v1.json";
        File f_old = new File(dir, f_old_name);
        try {
            if (f_old.exists()) {
                EmiLootConfigOld oldConfig = (EmiLootConfigOld)gson.fromJson((Reader)new InputStreamReader(new FileInputStream(f_old)), EmiLootConfigOld.class);
                EmiLootConfig newConfig = oldConfig.generateNewConfig();
                File f = new File(dir, f_name);
                if (f.exists()) {
                    f_old.delete();
                    return (EmiLootConfig)gson.fromJson((Reader)new InputStreamReader(new FileInputStream(f)), EmiLootConfig.class);
                }
                if (!f.createNewFile()) {
                    LOGGER.error("Failed to create new config file, using old config with new defaults.");
                } else {
                    f_old.delete();
                    FileWriter fw = new FileWriter(f);
                    String json = gson.toJson((Object)newConfig);
                    if (DEBUG) {
                        LOGGER.info(json);
                    }
                    fw.write(json);
                    fw.close();
                }
                return newConfig;
            }
            File f = new File(dir, f_name);
            if (f.exists()) {
                return (EmiLootConfig)gson.fromJson((Reader)new InputStreamReader(new FileInputStream(f)), EmiLootConfig.class);
            }
            if (!f.createNewFile()) {
                throw new UnsupportedOperationException("couldn't generate config file");
            }
            FileWriter fw = new FileWriter(f);
            EmiLootConfig emc = new EmiLootConfig();
            String json = gson.toJson((Object)emc);
            if (DEBUG) {
                LOGGER.info(json);
            }
            fw.write(json);
            fw.close();
            return emc;
        }
        catch (Exception e) {
            LOGGER.error("Emi Loot failed to create or read it's config file!");
            LOGGER.error(Arrays.toString(e.getStackTrace()));
            return new EmiLootConfig();
        }
    }

    public static class EmiLootConfig {
        public boolean debugMode = false;
        public boolean parseChestLoot = true;
        public boolean parseBlockLoot = true;
        public boolean parseMobLoot = true;
        public boolean parseGameplayLoot = true;
        public boolean chestLootCompact = true;
        public boolean chestLootAlwaysStackSame = false;
        public boolean mobLootIncludeDirectDrops = true;
        public boolean parseArchaeologyLoot = true;
    }

    public static class EmiLootConfigOld {
        public boolean parseChestLoot = true;
        public boolean parseBlockLoot = true;
        public boolean parseMobLoot = true;
        public boolean parseGameplayLoot = true;

        public EmiLootConfig generateNewConfig() {
            EmiLootConfig newConfig = new EmiLootConfig();
            newConfig.parseChestLoot = this.parseChestLoot;
            newConfig.parseBlockLoot = this.parseBlockLoot;
            newConfig.parseMobLoot = this.parseMobLoot;
            newConfig.parseGameplayLoot = this.parseGameplayLoot;
            return newConfig;
        }
    }
}

