/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.InputBaseProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.model.ModelProcessSubProviderWrapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelProcessProviderWrapper
extends InputBaseProviderWrapper {
    private static final Gson GSON = new Gson();
    private final List<ModelProcessSubProviderWrapper> subProviderWrappers;

    public ModelProcessProviderWrapper(class_7784 packOutput, CrossDataGeneratorAccess crossDataGeneratorAccess, List<ModelProcessSubProviderWrapper> subProviderWrappers) {
        super(packOutput, class_7784.class_7490.field_39368, "models", crossDataGeneratorAccess);
        this.subProviderWrappers = subProviderWrappers;
    }

    @Override
    public String getName() {
        return "Model Process";
    }

    @Override
    @Nullable
    protected CompletableFuture<?> runTask(class_7403 cachedOutput, Path inputRoot, Path target) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Pair<class_2960, String> locEx = this.toResourceLocationAndExtension(inputRoot, target);
            try (FileReader reader = new FileReader(target.toFile());){
                ModelData modelData;
                try (BufferedReader bufReadr = new BufferedReader(reader);){
                    modelData = new ModelData((class_2960)locEx.getLeft(), (JsonObject)GSON.fromJson((Reader)bufReadr, JsonObject.class));
                }
                return modelData;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, class_156.method_18349()).thenComposeAsync(r -> this.runConvert(cachedOutput, (ModelData)r), (Executor)class_156.method_18349())).handleAsync((models, throwable) -> models, (Executor)class_156.method_18349())).thenComposeAsync(models -> {
            if (models != null) {
                ArrayList<CompletableFuture> saves = new ArrayList<CompletableFuture>();
                for (ModelData model : models) {
                    saves.add(class_2405.method_10320((class_7403)cachedOutput, (JsonElement)model.model(), (Path)this.pathProvider.method_44107(model.location())));
                }
                return CompletableFuture.allOf((CompletableFuture[])saves.toArray(CompletableFuture[]::new));
            }
            return CompletableFuture.completedFuture(null);
        }, (Executor)class_156.method_18349());
    }

    @NotNull
    protected CompletableFuture<List<ModelData>> runConvert(class_7403 cachedOutput, ModelData base) {
        CompletionStage<Object> cf = CompletableFuture.completedFuture(ImmutableList.of((Object)base));
        for (ModelProcessSubProviderWrapper subProviderWrapper : this.subProviderWrappers) {
            cf = cf.thenApplyAsync(r -> subProviderWrapper.process(cachedOutput, (List<ModelData>)r), (Executor)class_156.method_18349());
        }
        return cf;
    }

    public record ModelData(class_2960 location, JsonObject model) {
        public String getName() {
            String[] sp = this.location.method_12832().split("/");
            return sp[sp.length - 1];
        }
    }
}

