/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.item.location;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dev.felnull.otyacraftengine.item.location.PlayerItemLocation;
import dev.felnull.otyacraftengine.item.location.factory.HandItemLocationFactory;
import dev.felnull.otyacraftengine.item.location.factory.PlayerItemLocationFactory;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class PlayerItemLocations {
    private static final BiMap<class_2960, PlayerItemLocationFactory<? extends PlayerItemLocation>> FACTORS = HashBiMap.create();
    public static final HandItemLocationFactory HAND_ITEM = new HandItemLocationFactory();

    public static void init() {
        PlayerItemLocations.register(new class_2960("otyacraftengine", "hand"), HAND_ITEM);
    }

    private static void register(class_2960 location, PlayerItemLocationFactory<? extends PlayerItemLocation> factory) {
        FACTORS.put((Object)location, factory);
    }

    public static class_2960 getResourceLocationByFactory(PlayerItemLocationFactory<? extends PlayerItemLocation> factory) {
        return (class_2960)FACTORS.inverse().get(factory);
    }

    public static class_2487 saveToTag(PlayerItemLocation location) {
        class_2960 rl = location.getFactory().getLocation();
        if (rl == null) {
            throw new IllegalArgumentException("Unregistered player item location");
        }
        class_2487 tag = new class_2487();
        tag.method_10582("id", rl.toString());
        tag.method_10566("data", (class_2520)location.createTag());
        return tag;
    }

    public static PlayerItemLocation loadFromTag(class_2487 tag) {
        class_2960 rl = new class_2960(tag.method_10558("id"));
        PlayerItemLocationFactory factory = (PlayerItemLocationFactory)FACTORS.get((Object)rl);
        if (factory == null) {
            throw new IllegalArgumentException("Unregistered player item location");
        }
        return factory.create(tag.method_10562("data"));
    }
}

